/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.persistence.internal;

import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class LogFileWriter {
    public static final String TAG_PERSISTENCE_FILE = "persistenceFile";
    public static final String TAG_PERSISTENCE_HEADER = "header";
    public static final String TAG_CONNECTION_UID = "uid";
    public static final String TAG_FIRST_TIMESTAMP = "firstTimestamp";
    public static final String TAG_ATTRIBUTE_MAPPING = "attributeToIdMapping";
    public static final String TAG_QUALIFIED_NAME = "attributeName";
    public static final String TAG_ATTRIBUTE_ID = "attributeId";
    public static final String TAG_PERSISTENT_DATA = "persistentData";
    public static final String TAG_PERSISTED_VALUE = "value";
    public static final String ATTRIBUTE_JMXATTRIBUTE_ID = "id";
    public static final String ATTRIBUTE_TIMESTAMP = "time";
    public static final String ATTRIBUTE_ISNULL = "isNull";
    public static final String TAG_ATTRIBUTE_TYPE = "attributeType";
    private static final float approximateCompressionFactor = 0.085f;
    private final File javaFile;
    private BufferedWriter currentWriter;
    private Map<IMRIMetaData, String> attributeInfosToIdsMap;
    private final String connectionUid;
    private boolean firstWrite;
    private long uncompressedBytesWritten;
    private int indentationSteps = 0;
    private boolean lastStarted;

    public LogFileWriter(String uid, File file) throws IOException {
        this.connectionUid = uid;
        this.javaFile = file;
        this.firstWrite = true;
    }

    public void setAttributesInfosToIdsMap(Map<IMRIMetaData, String> attributeNamesToIdMap) {
        this.attributeInfosToIdsMap = attributeNamesToIdMap;
    }

    public void writeEvent(MRIValueEvent e) throws IOException {
        String[] xmlAttributeValues;
        String[] xmlAttributes;
        StringBuffer writeBuffer = new StringBuffer();
        if (this.firstWrite) {
            this.currentWriter = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(this.javaFile))));
            this.writeHeader(e.getTimestamp(), writeBuffer);
            this.startElement(TAG_PERSISTENT_DATA, writeBuffer);
            this.firstWrite = false;
        }
        IMRIMetaData info = MRIMetaDataToolkit.getAttributeInfo(e.getConnectionHandle(), e.getSubscriptionAttribute());
        String attributeId = this.attributeInfosToIdsMap.get(info);
        if (e.getValue() != null) {
            xmlAttributes = new String[]{ATTRIBUTE_JMXATTRIBUTE_ID, ATTRIBUTE_TIMESTAMP};
            xmlAttributeValues = new String[]{attributeId, Long.toString(e.getTimestamp())};
        } else {
            xmlAttributes = new String[]{ATTRIBUTE_JMXATTRIBUTE_ID, ATTRIBUTE_TIMESTAMP, ATTRIBUTE_ISNULL};
            xmlAttributeValues = new String[]{attributeId, Long.toString(e.getTimestamp()), Boolean.TRUE.toString()};
        }
        this.startElement(TAG_PERSISTED_VALUE, xmlAttributes, xmlAttributeValues, writeBuffer);
        if (e.getValue() != null) {
            writeBuffer.append(e.getValue().toString());
        }
        this.endElement(TAG_PERSISTED_VALUE, writeBuffer);
        this.currentWriter.write(writeBuffer.toString());
        this.uncompressedBytesWritten += (long)writeBuffer.length();
    }

    public void close() throws IOException {
        if (this.currentWriter != null) {
            StringBuffer buf = new StringBuffer();
            this.endElement(TAG_PERSISTENT_DATA, buf);
            this.endElement(TAG_PERSISTENCE_FILE, buf);
            this.currentWriter.write(buf.toString());
            this.currentWriter.flush();
            this.currentWriter.close();
        }
    }

    private void writeHeader(long firstTimestamp, StringBuffer buf) {
        buf.append("<?xml version=\"1.0\"?>");
        this.lastStarted = true;
        this.startElement(TAG_PERSISTENCE_FILE, buf);
        this.startElement(TAG_PERSISTENCE_HEADER, buf);
        this.startElement(TAG_CONNECTION_UID, buf);
        buf.append(this.connectionUid);
        this.endElement(TAG_CONNECTION_UID, buf);
        this.startElement(TAG_FIRST_TIMESTAMP, buf);
        buf.append(firstTimestamp);
        this.endElement(TAG_FIRST_TIMESTAMP, buf);
        for (IMRIMetaData info : this.attributeInfosToIdsMap.keySet()) {
            String type = info.getValueType();
            this.startElement(TAG_ATTRIBUTE_MAPPING, buf);
            this.startElement(TAG_QUALIFIED_NAME, buf);
            buf.append(info.getMRI().getQualifiedName());
            this.endElement(TAG_QUALIFIED_NAME, buf);
            this.startElement(TAG_ATTRIBUTE_TYPE, buf);
            buf.append(type);
            this.endElement(TAG_ATTRIBUTE_TYPE, buf);
            this.startElement(TAG_ATTRIBUTE_ID, buf);
            buf.append(this.attributeInfosToIdsMap.get(info));
            this.endElement(TAG_ATTRIBUTE_ID, buf);
            this.endElement(TAG_ATTRIBUTE_MAPPING, buf);
        }
        this.endElement(TAG_PERSISTENCE_HEADER, buf);
    }

    private void startElement(String elementName, StringBuffer dest) {
        this.startElement(elementName, null, null, dest);
    }

    private void startElement(String elementName, String[] attributes, String[] attributeValues, StringBuffer dest) {
        if (this.lastStarted) {
            dest.append('\n');
        }
        int i = 0;
        while (i < this.indentationSteps) {
            dest.append('\t');
            ++i;
        }
        dest.append('<');
        dest.append(elementName);
        if (attributes != null && attributes.length > 0) {
            i = 0;
            while (i < attributes.length) {
                dest.append(' ');
                dest.append(attributes[i]);
                dest.append("=\"");
                dest.append(attributeValues[i]);
                dest.append('\"');
                ++i;
            }
        }
        dest.append('>');
        this.lastStarted = true;
        ++this.indentationSteps;
    }

    private void endElement(String elementName, StringBuffer dest) {
        --this.indentationSteps;
        if (!this.lastStarted) {
            int i = 0;
            while (i < this.indentationSteps) {
                dest.append('\t');
                ++i;
            }
        }
        dest.append("</");
        dest.append(elementName);
        dest.append('>');
        dest.append('\n');
        this.lastStarted = false;
    }

    public long getApproximateSize() {
        long smallApproximation = (long)((float)this.uncompressedBytesWritten * 0.085f);
        if (smallApproximation < 100000L) {
            return smallApproximation;
        }
        if (this.javaFile.exists()) {
            return this.javaFile.length();
        }
        return 0L;
    }

    public String toString() {
        return this.javaFile != null ? this.javaFile.getPath() : String.valueOf(this.javaFile);
    }
}

