/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.persistence.internal;

import com.jrockit.mc.rjmx.persistence.internal.PersistedEvent;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class PersistedData {
    private final HashMap<MRI, ArrayList<PersistedEvent>> attributeDescriptorsToEventLists;
    private final long from;
    private final long msPerPixel;
    private long currentPixel;
    private final HashMap<MRI, PersistedEvent[]> coalescedData;

    public PersistedData(long from, long to, long msPerPixel) {
        this.from = from;
        this.msPerPixel = msPerPixel;
        this.attributeDescriptorsToEventLists = new HashMap();
        this.coalescedData = new HashMap();
    }

    void coalesceAndAddEvent(PersistedEvent e) {
        PersistedEvent[] extremesInsidePixel;
        MRI attributeDescriptor = e.getSubscriptionAttribute();
        long timestamp = e.getTimestamp();
        long eventPixel = (timestamp - this.from) / this.msPerPixel;
        if (eventPixel > this.currentPixel && !this.coalescedData.isEmpty()) {
            this.writeCoalescedData();
            this.currentPixel = eventPixel;
        }
        if ((extremesInsidePixel = this.coalescedData.get(attributeDescriptor)) == null) {
            extremesInsidePixel = new PersistedEvent[4];
            this.coalescedData.put(attributeDescriptor, extremesInsidePixel);
        }
        Number value = (Number)e.getValue();
        if (extremesInsidePixel[0] == null || extremesInsidePixel[0].getTimestamp() > e.getTimestamp()) {
            extremesInsidePixel[0] = e;
        }
        if (extremesInsidePixel[1] == null || ((Number)extremesInsidePixel[1].getValue()).doubleValue() > value.doubleValue()) {
            extremesInsidePixel[1] = e;
        }
        if (extremesInsidePixel[2] == null || ((Number)extremesInsidePixel[2].getValue()).doubleValue() < value.doubleValue()) {
            extremesInsidePixel[2] = e;
        }
        if (extremesInsidePixel[3] == null || extremesInsidePixel[3].getTimestamp() < e.getTimestamp()) {
            extremesInsidePixel[3] = e;
        }
    }

    void finishWriting() {
        this.writeCoalescedData();
    }

    private void writeCoalescedData() {
        for (MRI descriptor : this.coalescedData.keySet()) {
            ArrayList<PersistedEvent> uniqueEvents = new ArrayList<PersistedEvent>();
            PersistedEvent[] persistedEventArray = this.coalescedData.get(descriptor);
            int n = persistedEventArray.length;
            int n2 = 0;
            while (n2 < n) {
                PersistedEvent e = persistedEventArray[n2];
                if (!uniqueEvents.contains(e)) {
                    uniqueEvents.add(e);
                }
                ++n2;
            }
            Collections.sort(uniqueEvents, new TimeComparator());
            ArrayList<PersistedEvent> list = this.attributeDescriptorsToEventLists.get(descriptor);
            if (list == null) {
                list = new ArrayList();
                this.attributeDescriptorsToEventLists.put(descriptor, list);
            }
            list.addAll(uniqueEvents);
        }
        this.coalescedData.clear();
    }

    public Set<MRI> getAttributeDescriptorSet() {
        return this.attributeDescriptorsToEventLists.keySet();
    }

    public List<PersistedEvent> getAttributeEvents(MRI descriptor) {
        return this.attributeDescriptorsToEventLists.get(descriptor);
    }

    private static class TimeComparator
    implements Comparator<Object> {
        private TimeComparator() {
        }

        @Override
        public int compare(Object arg0, Object arg1) {
            return (int)(((PersistedEvent)arg0).getTimestamp() - ((PersistedEvent)arg1).getTimestamp());
        }
    }
}

