/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.persistence.internal;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public abstract class PersistenceFileManager {
    protected String connectionUid;
    private File currentPersistenceDirectory;
    protected String prefix;
    protected static final HashMap<String, LogFileOrderLock> fileOrderLockMap = new HashMap();
    protected static final String TAG_ATTRIBUTE_BUNDLE = "attributeBundle";
    protected static final String TAG_META_DATA = "metaData";
    protected static final String TAG_ATTRIBUTE_BUNDLES = "attributeBundles";
    protected static final String TAG_ATTRIBUTE_DESCRIPTORS = "attributeDescriptors";

    public PersistenceFileManager(String uid, File persistenceDirectory) {
        this.connectionUid = uid;
        this.prefix = PersistenceFileManager.makeSafeFileName(this.connectionUid);
        this.setCurrentPersistenceDirectory(persistenceDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFileOrderLock(File persistenceDirectory) {
        HashMap<String, LogFileOrderLock> hashMap = fileOrderLockMap;
        synchronized (hashMap) {
            String lockKey = this.formulateLockKey(persistenceDirectory);
            if (!fileOrderLockMap.containsKey(lockKey)) {
                fileOrderLockMap.put(lockKey, new LogFileOrderLock());
            }
        }
    }

    private String formulateLockKey(File persistenceDirectory) {
        return String.valueOf(persistenceDirectory.getAbsolutePath()) + this.prefix;
    }

    protected File getCurrentPersistenceDirectory() {
        return this.currentPersistenceDirectory;
    }

    protected void setCurrentPersistenceDirectory(File persistenceDirectory) {
        this.addFileOrderLock(persistenceDirectory);
        this.currentPersistenceDirectory = persistenceDirectory;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public static String getSuffix() {
        return ".log_gz";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getFileOrderLock() {
        HashMap<String, LogFileOrderLock> hashMap = fileOrderLockMap;
        synchronized (hashMap) {
            return fileOrderLockMap.get(this.formulateLockKey(this.getCurrentPersistenceDirectory()));
        }
    }

    protected long extractFileIndex(String name) {
        String indexString = name.substring(name.lastIndexOf(95, name.length() - PersistenceFileManager.getSuffix().length()) + 1, name.length() - PersistenceFileManager.getSuffix().length());
        return Long.parseLong(indexString);
    }

    protected File[] findLogFiles() {
        File[] logFiles = this.getCurrentPersistenceDirectory().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith(String.valueOf(PersistenceFileManager.this.getPrefix()) + '_') && pathname.getName().endsWith(PersistenceFileManager.getSuffix());
            }
        });
        if (logFiles == null) {
            return new File[0];
        }
        Arrays.sort(logFiles, new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                long arg0index = PersistenceFileManager.this.extractFileIndex(((File)arg0).getName());
                long arg1index = PersistenceFileManager.this.extractFileIndex(((File)arg1).getName());
                return arg1index > arg0index ? 1 : (arg0index == arg1index ? 0 : -1);
            }
        });
        return logFiles;
    }

    protected String getMetaDataFileName() {
        return String.valueOf(this.getPrefix()) + "_metadata.xml";
    }

    static String makeSafeFileName(String name) {
        return name.trim().replace(':', '-').replace(' ', '-').replace('/', '-').replace('\\', '-');
    }

    static class LogFileOrderLock {
        LogFileOrderLock() {
        }
    }
}

