/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.persistence.internal;

import com.jrockit.mc.common.xml.ClassFactory;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.persistence.internal.AttributeBundleImporter;
import com.jrockit.mc.rjmx.persistence.internal.LogFileReader;
import com.jrockit.mc.rjmx.persistence.internal.PersistedData;
import com.jrockit.mc.rjmx.persistence.internal.PersistedEvent;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceFileManager;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.Range;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PersistenceReadManager
extends PersistenceFileManager {
    public PersistenceReadManager(String uid, File persistenceDirectory) {
        super(uid, persistenceDirectory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Range readPersistedRange() throws IOException {
        Object object = this.getFileOrderLock();
        synchronized (object) {
            Range range = new Range();
            File[] logFiles = this.findLogFiles();
            int i = logFiles.length - 1;
            while (i >= 0) {
                long timestamp = this.readFirstTimestamp(logFiles[i]);
                if (timestamp >= 0L) {
                    range.setMinValue(timestamp);
                    range.setMaxValue(timestamp);
                    break;
                }
                --i;
            }
            if (range.getMinValue() == null) {
                return null;
            }
            File[] fileArray = logFiles;
            int n = logFiles.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return null;
                }
                File logFile = fileArray[n2];
                LogFileReader reader = null;
                try {
                    reader = new LogFileReader(logFile);
                    long timestamp = this.readLastTimestamp(reader);
                    if (timestamp >= 0L) {
                        range.setMaxValue(timestamp);
                        Range range2 = range;
                        return range2;
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                ++n2;
            }
        }
    }

    public HashMap<MRI, Range> readRangesForAllAttributes() {
        HashMap<MRI, Range> attributeToRangeMap = new HashMap<MRI, Range>();
        HashMap<MRI, File> attributeToLastFileMap = new HashMap<MRI, File>();
        File[] logFiles = this.findLogFiles();
        int i = logFiles.length - 1;
        while (i >= 0) {
            block33: {
                LogFileReader reader = null;
                try {
                    try {
                        reader = new LogFileReader(logFiles[i]);
                        long timestamp = reader.getHeader().getFirstTimestamp();
                        Set<MRI> attributesInFile = reader.getHeader().getAttributesInFile();
                        for (MRI descriptor : attributesInFile) {
                            attributeToLastFileMap.put(descriptor, logFiles[i]);
                            if (timestamp < 0L) continue;
                            Range range = attributeToRangeMap.get(descriptor);
                            if (range == null) {
                                range = new Range();
                                attributeToRangeMap.put(descriptor, range);
                                range.setMinValue(timestamp);
                                range.setMaxValue(timestamp);
                                continue;
                            }
                            range.update(timestamp);
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                            break block33;
                        }
                        catch (IOException iOException2) {}
                        break block33;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            --i;
        }
        HashMap<File, Long> fileToLastTimestampCache = new HashMap<File, Long>();
        for (Map.Entry entry : attributeToLastFileMap.entrySet()) {
            File logFile = (File)entry.getValue();
            Long lastTimestamp = (Long)fileToLastTimestampCache.get(logFile);
            if (lastTimestamp == null) {
                block35: {
                    LogFileReader reader = null;
                    try {
                        try {
                            reader = new LogFileReader(logFile);
                            lastTimestamp = this.readLastTimestamp(reader);
                        }
                        catch (IOException iOException) {
                            try {
                                if (reader != null) {
                                    reader.close();
                                }
                                break block35;
                            }
                            catch (IOException iOException3) {}
                            break block35;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                reader.close();
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (lastTimestamp == null) {
                    lastTimestamp = -1L;
                }
                fileToLastTimestampCache.put(logFile, lastTimestamp);
            }
            if (lastTimestamp < 0L) continue;
            Range range = attributeToRangeMap.get(entry.getKey());
            range.update(lastTimestamp);
        }
        return attributeToRangeMap;
    }

    public Range readPersistedRangeForAttributes(MRI[] attributes) {
        HashMap<MRI, Range> attributeToRangeMap = this.readRangesForAllAttributes();
        Range totalRange = null;
        MRI[] mRIArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            MRI attribute = mRIArray[n2];
            Range rangeForAttribute = attributeToRangeMap.get(attribute);
            if (rangeForAttribute != null) {
                if (totalRange == null) {
                    totalRange = new Range();
                    totalRange.setMinValue(rangeForAttribute.getMinValue());
                    totalRange.setMaxValue(rangeForAttribute.getMaxValue());
                } else {
                    totalRange.update(rangeForAttribute.getMinValue());
                    totalRange.update(rangeForAttribute.getMaxValue());
                }
            }
            ++n2;
        }
        return totalRange;
    }

    private long readLastTimestamp(LogFileReader reader) throws IOException {
        PersistedEvent event;
        long timestamp = -1L;
        while ((event = reader.readNextEvent()) != null) {
            if (event.getTimestamp() <= timestamp) continue;
            timestamp = event.getTimestamp();
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistedData readPersistedData(long from, long to, long msPerPixel) throws IOException {
        Object object = this.getFileOrderLock();
        synchronized (object) {
            File[] filesToRead;
            PersistedData events = new PersistedData(from, to, msPerPixel);
            File[] fileArray = filesToRead = this.findFilesToRead(from, to);
            int n = filesToRead.length;
            int n2 = 0;
            while (n2 < n) {
                File element = fileArray[n2];
                LogFileReader reader = null;
                try {
                    PersistedEvent e;
                    reader = new LogFileReader(element);
                    while ((e = reader.readNextEvent()) != null) {
                        if (e.getTimestamp() <= to && e.getTimestamp() >= from && e.getValue() != null) {
                            events.coalesceAndAddEvent(e);
                            continue;
                        }
                        if (e.getTimestamp() <= to) continue;
                        break;
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                ++n2;
            }
            events.finishWriting();
            return events;
        }
    }

    private File[] findFilesToRead(long from, long to) throws IOException {
        File[] logFiles = this.findLogFiles();
        ArrayList<File> filesToRead = new ArrayList<File>();
        int i = logFiles.length - 1;
        while (i >= 0) {
            long firstTimestamp = this.readFirstTimestamp(logFiles[i]);
            if (firstTimestamp >= 0L) {
                if (firstTimestamp > to) break;
                if (firstTimestamp < from) {
                    filesToRead.clear();
                    filesToRead.add(logFiles[i]);
                } else {
                    filesToRead.add(logFiles[i]);
                }
            }
            --i;
        }
        return filesToRead.toArray(new File[filesToRead.size()]);
    }

    private long readFirstTimestamp(File logFile) throws IOException {
        LogFileReader reader = null;
        try {
            long timestamp;
            reader = new LogFileReader(logFile);
            long l = timestamp = reader.getHeader().getFirstTimestamp();
            return l;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public void initializePersistedAttributeBundles(AttributeBundleImporter factory) throws IOException {
        File f = new File(this.getCurrentPersistenceDirectory(), this.getMetaDataFileName());
        if (f.isFile()) {
            try {
                Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(f);
                ArrayList<Element> bundleCollection = this.getChildElements(doc, "attributeBundles");
                if (bundleCollection.isEmpty()) {
                    return;
                }
                ArrayList<Element> bundles = this.getChildElements(bundleCollection.get(0), "attributeBundle");
                int i = 0;
                while (i < bundles.size()) {
                    Element bundle = bundles.get(i);
                    ArrayList<Element> l = this.getChildElements(bundle, "metaData");
                    if (l.size() > 0) {
                        Element metaData = l.get(0);
                        MRI[] attributeDescriptors = (MRI[])XmlToolkit.getNameTypeValue((Element)bundle, (String)"attributeDescriptors", (ClassFactory)new MRIClassFactory());
                        factory.createAndInitializeBundleFromXml(metaData, attributeDescriptors);
                    }
                    ++i;
                }
            }
            catch (SAXException e) {
                IOException ioe = new IOException("Problem initializing chart.");
                ioe.initCause(e);
                throw ioe;
            }
            catch (ParserConfigurationException e) {
                IOException ioe = new IOException("Problem initializing chart.");
                ioe.initCause(e);
                throw ioe;
            }
        }
    }

    private ArrayList<Element> getChildElements(Node parentNode, String tag) {
        ArrayList<Element> childElements = new ArrayList<Element>();
        NodeList l = parentNode.getChildNodes();
        int i = 0;
        while (i < l.getLength()) {
            Element e;
            if (l.item(i) instanceof Element && (e = (Element)l.item(i)).getNodeName().equals(tag)) {
                childElements.add(e);
            }
            ++i;
        }
        return childElements;
    }

    private static class MRIClassFactory
    implements ClassFactory {
        private MRIClassFactory() {
        }

        public Class<?> forName(String name) throws ClassNotFoundException {
            if (MRI.class.getName().equals(name)) {
                return MRI.class;
            }
            if (MRI[].class.getName().equals(name)) {
                return MRI[].class;
            }
            throw new ClassNotFoundException("This factory can only create the MRI class!");
        }
    }
}

