/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.persistence.internal;

import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.internal.PreferencesKeys;
import java.io.File;
import java.util.Observable;
import java.util.logging.Level;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PersistenceSettings
extends Observable {
    public static final boolean DEFAULT_ENABLE_LOG_ROTATION = true;
    public static final boolean DEFAULT_ENABLE_LIMIT_MAXIMUM_LOG_SIZE = false;
    public static final long DEFAULT_MAX_FILE_SIZE_KB = 100L;
    public static final long DEFAULT_MAX_TOTAL_LOG_SIZE_MB = 100L;
    private static File defaultPersistenceDirectory = new File(PreferencesKeys.DEFAULT_PERSISTENCE_PATH);
    public static final String PROPERTY_BOOLEAN_ENABLE_LOG_ROTATION = "rjmx.services.persistence.log.rotation";
    public static final String PROPERTY_BOOLEAN_ENABLE_LOG_SIZE_LIMIT = "rjmx.services.persistence.log.limit";
    public static final String PROPERTY_LONG_LOG_ROTATION_LIMIT_KB = "rjmx.services.persistence.log.rotation.limit";
    public static final String PROPERTY_LONG_MAX_TOTAL_LOG_SIZE_MB = "rjmx.services.persistence.log.limit.max.size";
    public static final String PROPERTY_PATH_PERSISTANCE_DIRECTORY = "rjmx.services.persistence.directory";
    private final IEclipsePreferences persistencePreferences;
    private volatile long maxFileSize = 102400L;
    private volatile long maxTotalLogSize = 0x6400000L;
    private volatile boolean enableLogRotation = true;
    private volatile boolean enableLimitMaximumLogSize = false;
    private volatile File persistenceDirectory = defaultPersistenceDirectory;

    public static IEclipsePreferences createDefaultPersistanceSettings(String ID) {
        InstanceScope scope = new InstanceScope();
        IEclipsePreferences preferences = scope.getNode(ID);
        preferences.putBoolean(PROPERTY_BOOLEAN_ENABLE_LOG_ROTATION, true);
        preferences.putBoolean(PROPERTY_BOOLEAN_ENABLE_LOG_SIZE_LIMIT, false);
        preferences.putLong(PROPERTY_LONG_LOG_ROTATION_LIMIT_KB, 100L);
        preferences.putLong(PROPERTY_LONG_MAX_TOTAL_LOG_SIZE_MB, 100L);
        preferences.put(PROPERTY_PATH_PERSISTANCE_DIRECTORY, defaultPersistenceDirectory.getPath());
        return preferences;
    }

    public static void setDefaultPersistanceDirectory(File persistanceDirectory) {
        defaultPersistenceDirectory = persistanceDirectory;
    }

    public PersistenceSettings(IEclipsePreferences persistencePreferences) {
        this.persistencePreferences = persistencePreferences;
        this.persistencePreferences.addPreferenceChangeListener(this.createPreferenceChangeListener());
        this.initializeSettings();
    }

    private void initializeSettings() {
        this.updateEnableLogRotation(this.persistencePreferences.getBoolean(PROPERTY_BOOLEAN_ENABLE_LOG_ROTATION, true));
        this.updateEnableLimitMaximumLogSize(this.persistencePreferences.getBoolean(PROPERTY_BOOLEAN_ENABLE_LOG_SIZE_LIMIT, false));
        this.updateMaxFileSize(this.persistencePreferences.getLong(PROPERTY_LONG_LOG_ROTATION_LIMIT_KB, 100L) * 1024L);
        this.updateMaxTotalLogSize(this.persistencePreferences.getLong(PROPERTY_LONG_MAX_TOTAL_LOG_SIZE_MB, 100L) * 1024L * 1024L);
        String persistanceDirectory = this.persistencePreferences.get(PROPERTY_PATH_PERSISTANCE_DIRECTORY, null);
        if (persistanceDirectory != null) {
            this.updatePersistenceDirectory(new File(persistanceDirectory));
        }
    }

    private IEclipsePreferences.IPreferenceChangeListener createPreferenceChangeListener() {
        return new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                if (event.getNewValue() == null) {
                    RJMXPlugin.getDefault().getLogger().log(Level.WARNING, "New value is null for key '" + event.getKey() + "'!");
                    return;
                }
                String key = event.getKey();
                String newValue = event.getNewValue().toString();
                if (key.equals(PersistenceSettings.PROPERTY_BOOLEAN_ENABLE_LOG_ROTATION)) {
                    PersistenceSettings.this.updateEnableLogRotation(Boolean.parseBoolean(newValue));
                } else if (key.equals(PersistenceSettings.PROPERTY_BOOLEAN_ENABLE_LOG_SIZE_LIMIT)) {
                    PersistenceSettings.this.updateEnableLimitMaximumLogSize(Boolean.parseBoolean(newValue));
                } else if (key.equals(PersistenceSettings.PROPERTY_LONG_LOG_ROTATION_LIMIT_KB)) {
                    PersistenceSettings.this.updateMaxFileSize(Long.parseLong(newValue) * 1024L);
                } else if (key.equals(PersistenceSettings.PROPERTY_LONG_MAX_TOTAL_LOG_SIZE_MB)) {
                    PersistenceSettings.this.updateMaxTotalLogSize(Long.parseLong(newValue) * 1024L * 1024L);
                } else if (key.equals(PersistenceSettings.PROPERTY_PATH_PERSISTANCE_DIRECTORY)) {
                    PersistenceSettings.this.updatePersistenceDirectory(new File(newValue));
                }
            }
        };
    }

    public void setPersistenceDirectory(File persistenceDirectory) {
        this.persistencePreferences.put(PROPERTY_PATH_PERSISTANCE_DIRECTORY, persistenceDirectory.getPath());
    }

    private void updatePersistenceDirectory(File persistenceDirectory) {
        if (this.persistenceDirectory == null && persistenceDirectory != null || !this.persistenceDirectory.equals(persistenceDirectory)) {
            this.persistenceDirectory = persistenceDirectory;
            this.setChanged();
        }
    }

    private void updateMaxTotalLogSize(long maxTotalLogSize) {
        if (this.maxTotalLogSize != maxTotalLogSize) {
            this.maxTotalLogSize = maxTotalLogSize;
            this.setChanged();
        }
    }

    private void updateMaxFileSize(long maxFileSize) {
        if (this.maxFileSize != maxFileSize) {
            this.maxFileSize = maxFileSize;
            this.setChanged();
        }
    }

    private void updateEnableLogRotation(boolean enable) {
        if (this.enableLogRotation != enable) {
            this.enableLogRotation = enable;
            this.setChanged();
        }
    }

    private void updateEnableLimitMaximumLogSize(boolean limit) {
        if (this.enableLimitMaximumLogSize != limit) {
            this.enableLimitMaximumLogSize = limit;
            this.setChanged();
        }
    }

    public long getMaxTotalLogSize() {
        return this.maxTotalLogSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public boolean isLogRotationEnabled() {
        return this.enableLogRotation;
    }

    public boolean isMaximumLogSizeEnabled() {
        return this.enableLimitMaximumLogSize;
    }

    public File getPersistenceDirectory() {
        return this.persistenceDirectory;
    }
}

