/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.persistence.internal;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.persistence.internal.AttributeBundleModel;
import com.jrockit.mc.rjmx.persistence.internal.LogFileWriter;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceFileManager;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceSettings;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.util.internal.XmlSerializerToolkit;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class PersistenceWriteManager
extends PersistenceFileManager
implements Observer {
    private final HashMap<IMRIMetaData, String> attributeInfosToIdsMap;
    private LogFileWriter currentFile;
    private final ArrayList<File> nonCurrentLogFiles;
    private long nonCurrentLogFilesSize;
    private boolean persistenceSetChanged;
    private boolean directoryChange;
    private final PersistenceSettings persistenceSettings;
    private final String description;

    public PersistenceWriteManager(String uid, String description, PersistenceSettings persistenceSettings) {
        super(uid, persistenceSettings.getPersistenceDirectory());
        this.persistenceSettings = persistenceSettings;
        persistenceSettings.addObserver(this);
        this.attributeInfosToIdsMap = new HashMap();
        this.nonCurrentLogFiles = new ArrayList();
        this.description = description;
    }

    @Override
    public synchronized void update(Observable o, Object arg) {
        this.persistenceSetChanged = true;
        this.directoryChange = !this.getCurrentPersistenceDirectory().equals(this.persistenceSettings.getPersistenceDirectory());
    }

    public synchronized void setAttributesToPersist(IMRIMetaData[] attributes) {
        this.persistenceSetChanged = true;
        this.attributeInfosToIdsMap.clear();
        int i = 0;
        while (i < attributes.length) {
            this.attributeInfosToIdsMap.put(attributes[i], Integer.toString(i));
            ++i;
        }
    }

    public synchronized void writeAttributeEvent(MRIValueEvent e) throws IOException {
        if (this.currentFile == null || this.persistenceSetChanged) {
            this.rotate();
            this.persistenceSetChanged = false;
        }
        this.currentFile.writeEvent(e);
        if (this.persistenceSettings.isLogRotationEnabled() && this.currentFile.getApproximateSize() > this.persistenceSettings.getMaxFileSize()) {
            this.rotate();
        }
        if (this.persistenceSettings.isMaximumLogSizeEnabled() && !this.ensureLogFilesFitTotalLogSize()) {
            this.rotate();
            this.ensureLogFilesFitTotalLogSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rotate() throws IOException {
        if (this.currentFile != null) {
            this.currentFile.close();
            this.currentFile = null;
        }
        Object object = this.getFileOrderLock();
        synchronized (object) {
            if (this.directoryChange) {
                this.setCurrentPersistenceDirectory(this.persistenceSettings.getPersistenceDirectory());
            }
            this.nonCurrentLogFiles.clear();
            this.nonCurrentLogFiles.addAll(Arrays.asList(this.findLogFiles()));
            this.directoryChange = false;
            this.nonCurrentLogFilesSize = 0L;
            for (File f : this.nonCurrentLogFiles) {
                this.nonCurrentLogFilesSize += f.length();
            }
            long lastIndex = this.nonCurrentLogFiles.size() == 0 ? -1L : this.extractFileIndex(this.nonCurrentLogFiles.get(0).getName());
            this.currentFile = new LogFileWriter(this.connectionUid, this.createLogFileName(lastIndex + 1L));
            this.currentFile.setAttributesInfosToIdsMap(this.attributeInfosToIdsMap);
        }
    }

    private boolean ensureLogFilesFitTotalLogSize() throws IOException {
        long currentFileSize = this.currentFile.getApproximateSize();
        while (currentFileSize + this.nonCurrentLogFilesSize > this.persistenceSettings.getMaxTotalLogSize()) {
            if (this.nonCurrentLogFiles.size() > 0) {
                File f = this.nonCurrentLogFiles.get(this.nonCurrentLogFiles.size() - 1);
                long removeSize = f.length();
                if (!f.delete() && f.exists()) {
                    throw new IOException("Unable to delete log file " + f.getName());
                }
                this.nonCurrentLogFilesSize -= removeSize;
                this.nonCurrentLogFiles.remove(this.nonCurrentLogFiles.size() - 1);
                continue;
            }
            return false;
        }
        return true;
    }

    private File createLogFileName(long index) throws IOException {
        return new File(this.getCurrentPersistenceDirectory(), String.valueOf(this.getPrefix()) + '_' + PersistenceWriteManager.makeSafeFileName(this.description) + '_' + Long.toString(index) + PersistenceWriteManager.getSuffix());
    }

    public synchronized void close() throws IOException {
        this.persistenceSettings.deleteObserver(this);
        if (this.currentFile != null) {
            this.currentFile.close();
            this.currentFile = null;
        }
    }

    public synchronized void writeMetaData(Map<AttributeBundleModel, Set<MRI>> persistedBundles) throws IOException {
        File directory = this.getCurrentPersistenceDirectory();
        String fileName = this.getMetaDataFileName();
        File metaDataFile = new File(directory, fileName);
        boolean writingToTempFile = false;
        if (metaDataFile.exists()) {
            writingToTempFile = true;
            metaDataFile = File.createTempFile("metadata_" + this.prefix + '_', ".tmp", directory);
        }
        FileOutputStream fout = null;
        try {
            try {
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document d = builder.newDocument();
                Element rootElement = d.createElement("attributeBundles");
                d.appendChild(rootElement);
                for (Map.Entry<AttributeBundleModel, Set<MRI>> persistedBundle : persistedBundles.entrySet()) {
                    Element bundleElement = d.createElement("attributeBundle");
                    rootElement.appendChild(bundleElement);
                    Element metaDataElement = d.createElement("metaData");
                    bundleElement.appendChild(metaDataElement);
                    Element bundleNode = persistedBundle.getKey().createBundleMetaData(metaDataElement);
                    for (MRI descriptor : persistedBundle.getValue()) {
                        XmlSerializerToolkit.exportToXml(descriptor, bundleNode);
                    }
                    XmlToolkit.setNameTypeValue((Element)bundleElement, (String)"attributeDescriptors", (Object)persistedBundle.getValue().toArray(new MRI[persistedBundle.getValue().size()]));
                }
                fout = new FileOutputStream(metaDataFile);
                TransformerFactory.newInstance().newTransformer().transform(new DOMSource(d), new StreamResult(fout));
                fout.close();
            }
            catch (ParserConfigurationException e) {
                IOException ioe = new IOException("Problem writing meta data.");
                ioe.initCause(e);
                throw ioe;
            }
            catch (TransformerConfigurationException e) {
                IOException ioe = new IOException("Problem writing meta data.");
                ioe.initCause(e);
                throw ioe;
            }
            catch (TransformerException e) {
                IOException ioe = new IOException("Problem writing meta data.");
                ioe.initCause(e);
                throw ioe;
            }
            catch (TransformerFactoryConfigurationError e) {
                IOException ioe = new IOException("Problem writing meta data.");
                ioe.initCause(e);
                throw ioe;
            }
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently(fout);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)fout);
        if (writingToTempFile) {
            File oldMetaDataFile = new File(directory, fileName);
            if ((!oldMetaDataFile.exists() || oldMetaDataFile.delete()) && metaDataFile.renameTo(oldMetaDataFile)) {
                return;
            }
            throw new IOException("Could not replace old meta data file " + oldMetaDataFile.getAbsolutePath() + " with new data file " + metaDataFile.getAbsolutePath());
        }
    }
}

