/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.persistence.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.persistence.internal.AggregatorClosedException;
import com.jrockit.mc.rjmx.persistence.internal.AttributeBundleModel;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceSettings;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceWriteManager;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.storage.internal.AttributeStorageToolkit;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PersistentDataAggregator {
    private PersistenceWriteManager writeManager;
    private final Set<IMRIMetaData> persistentAttributeInfos;
    private final IConnectionHandle registeredConnectionHandle;
    private final Map<AttributeBundleModel, Set<MRI>> persistedBundles;
    private final Map<AttributeBundleModel, List<MRI>> currentBundles;
    private boolean allowChangingMetaData = false;
    private final PersistenceSettings persistenceSettings;

    public PersistentDataAggregator(IConnectionHandle handle, PersistenceSettings settings) {
        this.registeredConnectionHandle = handle;
        this.persistentAttributeInfos = new HashSet<IMRIMetaData>();
        this.persistedBundles = new HashMap<AttributeBundleModel, Set<MRI>>();
        this.currentBundles = new HashMap<AttributeBundleModel, List<MRI>>();
        this.writeManager = new PersistenceWriteManager(handle.getServerDescriptor().getGUID(), handle.getServerDescriptor().getDisplayName(), settings);
        this.persistenceSettings = settings;
    }

    public void close() throws IOException {
        this.persistMetaData();
        this.writeManager.close();
        this.writeManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enablePersistence(AttributeBundleModel bundle, MRI[] attributes) throws IOException {
        PersistentDataAggregator persistentDataAggregator = this;
        synchronized (persistentDataAggregator) {
            this.allowChangingMetaData = true;
            List<MRI> attributeList = Arrays.asList(attributes);
            this.persistBundleAttributes(bundle, attributeList);
            this.currentBundles.put(bundle, attributeList);
            this.updateAttributesPersistence(this.getMetaDataService());
            this.persistMetaData();
        }
    }

    private void persistBundleAttributes(AttributeBundleModel bundle, List<MRI> attributes) {
        Set<MRI> persistedMRI = this.persistedBundles.get(bundle);
        if (persistedMRI == null) {
            persistedMRI = new HashSet<MRI>();
            this.persistedBundles.put(bundle, persistedMRI);
        }
        persistedMRI.addAll(attributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disablePersistence(AttributeBundleModel bundle) throws IOException {
        PersistentDataAggregator persistentDataAggregator = this;
        synchronized (persistentDataAggregator) {
            this.allowChangingMetaData = true;
            this.currentBundles.remove(bundle);
            this.updateAttributesPersistence(this.getMetaDataService());
            this.persistMetaData();
            this.writeManager.rotate();
        }
    }

    private IMRIMetaDataService getMetaDataService() {
        return this.registeredConnectionHandle.getServiceOrDummy(IMRIMetaDataService.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reenablePersistence(MRI[] descriptions) throws IOException {
        PersistentDataAggregator persistentDataAggregator = this;
        synchronized (persistentDataAggregator) {
            HashSet<MRI> attributeDescriptorSet = new HashSet<MRI>(Arrays.asList(descriptions));
            this.enableNotAlreadyEnabledAttributes(attributeDescriptorSet, this.getMetaDataService());
        }
    }

    private HashSet<IMRIMetaData> updateAttributesPersistence(IMRIMetaDataService metaDataService) throws IOException {
        HashSet<MRI> attributeDescriptorsInAllBundles = new HashSet<MRI>();
        for (List<MRI> currentBundleMRI : this.currentBundles.values()) {
            attributeDescriptorsInAllBundles.addAll(currentBundleMRI);
        }
        HashSet<IMRIMetaData> changedAttributeInfos = new HashSet<IMRIMetaData>();
        changedAttributeInfos.addAll(this.disableAttributesNotInSet(attributeDescriptorsInAllBundles));
        changedAttributeInfos.addAll(this.enableNotAlreadyEnabledAttributes(attributeDescriptorsInAllBundles, metaDataService));
        return changedAttributeInfos;
    }

    private HashSet<IMRIMetaData> disableAttributesNotInSet(HashSet<MRI> attributeDescriptorSet) throws IOException {
        HashSet<IMRIMetaData> infosToDisable = new HashSet<IMRIMetaData>();
        for (IMRIMetaData imriMetaData : this.persistentAttributeInfos) {
            IMRIMetaData info = imriMetaData;
            if (attributeDescriptorSet.contains(info.getMRI())) continue;
            infosToDisable.add(info);
        }
        if (infosToDisable.size() > 0) {
            this.setPersistenceEnabled(infosToDisable.toArray(new IMRIMetaData[infosToDisable.size()]), false);
        }
        this.updateStoragesForAttributes(infosToDisable.toArray(new IMRIMetaData[infosToDisable.size()]));
        return infosToDisable;
    }

    private void updateStoragesForAttributes(IMRIMetaData[] infosToUpdate) {
        AttributeStorageToolkit.updateStoragesForAttributes(this.registeredConnectionHandle, infosToUpdate);
    }

    private HashSet<IMRIMetaData> enableNotAlreadyEnabledAttributes(HashSet<MRI> attributeDescriptorsInBundles, IMRIMetaDataService metaDataService) throws IOException {
        HashSet<IMRIMetaData> attributeInfosToEnable = new HashSet<IMRIMetaData>();
        for (MRI mri : attributeDescriptorsInBundles) {
            IMRIMetaData info = metaDataService.getMetaData(mri);
            if (this.isPersistenceEnabledFor(info)) continue;
            attributeInfosToEnable.add(info);
        }
        if (attributeInfosToEnable.size() > 0) {
            this.setPersistenceEnabled(attributeInfosToEnable.toArray(new IMRIMetaData[attributeInfosToEnable.size()]), true);
        }
        this.updateStoragesForAttributes(attributeInfosToEnable.toArray(new IMRIMetaData[attributeInfosToEnable.size()]));
        return attributeInfosToEnable;
    }

    private void persistMetaData() throws IOException {
        if (this.allowChangingMetaData) {
            this.writeManager.writeMetaData(this.persistedBundles);
        }
    }

    synchronized void setPersistenceEnabled(IMRIMetaData info, boolean enabled) throws IOException {
        this.setPersistenceEnabled(new IMRIMetaData[]{info}, enabled);
    }

    private synchronized void setPersistenceEnabled(IMRIMetaData[] infos, boolean enabled) throws IOException {
        File persistenceDirectory = this.persistenceSettings.getPersistenceDirectory();
        if (!persistenceDirectory.exists() && !persistenceDirectory.mkdir()) {
            throw new IOException("Persistence directory does not exists and could not be created " + persistenceDirectory.getAbsolutePath());
        }
        if (!persistenceDirectory.isDirectory()) {
            throw new IOException("A file exists with the same name as the persistence directory " + persistenceDirectory.getAbsolutePath());
        }
        boolean persistenceSetChanged = false;
        IMRIMetaData[] iMRIMetaDataArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IMRIMetaData info = iMRIMetaDataArray[n2];
            persistenceSetChanged = enabled ? this.persistentAttributeInfos.add(info) : this.persistentAttributeInfos.remove(info);
            ++n2;
        }
        if (persistenceSetChanged) {
            this.writeManager.setAttributesToPersist(this.persistentAttributeInfos.toArray(new IMRIMetaData[this.persistentAttributeInfos.size()]));
        }
    }

    public synchronized boolean isPersistenceEnabledFor(IMRIMetaData info) {
        return this.persistentAttributeInfos.contains(info);
    }

    public synchronized void addAttributeEvent(MRIValueEvent e) throws IOException {
        if (this.writeManager == null) {
            throw new AggregatorClosedException("Persistence aggregator has been closed.");
        }
        IMRIMetaData info = MRIMetaDataToolkit.getAttributeInfo(e.getConnectionHandle(), e.getSubscriptionAttribute());
        if (this.isPersistenceEnabledFor(info)) {
            this.writeManager.writeAttributeEvent(e);
        }
    }
}

