/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.rjmx.services.flr.IOptionConstraint;
import com.jrockit.mc.rjmx.services.flr.internal.ConversionToolkit;
import com.jrockit.mc.rjmx.services.flr.internal.Converter;
import com.jrockit.mc.rjmx.services.flr.internal.RecordingOptionsToolkit;
import com.jrockit.mc.rjmx.services.flr.internal.ValidationToolkit;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class RecordingOptionsBuilder {
    public static final String RECORDING_OPTIONS_NS = "recordingOption.";
    public static final String KEY_NAME = "recordingOption.name";
    public static final String KEY_DURATION = "recordingOption.duration";
    public static final String KEY_DESTINATION_FILE = "recordingOption.destinationFile";
    public static final String KEY_DESTINATION_COMPRESSED = "recordingOption.destinationCompressed";
    public static final String KEY_START_TIME = "recordingOption.startTime";
    public static final String KEY_MAX_SIZE = "recordingOption.maxSize";
    public static final String KEY_MAX_AGE = "recordingOption.maxAge";
    public static final String KEY_TO_DISK = "recordingOption.toDisk";
    private static final String DEFAULT_NAME = "Unnamed Recording";
    private final Map<String, Object> map = new HashMap<String, Object>();
    private static final Set<String> AVAILABLE_KEYS;

    static {
        HashSet<String> keys = new HashSet<String>();
        keys.add(KEY_DESTINATION_COMPRESSED);
        keys.add(KEY_DESTINATION_FILE);
        keys.add(KEY_DURATION);
        keys.add(KEY_MAX_AGE);
        keys.add(KEY_MAX_SIZE);
        keys.add(KEY_START_TIME);
        keys.add(KEY_TO_DISK);
        keys.add(KEY_NAME);
        AVAILABLE_KEYS = Collections.unmodifiableSet(keys);
    }

    public RecordingOptionsBuilder() {
        this.name(DEFAULT_NAME);
    }

    public static Set<String> getAvailableKeys() {
        return AVAILABLE_KEYS;
    }

    public RecordingOptionsBuilder duration(long duration) {
        this.map.put(KEY_DURATION, duration);
        return this;
    }

    public RecordingOptionsBuilder destinationFile(String fileName) {
        this.map.put(KEY_DESTINATION_FILE, fileName);
        return this;
    }

    public RecordingOptionsBuilder destinationCompressed(boolean compress) {
        this.map.put(KEY_DESTINATION_COMPRESSED, compress);
        return this;
    }

    public RecordingOptionsBuilder startTime(Date startTime) {
        this.map.put(KEY_START_TIME, startTime);
        return this;
    }

    public RecordingOptionsBuilder maxSize(long maxSize) {
        this.map.put(KEY_MAX_SIZE, maxSize);
        return this;
    }

    public RecordingOptionsBuilder maxAge(long maxAge) {
        this.map.put(KEY_MAX_AGE, maxAge);
        return this;
    }

    public RecordingOptionsBuilder name(String name) {
        this.map.put(KEY_NAME, name);
        return this;
    }

    public RecordingOptionsBuilder toDisk(boolean toDisk) {
        this.map.put(KEY_TO_DISK, toDisk);
        return this;
    }

    public RecordingOptionsBuilder fromProperties(Properties props) throws QuantityConversionException {
        for (Object element : props.keySet()) {
            String key = (String)element;
            if (!key.startsWith(RECORDING_OPTIONS_NS)) continue;
            if (!AVAILABLE_KEYS.contains(key)) {
                throw new IllegalArgumentException("The recording option key " + key + " is not known!");
            }
            this.addByKey(key, props.getProperty(key));
        }
        return this;
    }

    public RecordingOptionsBuilder addByKey(String key, String property) throws QuantityConversionException {
        IOptionConstraint<?> optionConstraint = RecordingOptionsToolkit.getRecordingOptionConstraint(key);
        Converter<?> converter = ConversionToolkit.getConverter(optionConstraint);
        this.map.put(key, converter.toServerValue(property));
        return this;
    }

    public Map<String, Object> build() {
        this.fillOutDefaults();
        ValidationToolkit.validate(this.map);
        return this.map;
    }

    private void fillOutDefaults() {
        if (!this.map.containsKey(KEY_TO_DISK)) {
            this.map.put(KEY_TO_DISK, Boolean.FALSE);
        }
        if (!this.map.containsKey(KEY_DESTINATION_COMPRESSED)) {
            this.map.put(KEY_DESTINATION_COMPRESSED, Boolean.TRUE);
        }
        if (!this.map.containsKey(KEY_DURATION)) {
            this.map.put(KEY_DURATION, 30000L);
        }
        if (!this.map.containsKey(KEY_MAX_AGE)) {
            this.map.put(KEY_MAX_AGE, 0L);
        }
        if (!this.map.containsKey(KEY_MAX_SIZE)) {
            this.map.put(KEY_MAX_SIZE, 0L);
        }
    }
}

