/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.util.TimeRangeToolkit;
import com.jrockit.mc.rjmx.services.flr.internal.AbstractConverter;

public class DurationConverter
extends AbstractConverter<Long> {
    private static final String N_A = "N/A";
    private boolean useNanos;

    public DurationConverter(boolean useNanosNotMillis) {
        this.useNanos = useNanosNotMillis;
    }

    @Override
    public Class<Long> getType() {
        return Long.class;
    }

    @Override
    public Long toServerValue(String configString) throws QuantityConversionException {
        if (this.useNanos) {
            return TimeRangeToolkit.parseNanos((String)configString);
        }
        return TimeRangeToolkit.parseMillis((String)configString);
    }

    @Override
    public String toHuman(Long serverValue) {
        if (serverValue == -1L) {
            return N_A;
        }
        if (this.useNanos) {
            return TimeRangeToolkit.convertNanosToNormalizedString((long)serverValue, (TimeRangeToolkit.Format)TimeRangeToolkit.Format.LOCALIZED);
        }
        return TimeRangeToolkit.convertMillisToNormalizedString((long)serverValue, (TimeRangeToolkit.Format)TimeRangeToolkit.Format.LOCALIZED);
    }

    @Override
    public String toConfigString(Long serverValue) {
        if (serverValue == -1L) {
            return N_A;
        }
        if (this.useNanos) {
            return TimeRangeToolkit.convertNanosToNormalizedString((long)serverValue, (TimeRangeToolkit.Format)TimeRangeToolkit.Format.SI);
        }
        return TimeRangeToolkit.convertMillisToNormalizedString((long)serverValue, (TimeRangeToolkit.Format)TimeRangeToolkit.Format.SI);
    }

    public static class PeriodicityConverter
    extends DurationConverter {
        private static final String EVERY_CHUNK = "everyChunk";

        public PeriodicityConverter() {
            super(false);
        }

        @Override
        public Long toServerValue(String configString) throws QuantityConversionException {
            if (EVERY_CHUNK.equals(configString)) {
                return 0L;
            }
            return super.toServerValue(configString);
        }

        @Override
        public String toHuman(Long serverValue) {
            if (serverValue == 0L) {
                return EVERY_CHUNK;
            }
            return super.toHuman(serverValue);
        }

        @Override
        public String toConfigString(Long serverValue) {
            if (serverValue == 0L) {
                return EVERY_CHUNK;
            }
            return super.toConfigString(serverValue);
        }
    }
}

