/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.internal.ConnectionHandleToolkit;
import com.jrockit.mc.rjmx.services.CouldNotCreateServiceException;
import com.jrockit.mc.rjmx.services.ICommercialFeaturesService;
import com.jrockit.mc.rjmx.services.flr.FlightRecorderException;
import com.jrockit.mc.rjmx.services.flr.IRecordingDescriptor;
import com.jrockit.mc.rjmx.services.flr.internal.FlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.internal.RecordingDescriptorToolkit;
import com.jrockit.mc.rjmx.services.internal.IMBeanManagerService;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;

public final class FlightRecorderCommunicationHelper {
    private volatile boolean isInitialized;
    private final IConnectionHandle handle;
    private static final String FLR_MBEAN = "com.oracle.jrockit:type=FlightRecorder";
    public static final ObjectName FLR_MBEAN_OBJECT_NAME;
    private static final MRI FLR_RECORDINGS_ATTRIBUTE;

    static {
        ObjectName flrBean = null;
        try {
            flrBean = new ObjectName(FLR_MBEAN);
        }
        catch (Exception e) {
            ConnectionHandleToolkit.LOGGER.log(Level.SEVERE, "Could not create FLR MBean object name!", e);
        }
        FLR_MBEAN_OBJECT_NAME = flrBean;
        FLR_RECORDINGS_ATTRIBUTE = new MRI(MRI.Type.ATTRIBUTE, FLR_MBEAN_OBJECT_NAME, "Recordings");
    }

    public FlightRecorderCommunicationHelper(IConnectionHandle handle) {
        this.handle = handle;
    }

    public List<IRecordingDescriptor> getAvailableRecordings() throws FlightRecorderException {
        this.checkCommercialFeatures();
        try {
            IMBeanHelperService helper = this.getService(IMBeanHelperService.class);
            List attribute = (List)helper.getAttribute(FLR_RECORDINGS_ATTRIBUTE).getValue();
            ArrayList<IRecordingDescriptor> recordings = new ArrayList<IRecordingDescriptor>();
            for (CompositeData data : attribute) {
                recordings.add(RecordingDescriptorToolkit.createRecordingDescriptor(this.handle.getServerDescriptor().getGUID(), data));
            }
            return Collections.unmodifiableList(recordings);
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not retrieve available recordings!", e);
        }
    }

    public Object getAttribute(MRI descriptor) throws FlightRecorderException {
        this.checkCommercialFeatures();
        try {
            IMBeanHelperService helper = this.getService(IMBeanHelperService.class);
            return helper.getAttribute(descriptor).getValue();
        }
        catch (IOException e) {
            throw new FlightRecorderException("Could not retrieve the attribute " + descriptor + '!', e);
        }
        catch (JMException e) {
            throw new FlightRecorderException("Could not retrieve the attribute " + descriptor + '!', e);
        }
    }

    public Object invokeOperation(String name, Object[] parameters) throws IOException, FlightRecorderException {
        this.checkCommercialFeatures();
        try {
            FlightRecorderService.LOGGER.fine("Invoking operation " + name);
            MBeanServerConnection service = this.getService(MBeanServerConnection.class);
            return service.invoke(FLR_MBEAN_OBJECT_NAME, name, parameters, ConnectionHandleToolkit.extractSignature(parameters));
        }
        catch (JMException e) {
            IOException throwMe = new IOException(e.getMessage());
            throwMe.initCause(e);
            throw throwMe;
        }
    }

    private <T> T getService(Class<T> serviceClass) throws FlightRecorderException {
        try {
            T service = this.handle.getServiceOrNull(serviceClass);
            if (service == null) {
                throw new FlightRecorderException("No service found for " + serviceClass.getName());
            }
            return service;
        }
        catch (CouldNotCreateServiceException e) {
            throw new FlightRecorderException(e.getLocalizedMessage(), e);
        }
    }

    private void checkCommercialFeatures() throws FlightRecorderException {
        if (this.isInitialized) {
            return;
        }
        try {
            if (!this.handle.getServiceOrDummy(ICommercialFeaturesService.class).hasCommercialFeatures()) {
                throw new FlightRecorderException("The JVM at " + this.handle.getServerDescriptor().getDisplayName() + " has no commercial features!");
            }
            if (!this.handle.getServiceOrDummy(ICommercialFeaturesService.class).isCommercialFeaturesEnabled()) {
                throw new FlightRecorderException("Commercial features must be enabled before attempting to use this!");
            }
            if (this.handle.getServiceOrNull(IMBeanManagerService.class) == null) {
                throw new FlightRecorderException("Could not access MBean Manager Service!");
            }
        }
        catch (CouldNotCreateServiceException serviceException) {
            throw new FlightRecorderException(serviceException.getLocalizedMessage(), serviceException);
        }
        this.isInitialized = true;
    }

    public void closeRecording(IRecordingDescriptor descriptor) throws FlightRecorderException {
        this.checkCommercialFeatures();
        try {
            this.invokeOperation("close", new Object[]{descriptor.getObjectName()});
        }
        catch (Exception e) {
            throw new FlightRecorderException("Could not close the recording!", e);
        }
    }

    public long getServerTimeStamp() {
        IMBeanHelperService service = this.handle.getServiceOrDummy(IMBeanHelperService.class);
        return service.getApproximateServerTime(System.currentTimeMillis());
    }

    public String toString() {
        return "FlightRecorderService@" + this.handle.getServerDescriptor().getDisplayName();
    }
}

