/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.JVMSupportToolkit;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.services.CouldNotCreateServiceException;
import com.jrockit.mc.rjmx.services.ICommercialFeaturesService;
import com.jrockit.mc.rjmx.services.IServiceFactory;
import com.jrockit.mc.rjmx.services.flr.IFlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.internal.FlightRecorderCommunicationHelper;
import com.jrockit.mc.rjmx.services.flr.internal.HotSpot24FlightRecorderService;
import com.jrockit.mc.rjmx.services.flr.internal.Messages;
import com.jrockit.mc.rjmx.services.internal.IMBeanManagerService;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;

public class FlightRecorderServiceFactory
implements IServiceFactory<IFlightRecorderService> {
    @Override
    public IFlightRecorderService getServiceInstance(Class<IFlightRecorderService> serviceClass, IConnectionHandle handle) throws CouldNotCreateServiceException {
        String errorMessage = JVMSupportToolkit.checkFlightRecorderSupport(handle, false);
        if (errorMessage != null) {
            throw new CouldNotCreateServiceException(errorMessage);
        }
        this.verifyFlightRecorderAvailability(handle);
        try {
            return new HotSpot24FlightRecorderService(handle);
        }
        catch (Exception e) {
            throw new CouldNotCreateServiceException(e);
        }
    }

    private void verifyFlightRecorderAvailability(IConnectionHandle handle) {
        IMBeanManagerService mbeanManagerService = handle.getServiceOrNull(IMBeanManagerService.class);
        if (mbeanManagerService == null) {
            throw new CouldNotCreateServiceException(Messages.FlightRecorderServiceFactory_COULD_NOT_REGISTER_MBEAN);
        }
        ICommercialFeaturesService service = handle.getServiceOrDummy(ICommercialFeaturesService.class);
        if (!service.hasCommercialFeatures()) {
            throw new CouldNotCreateServiceException(Messages.FlightRecorderServiceFactory_NO_COMMERCIAL_FEATURES);
        }
        if (!service.isCommercialFeaturesEnabled()) {
            throw new CouldNotCreateServiceException(Messages.FlightRecorderServiceFactory_COMMERCIAL_FEATURES_NOT_ENABLED);
        }
        if (!this.validateFlightRecorderMBean(handle)) {
            throw new CouldNotCreateServiceException(Messages.FlightRecorderServiceFactory_FLIGHT_RECORDER_NOT_ENABLED);
        }
    }

    private boolean validateFlightRecorderMBean(IConnectionHandle handle) {
        try {
            MBeanServerConnection connection = handle.getServiceOrNull(MBeanServerConnection.class);
            if (connection == null) {
                throw new CouldNotCreateServiceException(Messages.FlightRecorderServiceFactory_UNAVAILABLE_MBEAN_SERVER);
            }
            return connection.isRegistered(FlightRecorderCommunicationHelper.FLR_MBEAN_OBJECT_NAME);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.FINE, Messages.FlightRecorderServiceFactory_NO_FLIGHT_RECORDER_MBEAN, e);
            return false;
        }
    }

    @Override
    public Class<IFlightRecorderService> getServiceType() {
        return IFlightRecorderService.class;
    }
}

