/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.internal;

import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.rjmx.services.IAttributeInfo;
import com.jrockit.mc.rjmx.services.IOperation;
import com.jrockit.mc.rjmx.services.IllegalOperandException;
import com.jrockit.mc.rjmx.services.internal.AbstractOperation;
import com.jrockit.mc.rjmx.services.internal.Messages;
import com.jrockit.mc.rjmx.util.internal.SimpleAttributeInfo;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class MBeanOperationsWrapper
extends ArrayList<IOperation> {
    private static final int MAX_DESCRIPTORS = 8;
    private static final int MAX_DESCRIPTION_LENGTH = 100;
    private static final long serialVersionUID = -8499920218074514535L;
    private final ObjectName bean;
    private final transient MBeanServerConnection connection;

    public MBeanOperationsWrapper(ObjectName bean, MBeanOperationInfo[] operations, MBeanServerConnection connection) {
        super(operations.length);
        this.connection = connection;
        this.bean = bean;
        MBeanOperationInfo[] mBeanOperationInfoArray = operations;
        int n = operations.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanOperationInfo info = mBeanOperationInfoArray[n2];
            this.add(new MBeanOperation(info));
            ++n2;
        }
    }

    private static String convertDescription(MBeanOperationInfo info) {
        String[] fields;
        StringBuilder sb = new StringBuilder();
        if (info.getDescriptor() != null && info.getDescriptor().getFields() != null && (fields = info.getDescriptor().getFields()).length > 0) {
            sb.append(Messages.MBeanOperationsWrapper_DESCRIPTOR).append(":\n ");
            int i = 0;
            while (i < Math.min(fields.length, 8)) {
                sb.append(MBeanOperationsWrapper.shorten(fields[i])).append("\n ");
                ++i;
            }
        }
        return String.valueOf(MBeanOperationsWrapper.shorten(info.getDescription())) + "\n" + sb.toString().trim();
    }

    private static String shorten(String s) {
        if (s == null) {
            return "";
        }
        if (s.length() > 100) {
            return s.subSequence(0, 100) + "...";
        }
        return s;
    }

    private static List<IAttributeInfo> convertArguments(MBeanOperationInfo info) {
        MBeanParameterInfo[] sign = info.getSignature();
        ArrayList<IAttributeInfo> signature = new ArrayList<IAttributeInfo>(sign.length);
        MBeanParameterInfo[] mBeanParameterInfoArray = sign;
        int n = sign.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanParameterInfo paramInfo = mBeanParameterInfoArray[n2];
            String name = paramInfo.getDescription();
            name = name != null && name.trim().length() > 0 ? name : paramInfo.getName();
            signature.add(new SimpleAttributeInfo(name, paramInfo.getType()));
            ++n2;
        }
        return signature;
    }

    private static IOperation.OperationImpact convertImpact(MBeanOperationInfo info) {
        switch (info.getImpact()) {
            case 0: {
                return IOperation.OperationImpact.IMPACT_LOW;
            }
            case 3: {
                return IOperation.OperationImpact.IMPACT_UNKNOWN;
            }
        }
        return IOperation.OperationImpact.IMPACT_HIGH;
    }

    private static String describeValue(Object o) {
        if (o.getClass().isArray()) {
            return String.valueOf(o.getClass().getComponentType().getName()) + "[" + Array.getLength(o) + "]";
        }
        if (o instanceof String) {
            return "\"" + o + "\"";
        }
        return o.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("MBeanOperationsWrappers should not be serialized!");
    }

    private class MBeanOperation
    extends AbstractOperation<IAttributeInfo> {
        public MBeanOperation(MBeanOperationInfo info) {
            super(info.getName(), MBeanOperationsWrapper.convertDescription(info), info.getReturnType(), MBeanOperationsWrapper.convertArguments(info), MBeanOperationsWrapper.convertImpact(info));
        }

        @Override
        public Callable<?> getInvocator(final Object ... argVals) throws IllegalOperandException {
            List params = this.getSignature();
            final StringBuilder argString = new StringBuilder("(");
            if (argVals.length < params.size()) {
                throw new IllegalOperandException(params.subList(argVals.length, params.size()));
            }
            final String[] sig = new String[params.size()];
            int i = 0;
            while (i < params.size()) {
                sig[i] = ((IAttributeInfo)params.get(i)).getType();
                if (argVals[i] != null) {
                    argString.append(' ').append(MBeanOperationsWrapper.describeValue(argVals[i])).append(',');
                } else if (TypeHandling.isPrimitive((String)sig[i])) {
                    IllegalOperandException ex = new IllegalOperandException((IAttributeInfo)params.get(i));
                    while (++i < params.size()) {
                        if (argVals[i] != null || !TypeHandling.isPrimitive((String)((IAttributeInfo)params.get(i)).getType())) continue;
                        ex.addInvalidValue((IAttributeInfo)params.get(i));
                    }
                    throw ex;
                }
                ++i;
            }
            if (argString.charAt(argString.length() - 1) == ',') {
                argString.deleteCharAt(argString.length() - 1);
            }
            argString.append(" )");
            return new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return MBeanOperationsWrapper.this.connection.invoke(MBeanOperationsWrapper.this.bean, MBeanOperation.this.getName(), argVals, sig);
                }

                public String toString() {
                    return String.valueOf(MBeanOperation.this.getName()) + argString;
                }
            };
        }
    }
}

