/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription;

import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import java.util.HashSet;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.openmbean.CompositeData;

public final class MRIMetaDataToolkit {
    private MRIMetaDataToolkit() {
        throw new AssertionError((Object)"This is a toolkit! Do not instantiate!");
    }

    public static String getDisplayName(IConnectionHandle handle, MRI mri) {
        String displayName = (String)AttributeToolkit.getMetaData(handle, mri, "DisplayName");
        if (displayName != null && displayName.trim().length() > 0) {
            return displayName;
        }
        StringBuilder builder = new StringBuilder();
        String attributeDisplayName = mri.getDataPath();
        boolean lastCharLowerCase = false;
        int n = 0;
        while (n < attributeDisplayName.length()) {
            char c = attributeDisplayName.charAt(n);
            if (lastCharLowerCase && Character.isUpperCase(c)) {
                builder.append(' ');
                builder.append(Character.toUpperCase(c));
            } else {
                builder.append(c);
            }
            lastCharLowerCase = Character.isLowerCase(c);
            ++n;
        }
        return builder.toString();
    }

    public static IMRIMetaData[] getCompositeChildren(IConnectionHandle handle, IMRIMetaData metaData) {
        return metaData.getCompositeChildren();
    }

    public static String getDescription(IConnectionHandle handle, MRI mri) {
        String str = (String)AttributeToolkit.getMetaData(handle, mri, "Description");
        if (str != null) {
            return str;
        }
        return "";
    }

    public static IMRIMetaData getCompositeParent(IConnectionHandle handle, IMRIMetaData compositeChild) throws IllegalArgumentException {
        return MRIMetaDataToolkit.getAttributeInfo(handle, MRIMetaDataToolkit.getCompositeParent(compositeChild.getMRI()));
    }

    public static IMRIMetaData getAttributeInfo(IConnectionHandle handle, MRI descriptor) {
        IMRIMetaDataService infoService = handle.getServiceOrNull(IMRIMetaDataService.class);
        if (infoService != null) {
            return infoService.getMetaData(descriptor);
        }
        return null;
    }

    private static MRI getCompositeParent(MRI childDescriptor) {
        String path = childDescriptor.getDataPath();
        int n = path.indexOf(47);
        if (n >= 0) {
            MRI composite = new MRI(childDescriptor.getType(), childDescriptor.getObjectName(), path.substring(0, n));
            return composite;
        }
        throw new IllegalArgumentException("The mri path is not a sub-attribute to a composite parent.");
    }

    public static boolean isNumerical(IMRIMetaData info) {
        return MRIMetaDataToolkit.isNumerical(info.getValueType());
    }

    public static boolean isNumerical(String attributeType) {
        if (attributeType == null) {
            return false;
        }
        if (attributeType.equals(Integer.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Float.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Double.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Long.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Short.TYPE.getName())) {
            return true;
        }
        if (attributeType.equals(Byte.TYPE.getName())) {
            return true;
        }
        try {
            return Number.class.isAssignableFrom(Class.forName(attributeType));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static boolean isComposite(IMRIMetaDataProvider info) {
        return MRIMetaDataToolkit.getBooleanValue(info, "composite");
    }

    public static boolean isCompositeType(String className) {
        block4: {
            if (className == null || className.length() == 0) {
                return false;
            }
            try {
                if (!TypeHandling.isPrimitive((String)className)) break block4;
                return false;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return CompositeData.class.isAssignableFrom(Class.forName(className));
    }

    public static boolean isReadable(IMRIMetaDataProvider info) {
        return MRIMetaDataToolkit.getBooleanValue(info, "Readable");
    }

    public static boolean isWritable(IMRIMetaDataProvider info) {
        return MRIMetaDataToolkit.getBooleanValue(info, "Writable");
    }

    public static Descriptor getDescriptor(IMRIMetaDataProvider info) {
        return (Descriptor)info.getMetaData("Descriptor");
    }

    public static boolean getBooleanValue(IMRIMetaDataProvider info, String key) {
        Boolean b = (Boolean)info.getMetaData(key);
        if (b != null) {
            return b;
        }
        return false;
    }

    public static Set<MRI> filterAttributes(Set<MRI> mris) {
        return MRIMetaDataToolkit.filterMRIs(mris, MRI.Type.ATTRIBUTE);
    }

    public static Set<MRI> filterNotifications(Set<MRI> mris) {
        return MRIMetaDataToolkit.filterMRIs(mris, MRI.Type.NOTIFICATION);
    }

    private static Set<MRI> filterMRIs(Set<MRI> availableMRIs, MRI.Type type) {
        HashSet<MRI> filteredMRIs = new HashSet<MRI>();
        for (MRI mri : availableMRIs) {
            if (mri.getType() != type) continue;
            filteredMRIs.add(mri);
        }
        return filteredMRIs;
    }
}

