/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.FileMRIMetaData;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CompositeFileMRIMetaData
extends FileMRIMetaData {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    public static final String VALUE_COMPOSITE_CLASS_NAME = CompositeData.class.getName().intern();
    private IMRIMetaData[] m_compositeChildren;

    @Override
    public IMRIMetaData[] getCompositeChildren() {
        return this.m_compositeChildren;
    }

    @Override
    public void initializeFromXml(Element elem) {
        super.initializeFromXml(elem);
        String rootName = String.valueOf(this.getMRI().getDataPath()) + '/';
        try {
            ObjectName mbean = this.getMRI().getObjectName();
            List compositeList = XmlToolkit.getChildElementsByTag((Node)elem, (String)"metadata");
            this.m_compositeChildren = new FileMRIMetaData[compositeList.size()];
            int i = 0;
            int size = compositeList.size();
            while (i < size) {
                Element ce = (Element)compositeList.get(i);
                FileMRIMetaData info = new FileMRIMetaData();
                MRI ad = new MRI(this.getMRI().getType(), mbean, String.valueOf(rootName) + XmlToolkit.getSetting((Element)ce, (String)"mri.dataPath", (String)""));
                info.setAttributeDescriptor(ad);
                info.setUpdateTime(this.getUpdateTime());
                info.setAttributeType(XmlToolkit.getSetting((Element)ce, (String)"type", (String)""));
                info.setDisplayName(XmlToolkit.getSetting((Element)ce, (String)"displayname", (String)""));
                info.setDescription(XmlToolkit.getSetting((Element)ce, (String)"description", (String)""));
                info.setUnitString(XmlToolkit.getSetting((Element)ce, (String)"unitstring", (String)""));
                if (mbean != null) {
                    info.initializeArgument(ad, ce);
                }
                this.m_compositeChildren[i] = info;
                ++i;
            }
        }
        catch (Exception e1) {
            LOGGER.log(Level.WARNING, "Warning: Malformed descriptor in mrimetadata.xml, skipping meta data " + rootName, e1);
        }
    }

    @Override
    public void exportToXml(Element parentNode) {
        super.exportToXml(parentNode);
        if (this.m_compositeChildren == null) {
            return;
        }
        IMRIMetaData[] iMRIMetaDataArray = this.m_compositeChildren;
        int n = this.m_compositeChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IMRIMetaData element = iMRIMetaDataArray[n2];
            FileMRIMetaData attrInfo = (FileMRIMetaData)element;
            Element elem = XmlToolkit.createElement((Element)parentNode, (String)attrInfo.getComponentTag());
            String attributeName = this.getCompositeDataInfoChildName(attrInfo);
            if (attributeName != null) {
                XmlToolkit.setSetting((Element)elem, (String)"mri.dataPath", (String)attributeName);
                XmlToolkit.setSetting((Element)elem, (String)"type", (String)attrInfo.getValueType());
                XmlToolkit.setSetting((Element)elem, (String)"displayname", (String)attrInfo.getDisplayName());
                XmlToolkit.setSetting((Element)elem, (String)"unitstring", (String)attrInfo.getUnitString());
                XmlToolkit.setSetting((Element)elem, (String)"description", (String)attrInfo.getDescription());
            }
            ++n2;
        }
    }

    private String getCompositeDataInfoChildName(IMRIMetaData info) {
        String attributeName = info.getMRI().getDataPath();
        return attributeName.substring(attributeName.lastIndexOf(47) + 1);
    }
}

