/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.ISyntheticAttribute;
import com.jrockit.mc.rjmx.RJMXPlugin;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DeadlockedThreadCountAttribute
implements ISyntheticAttribute {
    private static final int METHOD_INVOCATION_ERROR = -1;
    private static final int METHOD_NOT_PRESENT = -2;
    private boolean hasLoggedReflectionError = false;

    @Override
    public Object getValue(MBeanServerConnection connection) {
        if (this.hasLoggedReflectionError) {
            return -2;
        }
        return this.getDeadlockedThreadCount(connection);
    }

    private int getDeadlockedThreadCount(MBeanServerConnection connection) {
        try {
            ObjectName threadMBean = new ObjectName("java.lang:type=Threading");
            Object result = connection.invoke(threadMBean, "findDeadlockedThreads", null, null);
            if (result != null && result instanceof long[]) {
                return ((long[])result).length;
            }
            return 0;
        }
        catch (ReflectionException e) {
            if (!this.hasLoggedReflectionError) {
                this.hasLoggedReflectionError = true;
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to find findDeadlockedThreads(). Are you running a JVM version < 1.6?", e);
            }
            return -2;
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to invoke findDeadlockedThreads(). Are you running a JVM version < 1.6?", e);
            return -1;
        }
    }

    @Override
    public void setValue(MBeanServerConnection connection, Object value) {
    }
}

