/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ServiceException;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMRISubscription;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValue;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.internal.AbstractAttributeSubscription;
import com.jrockit.mc.rjmx.subscription.internal.AttributeExceptionEvent;
import com.jrockit.mc.rjmx.subscription.internal.AttributeReregisteredEvent;
import com.jrockit.mc.rjmx.subscription.internal.ConnectionLostEvent;
import com.jrockit.mc.rjmx.subscription.internal.DefaultSubscriptionDebugInformation;
import com.jrockit.mc.rjmx.subscription.internal.IMRISubscriptionDebugInformation;
import com.jrockit.mc.rjmx.subscription.internal.InvoluntaryDisconnectException;
import com.jrockit.mc.rjmx.subscription.internal.UnavailableSubscriptionsRepository;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.ReflectionException;

public class DefaultAttributeSubscriptionThread
extends Thread {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private final IConnectionHandle connectionHandle;
    private final IMBeanHelperService helperService;
    private final Map<MRI, AbstractAttributeSubscription> attributeSubscriptions = new HashMap<MRI, AbstractAttributeSubscription>();
    private final Map<IMRISubscription, SubscriptionStats> subscriptionStats = new HashMap<IMRISubscription, SubscriptionStats>();
    private volatile boolean isRunning = false;
    private long lastTimestamp;
    private final long maxSleepTime = 2000L;
    private final long minSleepTime = 100L;
    private final Set<AbstractAttributeSubscription> recentlyAddedSubscriptions = new HashSet<AbstractAttributeSubscription>();
    private final Set<AbstractAttributeSubscription> recentlyRemovedSubscriptions = new HashSet<AbstractAttributeSubscription>();
    private final UnavailableSubscriptionsRepository unavailableSubscriptionsRepository;
    private boolean sendNulls;
    private volatile boolean collectDebugInfo = false;
    private Map<MRI, DefaultSubscriptionDebugInformation> subscriptionDebugInfo;

    public DefaultAttributeSubscriptionThread(IConnectionHandle connectionHandle) throws ServiceException {
        super("RJMX Subscription thread on " + connectionHandle.getServerDescriptor().getDisplayName());
        this.connectionHandle = connectionHandle;
        this.helperService = connectionHandle.getServiceOrThrow(IMBeanHelperService.class);
        this.unavailableSubscriptionsRepository = new UnavailableSubscriptionsRepository(connectionHandle);
        this.clearDebugInformation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            this.unregisterSubscriptionsQueuedForRemove();
            this.reregisterPreviouslyBadSubscriptions();
            this.registerSubscriptionsQueuedForAdd();
            long nowStart = System.currentTimeMillis();
            long nextTarget = this.checkNextTargetTime(nowStart);
            long sleepTime = Math.max(100L, Math.min(nextTarget - nowStart, 2000L));
            try {
                DefaultAttributeSubscriptionThread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                this.isRunning = true;
                break;
            }
            if (!this.isRunning) break;
            long nowEnd = System.currentTimeMillis();
            if (nowEnd < nextTarget) continue;
            this.retrieveAndDispatchValues(nowStart, nowEnd);
        }
        this.isRunning = false;
        Set<AbstractAttributeSubscription> set = this.recentlyRemovedSubscriptions;
        synchronized (set) {
            this.recentlyRemovedSubscriptions.addAll(this.attributeSubscriptions.values());
            this.recentlyRemovedSubscriptions.addAll(this.unavailableSubscriptionsRepository.getAllSubscriptions());
            this.unavailableSubscriptionsRepository.dispose();
        }
        this.unregisterSubscriptionsQueuedForRemove();
    }

    private void retrieveAndDispatchValues(long nowStart, long nextTarget) {
        ArrayList<MRI> normalAttributes = new ArrayList<MRI>();
        for (AbstractAttributeSubscription subscription : this.attributeSubscriptions.values()) {
            SubscriptionStats stats = this.getSubscriptionStat(subscription);
            if (stats.targetTime > nextTarget) continue;
            stats.lastUpdate = nextTarget;
            normalAttributes.add(subscription.getMRIMetaData().getMRI());
        }
        this.retrieveAndDispatchNormalAttributes(normalAttributes);
    }

    private SubscriptionStats getSubscriptionStat(IMRISubscription subscription) {
        return this.subscriptionStats.get(subscription);
    }

    private void retrieveAndDispatchNormalAttributes(List<MRI> normalAttributes) {
        try {
            List<MRIValue> attributeValues = this.helperService.getAttributes(normalAttributes);
            this.dispatchEvents(attributeValues);
            if (attributeValues.size() != normalAttributes.size()) {
                this.removeBadAttributes(normalAttributes, attributeValues);
            }
        }
        catch (MBeanException e) {
            this.searchAndRemoveBadAttributes(normalAttributes);
        }
        catch (InstanceNotFoundException e) {
            this.searchAndRemoveBadAttributes(normalAttributes);
        }
        catch (ReflectionException e) {
            this.searchAndRemoveBadAttributes(normalAttributes);
        }
        catch (InvoluntaryDisconnectException e) {
            LOGGER.warning("Subscription thread is terminating due to loss of connection!");
            this.dispatchConnectionLostEvents();
            this.shutdown();
        }
        catch (ConnectException e) {
            LOGGER.warning("Subscription thread is terminating due to loss of connection!");
            this.dispatchConnectionLostEvents();
            this.shutdown();
        }
        catch (IOException e) {
            this.searchAndRemoveBadAttributes(normalAttributes);
        }
        catch (RuntimeException e) {
            if (this.isRunning) {
                throw e;
            }
            LOGGER.fine("Failed to get attributes, probably since the subscription thread is terminating");
        }
    }

    private void dispatchConnectionLostEvents() {
        for (AbstractAttributeSubscription subscription : this.attributeSubscriptions.values()) {
            ConnectionLostEvent event = new ConnectionLostEvent(subscription, System.currentTimeMillis());
            subscription.storeAndFireEvent(event);
        }
    }

    private long checkNextTargetTime(long now) {
        long nextUpdate = Long.MAX_VALUE;
        for (AbstractAttributeSubscription subscription : this.attributeSubscriptions.values()) {
            SubscriptionStats stats = this.getSubscriptionStat(subscription);
            if (stats.lastUpdate < stats.targetTime && stats.targetTime > now) {
                long updatedTarget = subscription.getUpdatePolicy().getNextUpdate(now);
                if (updatedTarget < stats.targetTime) {
                    stats.targetTime = updatedTarget;
                }
            } else {
                stats.targetTime = subscription.getUpdatePolicy().getNextUpdate(now);
            }
            nextUpdate = Math.min(nextUpdate, stats.targetTime);
        }
        return nextUpdate;
    }

    public IConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAttributeSubscription(IMRISubscription subscription) {
        if (!(subscription instanceof AbstractAttributeSubscription)) {
            throw new IllegalArgumentException("This version of the subscription service can only handle AbstractAttributeSubscriptions.");
        }
        Set<AbstractAttributeSubscription> set = this.recentlyAddedSubscriptions;
        synchronized (set) {
            this.recentlyAddedSubscriptions.add((AbstractAttributeSubscription)subscription);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSubscriptionsQueuedForAdd() {
        if (Thread.currentThread() != this) {
            LOGGER.warning("registerQueuedSubscriptions abused in DefaultAttributeSubscriptionThread!");
        }
        ArrayList<AbstractAttributeSubscription> recentlyAdded = new ArrayList<AbstractAttributeSubscription>();
        Set<AbstractAttributeSubscription> set = this.recentlyAddedSubscriptions;
        synchronized (set) {
            recentlyAdded.addAll(this.recentlyAddedSubscriptions);
            this.recentlyAddedSubscriptions.clear();
        }
        for (AbstractAttributeSubscription subscription : recentlyAdded) {
            this.registerSubscription(subscription);
        }
    }

    private void registerSubscription(AbstractAttributeSubscription subscription) {
        if (this.subscriptionStats.get(subscription) == null) {
            this.sendNull(subscription);
            this.attributeSubscriptions.put(subscription.getMRIMetaData().getMRI(), subscription);
            this.recordConnected(subscription.getMRIMetaData().getMRI());
            this.subscriptionStats.put(subscription, new SubscriptionStats());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterSubscriptionsQueuedForRemove() {
        if (Thread.currentThread() != this) {
            LOGGER.warning("unregisterQueuedSubscriptions abused in DefaultAttributeSubscriptionThread!");
        }
        ArrayList<AbstractAttributeSubscription> recentlyRemoved = new ArrayList<AbstractAttributeSubscription>();
        Set<AbstractAttributeSubscription> set = this.recentlyRemovedSubscriptions;
        synchronized (set) {
            if (this.recentlyRemovedSubscriptions.isEmpty()) {
                return;
            }
            recentlyRemoved.addAll(this.recentlyRemovedSubscriptions);
            this.recentlyRemovedSubscriptions.clear();
        }
        for (AbstractAttributeSubscription subscription : recentlyRemoved) {
            this.unregisterSubscription(subscription);
            this.recordDisconnected(subscription.getMRIMetaData().getMRI());
            this.unavailableSubscriptionsRepository.remove(subscription);
        }
    }

    private void unregisterSubscription(AbstractAttributeSubscription subscription) {
        if (this.subscriptionStats.get(subscription) != null) {
            this.attributeSubscriptions.remove(subscription.getMRIMetaData().getMRI());
            this.subscriptionStats.remove(subscription);
            this.sendNull(subscription);
        }
    }

    private void sendNull(AbstractAttributeSubscription subscription) {
        if (this.isSendNulls()) {
            if (this.getLastTimestamp() == 0L) {
                this.setLastTimestamp(this.helperService.getApproximateServerTime(System.currentTimeMillis()));
            }
            subscription.storeAndFireEvent(new MRIValueEvent(subscription.getMRIMetaData().getMRI(), this.getConnectionHandle(), this.getLastTimestamp(), null));
        }
    }

    private void reregisterPreviouslyBadSubscriptions() {
        for (AbstractAttributeSubscription subscription : this.unavailableSubscriptionsRepository.getBackoffedSubscriptions()) {
            if (!this.hasSubscriptionBecomeAvailable(subscription)) continue;
            this.recordSucceededReconnection(subscription.getMRIMetaData().getMRI());
            this.registerSubscription(subscription);
            this.unavailableSubscriptionsRepository.remove(subscription);
            subscription.fireAttributeChange(new AttributeReregisteredEvent(subscription, this.getLastTimestamp()));
        }
    }

    private boolean hasSubscriptionBecomeAvailable(AbstractAttributeSubscription subscription) {
        return this.getBadAttributeError(subscription.getMRIMetaData().getMRI()) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAttributeSubscription(IMRISubscription subscription) {
        if (!(subscription instanceof AbstractAttributeSubscription)) {
            throw new IllegalArgumentException("This version of the subscription service can only handle AbstractAttributeSubscriptions.");
        }
        Set<AbstractAttributeSubscription> set = this.recentlyRemovedSubscriptions;
        synchronized (set) {
            this.recentlyRemovedSubscriptions.add((AbstractAttributeSubscription)subscription);
        }
    }

    public void shutdown() {
        this.isRunning = false;
        this.interrupt();
    }

    private void searchAndRemoveBadAttributes(List<MRI> attributesToFetch) {
        for (MRI mri : attributesToFetch) {
            if (!this.getConnectionHandle().isConnected()) {
                return;
            }
            Exception e = this.getBadAttributeError(mri);
            if (e != null) {
                this.recordConnectionLost(mri);
                this.removeBadAttribute(mri, e);
                continue;
            }
            this.recordEventPolled(mri);
        }
    }

    private void removeBadAttributes(List<MRI> attributesToFetch, List<MRIValue> returnedAttributeValues) {
        int missing = attributesToFetch.size() - returnedAttributeValues.size();
        for (MRI attributeToFetch : attributesToFetch) {
            boolean found = false;
            for (MRIValue returnedAttributeValue : returnedAttributeValues) {
                if (!attributeToFetch.equals(returnedAttributeValue.getMRI())) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.recordConnectionLost(attributeToFetch);
            this.removeBadAttribute(attributeToFetch, null);
            if (--missing > 0) continue;
            return;
        }
    }

    private void logError(Exception e, MRI mri) {
        LOGGER.info("The attribute " + mri + " could not be found in the specified JRockit, and has been removed from the subscription engine!");
    }

    private void removeBadAttribute(MRI mri, Exception e) {
        AbstractAttributeSubscription subscription = this.getSubscription(mri);
        this.unregisterSubscription(subscription);
        this.unavailableSubscriptionsRepository.add(subscription);
        subscription.fireAttributeChange(new AttributeExceptionEvent(subscription, this.getLastTimestamp(), e));
        this.logError(e, mri);
    }

    private AbstractAttributeSubscription getSubscription(MRI mri) {
        return this.attributeSubscriptions.get(mri);
    }

    private Exception getBadAttributeError(MRI mri) {
        try {
            this.recordTriedReconnection(mri);
            MRIValue attribute = this.helperService.getAttribute(mri);
            assert (attribute != null);
            return null;
        }
        catch (Exception e) {
            return e;
        }
    }

    private void dispatchEvents(List<MRIValue> timestampedDataList) {
        for (MRIValue tsd : timestampedDataList) {
            AbstractAttributeSubscription subscription = this.getSubscription(tsd.getMRI());
            MRIValueEvent event = new MRIValueEvent(subscription.getMRIMetaData().getMRI(), this.getConnectionHandle(), tsd.getTimestamp(), tsd.getValue());
            this.setLastTimestamp(Math.max(tsd.getTimestamp(), this.getLastTimestamp()));
            this.recordEventRecieved(event);
            subscription.storeAndFireEvent(event);
        }
    }

    public boolean isAttributeUnavailable(MRI descriptor) {
        return this.unavailableSubscriptionsRepository.contains(descriptor);
    }

    public synchronized long getLastTimestamp() {
        return this.lastTimestamp;
    }

    public synchronized void setLastTimestamp(long timestamp) {
        this.lastTimestamp = timestamp;
    }

    public void setSendNulls(boolean sendNulls) {
        this.sendNulls = sendNulls;
    }

    public boolean isSendNulls() {
        return this.sendNulls;
    }

    public void collectDebugInformation(boolean collect) {
        this.collectDebugInfo = collect;
    }

    public void clearDebugInformation() {
        this.subscriptionDebugInfo = new HashMap<MRI, DefaultSubscriptionDebugInformation>();
    }

    public Collection<? extends IMRISubscriptionDebugInformation> getDebugInformation() {
        return this.subscriptionDebugInfo.values();
    }

    private void recordConnected(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.SUBSCRIBED);
            ++info.m_connectionCount;
        }
    }

    private void recordDisconnected(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.UNSUBSCRIBED);
            ++info.m_disconnectionCount;
        }
    }

    private void recordEventRecieved(MRIValueEvent event) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(event.getSubscriptionAttribute(), IMRISubscriptionDebugInformation.SubscriptionState.SUBSCRIBED);
            ++info.m_eventCount;
            info.m_lastEvent = event;
        }
    }

    private void recordEventPolled(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.SUBSCRIBED);
            ++info.m_eventCount;
        }
    }

    private void recordConnectionLost(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.LOST);
            ++info.m_connectionLostCount;
        }
    }

    private void recordTriedReconnection(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.LOST);
            ++info.m_triedReconnectionCount;
        }
    }

    private void recordSucceededReconnection(MRI mri) {
        if (this.collectDebugInfo) {
            DefaultSubscriptionDebugInformation info = this.getDebugInformation(mri, IMRISubscriptionDebugInformation.SubscriptionState.SUBSCRIBED);
            ++info.m_succeededReconnectionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultSubscriptionDebugInformation getDebugInformation(MRI attribute, IMRISubscriptionDebugInformation.SubscriptionState state) {
        Map<MRI, DefaultSubscriptionDebugInformation> map = this.subscriptionDebugInfo;
        synchronized (map) {
            DefaultSubscriptionDebugInformation info = this.subscriptionDebugInfo.get(attribute);
            if (info == null) {
                info = new DefaultSubscriptionDebugInformation(attribute, state);
                this.subscriptionDebugInfo.put(attribute, info);
            } else {
                info.m_state = state;
            }
            return info;
        }
    }

    public static class SubscriptionStats {
        public long targetTime = Long.MIN_VALUE;
        public long lastUpdate = Long.MIN_VALUE;
    }
}

