/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.internal.IDisposableService;
import com.jrockit.mc.rjmx.services.ServiceException;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.internal.FileMRIMetaDataDB;
import com.jrockit.mc.rjmx.subscription.internal.MBeanMRIMetaDataDB;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.management.ObjectName;

public final class DefaultMRIMetaDataService
extends Observable
implements IMRIMetaDataService,
IDisposableService {
    private final IConnectionHandle handle;
    private final MBeanMRIMetaDataDB mbeanDB;
    private final Observer metaDataObserver;

    public DefaultMRIMetaDataService(IConnectionHandle handle) throws ServiceException {
        this.handle = handle;
        this.metaDataObserver = this.createMetaDataObserver();
        DefaultMRIMetaDataService.getFileDB().addObserver(this.metaDataObserver);
        this.mbeanDB = new MBeanMRIMetaDataDB(handle);
        this.mbeanDB.addObserver(this.metaDataObserver);
    }

    @Override
    public Set<MRI> getAvailableMRIsOnServer() {
        return new HashSet<MRI>(this.mbeanDB.getAvailableMRIs());
    }

    @Override
    public Set<MRI> getAvailableMRIs() {
        Set<MRI> availableMRIs = this.getAvailableMRIsOnServer();
        availableMRIs.addAll(DefaultMRIMetaDataService.getFileDB().getAvailableMRIs(this.getGUID()));
        return availableMRIs;
    }

    @Override
    public Set<MRI> getAvailableMRIsOnServer(ObjectName mbeanName) {
        return new HashSet<MRI>(this.mbeanDB.getAvailableMRIs(mbeanName));
    }

    @Override
    public Set<MRI> getAvailableMRIs(ObjectName mbeanName) {
        Set<MRI> availableMRIs = this.getAvailableMRIsOnServer(mbeanName);
        availableMRIs.addAll(DefaultMRIMetaDataService.getFileDB().getAvailableMRIs(this.getGUID(), mbeanName));
        return availableMRIs;
    }

    @Override
    public IMRIMetaData getMetaData(MRI mri) {
        return new MRIMetaDataWrapper(mri);
    }

    @Override
    public Object getMetaData(MRI mri, String dataKey) {
        if (DefaultMRIMetaDataService.getFileDB().hasMetaData(this.getGUID(), mri, dataKey)) {
            return DefaultMRIMetaDataService.getFileDB().getMetaData(this.getGUID(), mri, dataKey);
        }
        return this.mbeanDB.getMetaData(mri, dataKey);
    }

    @Override
    public void setMetaData(MRI mri, String dataKey, Object data) {
        DefaultMRIMetaDataService.getFileDB().setMetaData(this.getGUID(), mri, dataKey, data);
    }

    @Override
    public Set<String> getMetaDataKeys(MRI mri) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(DefaultMRIMetaDataService.getFileDB().getMetaDataKeys(this.getGUID(), mri));
        keys.addAll(this.mbeanDB.getMetaDataKeys(mri));
        return keys;
    }

    @Override
    public void dispose() {
        this.mbeanDB.deleteObserver(this.metaDataObserver);
        this.mbeanDB.dispose();
        DefaultMRIMetaDataService.getFileDB().deleteObserver(this.metaDataObserver);
        DefaultMRIMetaDataService.getFileDB().dispose(this.getGUID());
    }

    private String getGUID() {
        return this.handle.getServerDescriptor().getGUID();
    }

    private static FileMRIMetaDataDB getFileDB() {
        return RJMXPlugin.getDefault().getService(FileMRIMetaDataDB.class);
    }

    private Observer createMetaDataObserver() {
        return new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                DefaultMRIMetaDataService.this.setChanged();
                DefaultMRIMetaDataService.this.notifyObservers(arg);
            }
        };
    }

    private IMRIMetaData[] getCompositeChildren(MRI mri) {
        ArrayList<MRIMetaDataWrapper> children = new ArrayList<MRIMetaDataWrapper>();
        for (MRI availableMRI : this.getAvailableMRIsOnServer(mri.getObjectName())) {
            if (!this.isChild(availableMRI, mri)) continue;
            children.add(new MRIMetaDataWrapper(availableMRI));
        }
        return children.toArray(new IMRIMetaData[children.size()]);
    }

    private boolean isChild(MRI availableMRI, MRI mri) {
        if (availableMRI.getType() != mri.getType()) {
            return false;
        }
        String mriDataPath = mri.getDataPath();
        String availableMRIDataPath = availableMRI.getDataPath();
        if (availableMRIDataPath.startsWith(mriDataPath)) {
            String childDataPath = availableMRIDataPath.substring(mriDataPath.length());
            return childDataPath.indexOf("/") == 0 && childDataPath.lastIndexOf("/") == 0;
        }
        return false;
    }

    private class MRIMetaDataWrapper
    implements IMRIMetaData {
        private final MRI mri;

        private MRIMetaDataWrapper(MRI mri) {
            this.mri = mri;
        }

        @Override
        public MRI getMRI() {
            return this.mri;
        }

        @Override
        public Object getMetaData(String key) {
            return DefaultMRIMetaDataService.this.getMetaData(this.getMRI(), key);
        }

        @Override
        public void setMetaData(String key, Object value) {
            DefaultMRIMetaDataService.this.setMetaData(this.getMRI(), key, value);
        }

        @Override
        public String getDescription() {
            return (String)this.getMetaData("Description");
        }

        @Override
        public String getValueType() {
            return (String)this.getMetaData("AttributeType");
        }

        @Override
        public String getDisplayName() {
            return (String)this.getMetaData("DisplayName");
        }

        @Override
        public int getUpdateTime() {
            Integer updateTime = (Integer)this.getMetaData("UpdateTime");
            if (updateTime != null) {
                return updateTime;
            }
            return -1;
        }

        @Override
        public String getUnitString() {
            return (String)this.getMetaData("UnitString");
        }

        @Override
        public boolean isFailSilently() {
            return MRIMetaDataToolkit.getBooleanValue(this, "FailSilently");
        }

        @Override
        public IMRIMetaData[] getCompositeChildren() {
            return DefaultMRIMetaDataService.this.getCompositeChildren(this.getMRI());
        }

        public boolean equals(Object that) {
            if (that instanceof MRIMetaDataWrapper) {
                return this.getMRI().equals(((MRIMetaDataWrapper)that).getMRI());
            }
            return false;
        }

        public int hashCode() {
            return this.getMRI().hashCode();
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + '[' + this.getMRI() + ",update time=" + this.getUpdateTime() + ']';
        }
    }
}

