/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.CompositeFileMRIMetaData;
import com.jrockit.mc.rjmx.subscription.internal.FileMRIMetaData;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class FileMRIMetaDataDB
extends Observable
implements XmlEnabled {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private static final String ELEMENT_CHANGED_META_DATA = "changedMetaData";
    private static final String XML_COMPONENT_TAG = "metadatacollection";
    public static final String KEY_UPDATE_TIME = "UpdateTime";
    public static final String KEY_UNIT_STRING = "UnitString";
    public static final String KEY_DISPLAY_NAME = "DisplayName";
    public static final String KEY_FAIL_SILENTLY = "FailSilently";
    public static final String KEY_DESCRIPTION = "Description";
    public static final String KEY_VALUE_TYPE = "AttributeType";
    public static final String KEY_COMPOSITE = "composite";
    public static final String KEY_READABLE = "Readable";
    public static final String KEY_WRITABLE = "Writable";
    public static final String KEY_DESCRIPTOR = "Descriptor";
    private final Map<MRI, Map<String, Object>> defaultMetaDataMap = new HashMap<MRI, Map<String, Object>>();
    private Map<String, Map<MRI, Map<String, Object>>> changedMetaDataStore = new HashMap<String, Map<MRI, Map<String, Object>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMetaData(String GUID, MRI mri, String key, Object value) {
        Map<String, Map<MRI, Map<String, Object>>> map = this.changedMetaDataStore;
        synchronized (map) {
            Map<String, Object> metaDataKeyValueMap;
            Map<MRI, Map<String, Object>> metaDataMap = this.getChangedMetaData(GUID);
            if (metaDataMap == null) {
                metaDataMap = new HashMap<MRI, Map<String, Object>>();
                this.changedMetaDataStore.put(GUID, metaDataMap);
            }
            if ((metaDataKeyValueMap = metaDataMap.get(mri)) == null) {
                metaDataKeyValueMap = new HashMap<String, Object>();
                metaDataMap.put(mri, metaDataKeyValueMap);
            }
            metaDataKeyValueMap.put(key, value);
            this.setChanged();
            this.notifyObservers(mri);
        }
    }

    public Object getMetaData(String GUID, MRI mri, String dataKey) {
        Map<String, Object> mriMetaDataMap;
        Map<MRI, Map<String, Object>> metaDataMap = this.getChangedMetaData(GUID);
        if (metaDataMap != null && (mriMetaDataMap = metaDataMap.get(mri)) != null && mriMetaDataMap.containsKey(dataKey)) {
            return mriMetaDataMap.get(dataKey);
        }
        return this.getNonNullMap(this.defaultMetaDataMap, mri).get(dataKey);
    }

    private void addAttributeMetaData(IMRIMetaData metaDataInfo) {
        IMRIMetaData[] children = metaDataInfo.getCompositeChildren();
        if (children != null) {
            IMRIMetaData[] iMRIMetaDataArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMRIMetaData element = iMRIMetaDataArray[n2];
                this.addAttributeMetaData(element);
                ++n2;
            }
        }
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), KEY_UPDATE_TIME, metaDataInfo.getUpdateTime());
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), KEY_UNIT_STRING, metaDataInfo.getUnitString());
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), KEY_DISPLAY_NAME, metaDataInfo.getDisplayName());
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), KEY_FAIL_SILENTLY, metaDataInfo.isFailSilently());
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), KEY_COMPOSITE, metaDataInfo instanceof CompositeFileMRIMetaData);
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), KEY_VALUE_TYPE, metaDataInfo.getValueType());
        this.setDefaultMetaDataValue(metaDataInfo.getMRI(), KEY_DESCRIPTION, metaDataInfo.getDescription());
    }

    private void setDefaultMetaDataValue(MRI mri, String key, Object value) {
        Map<String, Object> metaData = this.defaultMetaDataMap.get(mri);
        if (metaData == null) {
            metaData = new HashMap<String, Object>();
            this.defaultMetaDataMap.put(mri, metaData);
        }
        metaData.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportToXml(Element parentNode) {
        Map<String, Map<MRI, Map<String, Object>>> map = this.changedMetaDataStore;
        synchronized (map) {
            XmlToolkit.setNameTypeValue((Element)parentNode, (String)ELEMENT_CHANGED_META_DATA, this.changedMetaDataStore);
        }
    }

    private void initAttributeFromXMLElement(Element e) {
        FileMRIMetaData info = null;
        info = this.hasCompositeTag(e) ? new CompositeFileMRIMetaData() : new FileMRIMetaData();
        info.initializeFromXml(e);
        this.addDefaultMetaDataValues(info);
        this.addAttributeMetaData(info);
    }

    private boolean hasCompositeTag(Element e) {
        return XmlToolkit.getChildElementOrNull((Element)e, (String)KEY_COMPOSITE) != null;
    }

    private void addDefaultMetaDataValues(FileMRIMetaData info) {
        for (Object key : info.getDefaultValues().keySet()) {
            this.setDefaultMetaDataValue(info.getMRI(), (String)key, info.getDefaultValues().get(key));
        }
        if (info instanceof CompositeFileMRIMetaData) {
            IMRIMetaData[] children;
            CompositeFileMRIMetaData compositeInfo = (CompositeFileMRIMetaData)info;
            IMRIMetaData[] iMRIMetaDataArray = children = compositeInfo.getCompositeChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IMRIMetaData element = iMRIMetaDataArray[n2];
                if (element instanceof FileMRIMetaData) {
                    this.addDefaultMetaDataValues((FileMRIMetaData)element);
                }
                ++n2;
            }
        }
    }

    private void initFromXml(Element node) {
        List nodeList = XmlToolkit.getChildElementsByTag((Node)node, (String)"metadata");
        for (Element e : nodeList) {
            this.initAttributeFromXMLElement(e);
        }
    }

    void initializeFromDefault() {
        block6: {
            InputStream is = null;
            try {
                try {
                    is = this.getClass().getResourceAsStream("mrimetadata.xml");
                    Document doc = XmlToolkit.loadDocumentFromStream((InputStream)is);
                    List elems = XmlToolkit.getChildElementsByTag((Node)doc.getDocumentElement(), (String)XML_COMPONENT_TAG);
                    if (elems.size() != 1 || elems.get(0) == null) {
                        throw new Exception("Could not find the attributes element!");
                    }
                    this.initFromXml((Element)elems.get(0));
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Tried reading mrimetadata.xml, but an exception occured: " + e.getMessage() + "Extended information about attributes may not be available, " + "and the console will not operate optimally.", e);
                    IOToolkit.closeSilently((Closeable)is);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOToolkit.closeSilently(is);
                throw throwable;
            }
            IOToolkit.closeSilently((Closeable)is);
        }
    }

    public String getComponentTag() {
        return XML_COMPONENT_TAG;
    }

    public synchronized void initializeFromXml(Element node) {
        this.initializeFromDefault();
        if (node == null) {
            return;
        }
        try {
            Map changedDataMap = (Map)XmlToolkit.getNameTypeValue((Element)node, (String)ELEMENT_CHANGED_META_DATA);
            if (changedDataMap != null) {
                this.changedMetaDataStore = changedDataMap;
            }
        }
        catch (DOMException e) {
            LOGGER.log(Level.FINEST, "Found no changed attribute meta data node.", e);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public Set<String> getMetaDataKeys(String GUID, MRI mri) {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.getNonNullMap(this.defaultMetaDataMap, mri).keySet());
        Map<MRI, Map<String, Object>> guidMetaData = this.getNonNullChangedMetaData(GUID);
        keys.addAll(this.getNonNullMap(guidMetaData, mri).keySet());
        return keys;
    }

    public void dispose(String GUID) {
    }

    public boolean hasMetaData(String GUID, MRI mri, String dataKey) {
        if (this.getNonNullMap(this.defaultMetaDataMap, mri).containsKey(dataKey)) {
            return true;
        }
        return this.getNonNullMap(this.getNonNullChangedMetaData(GUID), mri).containsKey(dataKey);
    }

    public Set<MRI> getAvailableMRIs(String guid) {
        HashSet<MRI> availableMRIs = new HashSet<MRI>(this.getNonNullChangedMetaData(guid).keySet());
        availableMRIs.addAll(this.defaultMetaDataMap.keySet());
        return availableMRIs;
    }

    public Set<MRI> getAvailableMRIs(String guid, ObjectName mBean) {
        Set<MRI> availableMRIs = this.filterOnMBean(this.getNonNullChangedMetaData(guid).keySet(), mBean);
        availableMRIs.addAll(this.filterOnMBean(this.defaultMetaDataMap.keySet(), mBean));
        return availableMRIs;
    }

    private Set<MRI> filterOnMBean(Set<MRI> availableMRIs, ObjectName mBean) {
        HashSet<MRI> filteredMRIs = new HashSet<MRI>();
        for (MRI mri : availableMRIs) {
            if (!mri.getObjectName().equals(mBean)) continue;
            filteredMRIs.add(mri);
        }
        return filteredMRIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MRI, Map<String, Object>> getChangedMetaData(String GUID) {
        Map<String, Map<MRI, Map<String, Object>>> map = this.changedMetaDataStore;
        synchronized (map) {
            return this.changedMetaDataStore.get(GUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MRI, Map<String, Object>> getNonNullChangedMetaData(String GUID) {
        Map<String, Map<MRI, Map<String, Object>>> map = this.changedMetaDataStore;
        synchronized (map) {
            return this.getNonNullMap(this.changedMetaDataStore, GUID);
        }
    }

    private <K, V, C> Map<V, C> getNonNullMap(Map<K, Map<V, C>> map, K key) {
        Map<V, C> keyMap = map.get(key);
        if (keyMap == null) {
            return Collections.emptyMap();
        }
        return keyMap;
    }
}

