/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.SyntheticNotification;
import com.jrockit.mc.rjmx.subscription.MRI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;

public class HotSpotGcNotification
extends SyntheticNotification {
    private static final String COM_SUN_MANAGEMENT_GC_NOTIFICATION = "com.sun.management.gc.notification";
    private MBeanServerConnection m_connection;
    private MRI[] m_notificationDescriptors = null;
    private CompositeData m_lastValue;
    private String m_lastMessage;
    private long m_collectionNumber = 0L;
    private final NotificationListener m_listener = this.createListener();

    @Override
    public void init(MBeanServerConnection connection, String type, String message) {
        super.init(connection, type, message);
        this.m_connection = connection;
        this.m_notificationDescriptors = this.lookupNotificationDescriptors();
        this.subscribeToNotifications();
    }

    private MRI[] lookupNotificationDescriptors() {
        Set<ObjectName> garbageCollectorMxBeans = this.lookupGcMxBeans();
        return this.createNotificationDescriptors(garbageCollectorMxBeans);
    }

    private Set<ObjectName> lookupGcMxBeans() {
        HashSet<ObjectName> garbageCollectorMxBeans = new HashSet<ObjectName>();
        try {
            for (ObjectName objectName : this.m_connection.queryNames(null, null)) {
                if (!objectName.getDomain().equals("java.lang") || !"GarbageCollector".equals(objectName.getKeyProperty("type"))) continue;
                garbageCollectorMxBeans.add(objectName);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return garbageCollectorMxBeans;
    }

    private MRI[] createNotificationDescriptors(Set<ObjectName> garbageCollectorMxBeans) {
        ArrayList<MRI> notificationDescriptors = new ArrayList<MRI>();
        block2: for (ObjectName mxBean : garbageCollectorMxBeans) {
            try {
                MBeanNotificationInfo[] mBeanNotificationInfoArray = this.m_connection.getMBeanInfo(mxBean).getNotifications();
                int n = mBeanNotificationInfoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MBeanNotificationInfo notification = mBeanNotificationInfoArray[n2];
                    String[] stringArray = notification.getNotifTypes();
                    int n3 = stringArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String type = stringArray[n4];
                        if (type.equals(COM_SUN_MANAGEMENT_GC_NOTIFICATION)) {
                            notificationDescriptors.add(new MRI(MRI.Type.NOTIFICATION, mxBean, COM_SUN_MANAGEMENT_GC_NOTIFICATION));
                            continue block2;
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return notificationDescriptors.toArray(new MRI[notificationDescriptors.size()]);
    }

    private void subscribeToNotifications() {
        MRI[] mRIArray = this.m_notificationDescriptors;
        int n = this.m_notificationDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            MRI notification = mRIArray[n2];
            try {
                this.m_connection.addNotificationListener(notification.getObjectName(), this.m_listener, this.creteNotificationFilter(notification), null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    private NotificationFilter creteNotificationFilter(MRI notification) {
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(notification.getDataPath());
        return filter;
    }

    private NotificationListener createListener() {
        return new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object handback) {
                HotSpotGcNotification hotSpotGcNotification = HotSpotGcNotification.this;
                synchronized (hotSpotGcNotification) {
                    HotSpotGcNotification.this.m_lastValue = (CompositeData)notification.getUserData();
                    HotSpotGcNotification.this.m_lastMessage = notification.getMessage();
                    HotSpotGcNotification hotSpotGcNotification2 = HotSpotGcNotification.this;
                    hotSpotGcNotification2.m_collectionNumber = hotSpotGcNotification2.m_collectionNumber + 1L;
                }
                HotSpotGcNotification.this.triggerNotification();
            }
        };
    }

    @Override
    protected String getMessage() {
        return this.m_lastMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValue() {
        long collectionNumber;
        CompositeData lastValue;
        HotSpotGcNotification hotSpotGcNotification = this;
        synchronized (hotSpotGcNotification) {
            lastValue = this.m_lastValue;
            collectionNumber = this.m_collectionNumber;
        }
        if (lastValue == null) {
            return null;
        }
        return this.updateCollectionNumber(lastValue, collectionNumber);
    }

    private CompositeData updateCollectionNumber(CompositeData gcValue, long collectionNumber) {
        Map<String, Object> keyValuesMap = this.extractKeyValues(gcValue);
        CompositeData updatedGcInfo = this.updateGcCount((CompositeData)this.getValue(keyValuesMap, "gcInfo"), collectionNumber);
        this.setValue(keyValuesMap, "gcInfo", updatedGcInfo);
        return this.createComposite(gcValue, keyValuesMap);
    }

    private CompositeData updateGcCount(CompositeData gcInfo, long collectionNumber) {
        Map<String, Object> keyValuesMap = this.extractKeyValues(gcInfo);
        this.setValue(keyValuesMap, "id", collectionNumber);
        return this.createComposite(gcInfo, keyValuesMap);
    }

    private Map<String, Object> extractKeyValues(CompositeData composite) {
        HashMap<String, Object> keyValues = new HashMap<String, Object>();
        for (String key : composite.getCompositeType().keySet()) {
            keyValues.put(key.toString(), composite.get(key.toString()));
        }
        return keyValues;
    }

    private Object getValue(Map<String, Object> keyValues, String key) {
        return keyValues.get(key);
    }

    private void setValue(Map<String, Object> keyValues, String key, Object value) {
        keyValues.put(key, value);
    }

    private CompositeData createComposite(CompositeData composite, Map<String, Object> keyValues) {
        try {
            return new CompositeDataSupport(composite.getCompositeType(), keyValues);
        }
        catch (OpenDataException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void stop() {
        MRI[] mRIArray = this.m_notificationDescriptors;
        int n = this.m_notificationDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            MRI notification = mRIArray[n2];
            try {
                this.m_connection.removeNotificationListener(notification.getObjectName(), this.m_listener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }
}

