/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.SyntheticNotification;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.internal.AttributeValueToolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;

public class HotSpotLiveSetNotification
extends SyntheticNotification {
    private MBeanServerConnection m_connection;
    private MRI m_gcNotification;
    private volatile double m_liveSet;
    private String m_message;
    private final NotificationListener m_listener = this.createListener();

    @Override
    public void init(MBeanServerConnection connection, String type, String message) {
        super.init(connection, type, message);
        this.m_connection = connection;
        this.m_gcNotification = this.lookupGcNotification();
        this.subscribeToGcNotification();
    }

    private MRI lookupGcNotification() {
        return new MRI(MRI.Type.NOTIFICATION, "com.sun.management:type=GarbageCollectionAggregator", "com.sun.management.gc.notification");
    }

    private void subscribeToGcNotification() {
        try {
            this.m_connection.addNotificationListener(this.m_gcNotification.getObjectName(), this.m_listener, this.createNotificationFilter(), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private NotificationFilter createNotificationFilter() {
        NotificationFilterSupport filter = new NotificationFilterSupport();
        filter.enableType(this.m_gcNotification.getDataPath());
        return filter;
    }

    @Override
    public Object getValue() {
        return this.m_liveSet;
    }

    private NotificationListener createListener() {
        return new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                CompositeData userData = (CompositeData)notification.getUserData();
                if (HotSpotLiveSetNotification.this.isOldCollection(userData)) {
                    long usedHeap = HotSpotLiveSetNotification.this.lookupUsedHeap(userData);
                    long committedHeap = HotSpotLiveSetNotification.this.getCommittedHeap();
                    if (committedHeap > 0L) {
                        HotSpotLiveSetNotification.this.m_liveSet = (double)usedHeap / (double)committedHeap;
                        HotSpotLiveSetNotification.this.m_message = notification.getMessage();
                        HotSpotLiveSetNotification.this.triggerNotification();
                    }
                }
            }
        };
    }

    @Override
    protected String getMessage() {
        return this.m_message;
    }

    private long getCommittedHeap() {
        try {
            return ((Number)AttributeValueToolkit.getAttribute(this.m_connection, new MRI(MRI.Type.ATTRIBUTE, "java.lang:type=Memory", "HeapMemoryUsage/committed"))).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private boolean isOldCollection(CompositeData data) {
        return ((String)data.get("gcAction")).indexOf("major") >= 0;
    }

    private long lookupUsedHeap(CompositeData data) {
        long usedHeap = 0L;
        CompositeData gcInfo = (CompositeData)data.get("gcInfo");
        TabularData memoryUsageAfterGc = (TabularData)gcInfo.get("memoryUsageAfterGc");
        for (Object memoryPool : memoryUsageAfterGc.values()) {
            usedHeap += this.getMemoryPoolUsed((CompositeData)memoryPool);
        }
        return usedHeap;
    }

    private long getMemoryPoolUsed(CompositeData memoryPool) {
        if (this.includeMemoryPool(memoryPool.get("key").toString())) {
            Long memoryPoolUsed = (Long)((CompositeData)memoryPool.get("value")).get("used");
            return memoryPoolUsed;
        }
        return 0L;
    }

    private boolean includeMemoryPool(String memoryPoolName) {
        if (memoryPoolName.equals("Code Cache")) {
            return false;
        }
        return !memoryPoolName.contains("Perm Gen");
    }

    @Override
    public void stop() {
        try {
            this.m_connection.removeNotificationListener(this.m_gcNotification.getObjectName(), this.m_listener);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        throw new IOException("You should not serialize instances of " + this.getClass().getName());
    }
}

