/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.services.ServiceException;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMBeanServerChangeListener;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValue;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.logging.Level;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;

public final class MBeanMRIMetaDataDB
extends Observable {
    private final IMBeanHelperService mbeanService;
    private final IMBeanServerChangeListener mbeanServerChangeListener;
    private final Map<ObjectName, Map<MRI, Map<String, Object>>> cachedMRIMetaData = new HashMap<ObjectName, Map<MRI, Map<String, Object>>>();
    private final Set<ObjectName> introspectedMBeans = new HashSet<ObjectName>();

    public MBeanMRIMetaDataDB(IConnectionHandle handle) throws ServiceException {
        this.mbeanService = handle.getServiceOrThrow(IMBeanHelperService.class);
        this.mbeanServerChangeListener = this.createMBeanServerChangeListener();
        this.mbeanService.addMBeanServerChangeListener(this.mbeanServerChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.mbeanService.removeMBeanServerChangeListener(this.mbeanServerChangeListener);
        Map<ObjectName, Map<MRI, Map<String, Object>>> map = this.cachedMRIMetaData;
        synchronized (map) {
            this.cachedMRIMetaData.clear();
            this.introspectedMBeans.clear();
        }
    }

    public Set<String> getMetaDataKeys(MRI mri) {
        Map<String, Object> metaData = this.getNonNullMRIMetaData(mri);
        return new HashSet<String>(metaData.keySet());
    }

    public Object getMetaData(MRI mri, String dataKey) {
        Map<String, Object> metaData = this.getNonNullMRIMetaData(mri);
        return metaData.get(dataKey);
    }

    public Set<MRI> getAvailableMRIs() {
        try {
            HashSet<MRI> mris = new HashSet<MRI>();
            for (ObjectName mbean : this.mbeanService.getMBeanNames()) {
                mris.addAll(this.getAvailableMRIs(mbean));
            }
            return mris;
        }
        catch (IOException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to retrieve MBean names from server!", e);
            return Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<MRI> getAvailableMRIs(ObjectName mBean) {
        if (this.hasIntrospectedMBean(mBean)) {
            Map<ObjectName, Map<MRI, Map<String, Object>>> map = this.cachedMRIMetaData;
            synchronized (map) {
                return new HashSet<MRI>(this.getNonNullMap(this.cachedMRIMetaData, mBean).keySet());
            }
        }
        return this.introspectMBean(mBean).keySet();
    }

    private IMBeanServerChangeListener createMBeanServerChangeListener() {
        return new IMBeanServerChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mbeanUnregistered(ObjectName mbean) {
                Map map = MBeanMRIMetaDataDB.this.cachedMRIMetaData;
                synchronized (map) {
                    MBeanMRIMetaDataDB.this.introspectedMBeans.remove(mbean);
                    MBeanMRIMetaDataDB.this.cachedMRIMetaData.remove(mbean);
                }
                MBeanMRIMetaDataDB.this.setChanged();
                MBeanMRIMetaDataDB.this.notifyObservers(mbean);
            }

            @Override
            public void mbeanRegistered(ObjectName mbean) {
                MBeanMRIMetaDataDB.this.setChanged();
                MBeanMRIMetaDataDB.this.notifyObservers(mbean);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> getNonNullMRIMetaData(MRI mri) {
        ObjectName mbean = mri.getObjectName();
        if (this.hasIntrospectedMBean(mbean)) {
            Map<ObjectName, Map<MRI, Map<String, Object>>> map = this.cachedMRIMetaData;
            synchronized (map) {
                return this.getNonNullMap(this.getNonNullMap(this.cachedMRIMetaData, mbean), mri);
            }
        }
        return this.getNonNullMap(this.introspectMBean(mbean), mri);
    }

    private boolean hasIntrospectedMBean(ObjectName mbean) {
        return this.introspectedMBeans.contains(mbean);
    }

    private <K, V, C> Map<V, C> getNonNullMap(Map<K, Map<V, C>> map, K key) {
        Map<V, C> keyMap = map.get(key);
        if (keyMap == null) {
            return Collections.emptyMap();
        }
        return keyMap;
    }

    private Map<MRI, Map<String, Object>> lookupMBeanMRIData(ObjectName mbean) {
        MBeanInfo info = this.lookupMBeanInfo(mbean);
        if (info != null) {
            HashMap<MRI, Map<String, Object>> mbeanMetaData = new HashMap<MRI, Map<String, Object>>();
            MBeanFeatureInfo[] mBeanFeatureInfoArray = info.getAttributes();
            int n = mBeanFeatureInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                MBeanAttributeInfo attribute = mBeanFeatureInfoArray[n2];
                mbeanMetaData.put(new MRI(MRI.Type.ATTRIBUTE, mbean, attribute.getName()), this.createMetaData(attribute));
                ++n2;
            }
            mBeanFeatureInfoArray = info.getNotifications();
            n = mBeanFeatureInfoArray.length;
            n2 = 0;
            while (n2 < n) {
                MBeanFeatureInfo notification = mBeanFeatureInfoArray[n2];
                String[] stringArray = ((MBeanNotificationInfo)notification).getNotifTypes();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String type = stringArray[n4];
                    mbeanMetaData.put(new MRI(MRI.Type.NOTIFICATION, mbean, type), this.createMetaData((MBeanNotificationInfo)notification, type));
                    ++n4;
                }
                ++n2;
            }
            return mbeanMetaData;
        }
        return null;
    }

    private MBeanInfo lookupMBeanInfo(ObjectName mbean) {
        try {
            return this.mbeanService.getMBeanInfo(mbean);
        }
        catch (IOException e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to retrieve MBean information from server!", e);
            return null;
        }
    }

    private Map<String, Object> createMetaData(MBeanAttributeInfo attribute) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("DisplayName", attribute.getName());
        metaData.put("Description", attribute.getDescription());
        metaData.put("AttributeType", attribute.getType());
        metaData.put("composite", this.isCompositeType(attribute.getType()));
        metaData.put("Readable", attribute.isReadable());
        metaData.put("Writable", attribute.isWritable());
        metaData.put("Descriptor", attribute.getDescriptor());
        return metaData;
    }

    private Map<String, Object> createMetaData(MBeanNotificationInfo notification, String type) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("DisplayName", type);
        metaData.put("Description", notification.getDescription());
        metaData.put("AttributeType", notification.getName());
        metaData.put("Descriptor", notification.getDescriptor());
        return metaData;
    }

    private boolean isCompositeType(String className) {
        try {
            return CompositeData.class.isAssignableFrom(TypeHandling.getClassWithName((String)className));
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<MRI, Map<String, Object>> introspectMBean(ObjectName mbean) {
        HashMap<MRI, Map<String, Object>> cachedMBeanInfo;
        Map<ObjectName, Map<MRI, Map<String, Object>>> map = this.cachedMRIMetaData;
        synchronized (map) {
            Map<MRI, Map<String, Object>> mbeanMetaData = this.cachedMRIMetaData.get(mbean);
            if (mbeanMetaData == null && (mbeanMetaData = this.lookupMBeanMRIData(mbean)) == null) {
                return Collections.emptyMap();
            }
            cachedMBeanInfo = new HashMap<MRI, Map<String, Object>>(mbeanMetaData);
            boolean hasIntrospected = true;
            for (Map.Entry<MRI, Map<String, Object>> entry : mbeanMetaData.entrySet()) {
                if (!this.isComposite(entry.getValue())) continue;
                CompositeType type = this.getCompositeType(entry.getValue());
                if (type != null) {
                    cachedMBeanInfo.putAll(this.introspectChildren(entry.getKey(), type, entry.getValue()));
                    continue;
                }
                CompositeData compositeData = this.getCompositeData(entry.getKey());
                if (compositeData != null) {
                    cachedMBeanInfo.putAll(this.introspectChildren(entry.getKey(), compositeData.getCompositeType(), entry.getValue()));
                    continue;
                }
                hasIntrospected = false;
            }
            this.cachedMRIMetaData.put(mbean, cachedMBeanInfo);
            if (hasIntrospected) {
                this.introspectedMBeans.add(mbean);
            }
        }
        return new HashMap<MRI, Map<String, Object>>(cachedMBeanInfo);
    }

    private boolean isComposite(Map<String, Object> metaData) {
        Object object = metaData.get("composite");
        if (object != null && object instanceof Boolean) {
            return (Boolean)object;
        }
        return false;
    }

    private CompositeType getCompositeType(Map<String, Object> metaData) {
        Object type;
        Object descriptor = metaData.get("Descriptor");
        if (descriptor instanceof Descriptor && (type = ((Descriptor)descriptor).getFieldValue("openType")) instanceof CompositeType) {
            return (CompositeType)type;
        }
        return null;
    }

    private CompositeData getCompositeData(MRI mri) {
        try {
            MRIValue attributeValue = this.mbeanService.getAttribute(mri);
            if (attributeValue != null && attributeValue.getValue() instanceof CompositeData) {
                return (CompositeData)attributeValue.getValue();
            }
            return null;
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Could not retrieve attribute: " + mri, e);
            return null;
        }
    }

    private Map<MRI, Map<String, Object>> introspectChildren(MRI parentMRI, CompositeType parentType, Map<String, Object> parentMetaData) {
        HashMap<MRI, Map<String, Object>> children = new HashMap<MRI, Map<String, Object>>();
        for (String key : parentType.keySet()) {
            String childAttribute = String.valueOf(key);
            MRI childMRI = new MRI(parentMRI, childAttribute);
            Map<String, Object> childMetaData = this.createChildMetaData(parentType, childAttribute, parentMetaData);
            children.put(childMRI, childMetaData);
            if (!this.isComposite(childMetaData)) continue;
            OpenType<?> type = parentType.getType(childAttribute);
            if (type instanceof CompositeType) {
                children.putAll(this.introspectChildren(childMRI, (CompositeType)type, childMetaData));
                continue;
            }
            CompositeData data = this.getCompositeData(childMRI);
            if (data == null) continue;
            children.putAll(this.introspectChildren(childMRI, data.getCompositeType(), childMetaData));
        }
        return children;
    }

    private Map<String, Object> createChildMetaData(CompositeType parentType, String childAttribute, Map<String, Object> parentMetaData) {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        metaData.put("DisplayName", childAttribute);
        metaData.put("Description", parentType.getDescription(childAttribute));
        metaData.put("AttributeType", parentType.getType(childAttribute).getClassName());
        metaData.put("composite", this.isCompositeType(parentType.getType(childAttribute).getClassName()));
        metaData.put("Readable", parentMetaData.get("Readable"));
        metaData.put("Writable", parentMetaData.get("Writable"));
        return metaData;
    }
}

