/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

import com.jrockit.mc.rjmx.ISyntheticAttribute;
import com.jrockit.mc.rjmx.RJMXPlugin;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;

public class MonitoredDeadlockedThreadCountAttribute
implements ISyntheticAttribute {
    private ThreadMXBean m_threadMBean;

    @Override
    public Object getValue(MBeanServerConnection connection) {
        ThreadMXBean threadMBean = this.getThreadMBean(connection);
        if (threadMBean == null) {
            return null;
        }
        long[] monitorDeadlockedThreads = threadMBean.findMonitorDeadlockedThreads();
        return monitorDeadlockedThreads == null ? 0 : monitorDeadlockedThreads.length;
    }

    private ThreadMXBean getThreadMBean(MBeanServerConnection connection) {
        if (this.m_threadMBean == null) {
            try {
                this.m_threadMBean = ManagementFactory.newPlatformMXBeanProxy(connection, "java.lang:type=Threading", ThreadMXBean.class);
            }
            catch (IOException e) {
                RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Unable to look up threading MX bean!", e);
            }
        }
        return this.m_threadMBean;
    }

    @Override
    public void setValue(MBeanServerConnection connection, Object value) {
    }
}

