/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.storage.internal;

import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.storage.internal.AbstractAttributeStorage;
import com.jrockit.mc.rjmx.subscription.storage.internal.AttributeStorageEventType;
import com.jrockit.mc.rjmx.subscription.storage.internal.AttributeStorageHandle;
import com.jrockit.mc.rjmx.subscription.storage.internal.DefaultAttributeStorageService;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorageListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

final class AttributeStorageHolder
extends AbstractAttributeStorage
implements IAttributeStorageListener {
    private final Set<AttributeStorageHandle> m_interestedHandles = new HashSet<AttributeStorageHandle>();
    private final DefaultAttributeStorageService m_storageService;
    private final MRI m_attributeDescriptor;
    private AbstractAttributeStorage m_storageImplementation;

    public AttributeStorageHolder(DefaultAttributeStorageService storageService, MRI attributeDescriptor, AbstractAttributeStorage storageImplementation) {
        this.m_storageService = storageService;
        this.m_attributeDescriptor = attributeDescriptor;
        this.setStorageImplementation(storageImplementation);
    }

    public AbstractAttributeStorage getStorageImplementation() {
        return this.m_storageImplementation;
    }

    public void setStorageImplementation(AbstractAttributeStorage storageImplementation) {
        this.clearStorageImplementation();
        if (storageImplementation != null) {
            this.m_storageImplementation = storageImplementation;
            this.m_storageImplementation.addStorageListener(this);
        }
    }

    private void clearStorageImplementation() {
        if (this.m_storageImplementation != null) {
            this.m_storageImplementation.removeStorageListener(this);
        }
    }

    public synchronized void addInterestedHandle(AttributeStorageHandle handle) {
        if (this.m_interestedHandles.contains(handle)) {
            throw new IllegalStateException("Handle already interested of holder!");
        }
        this.m_interestedHandles.add(handle);
    }

    public synchronized void removeInterestedHandle(AttributeStorageHandle handle) {
        if (!this.m_interestedHandles.contains(handle)) {
            throw new IllegalStateException("Handle not interested of holder!");
        }
        this.m_interestedHandles.remove(handle);
        if (this.m_interestedHandles.size() < 1) {
            this.dispose();
        }
    }

    @Override
    public Iterator<MRIValueEvent> iterator() {
        if (this.m_storageImplementation == null) {
            return this.createEmptyIterator();
        }
        return this.m_storageImplementation.iterator();
    }

    @Override
    public Iterator<MRIValueEvent> iterator(long from, long to) {
        if (this.m_storageImplementation == null) {
            return this.createEmptyIterator();
        }
        return this.m_storageImplementation.iterator(from, to);
    }

    private Iterator<MRIValueEvent> createEmptyIterator() {
        List list = Collections.emptyList();
        return list.iterator();
    }

    @Override
    public void dispose() {
        this.m_storageService.removeAttributeStorageHolder(this.m_attributeDescriptor);
        this.clearStorageImplementation();
    }

    @Override
    protected void storeEvent(MRIValueEvent event) {
    }

    @Override
    public void storageUpdated(AttributeStorageEventType type, MRIValueEvent event) {
        this.fireStorageEvent(type, event);
    }
}

