/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.storage.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.internal.PreferencesKeys;
import com.jrockit.mc.rjmx.persistence.internal.PersistentDataAggregator;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.storage.internal.AbstractAttributeStorage;
import com.jrockit.mc.rjmx.subscription.storage.internal.AttributeStorageHandle;
import com.jrockit.mc.rjmx.subscription.storage.internal.BufferedPersistingAttributeStorage;
import com.jrockit.mc.rjmx.subscription.storage.internal.BufferingAttributeStorage;
import com.jrockit.mc.rjmx.subscription.storage.internal.DefaultAttributeStorageService;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorageService;
import java.io.File;
import java.util.logging.Level;

public final class AttributeStorageToolkit {
    public static final String XML_ELEMENT_PERSISTENCE_PATH = "persistence_path";

    static {
        AttributeStorageToolkit.createPersistenceDirectory();
    }

    private AttributeStorageToolkit() {
    }

    public static void createPersistenceDirectory() {
        String directory = System.getProperty("com.jrockit.console.preferences.persistence_path", PreferencesKeys.DEFAULT_PERSISTENCE_PATH);
        File f = new File(directory);
        if (!f.isDirectory() && !f.mkdirs()) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, String.format("Could not create persistence directory %s. Logging attributes to disk will fail!", f.toString()));
        }
    }

    public static void updateStoragesForAttributes(IConnectionHandle connectionHandle, IMRIMetaData[] infos) {
        DefaultAttributeStorageService attributeStorageService = (DefaultAttributeStorageService)connectionHandle.getServiceOrDummy(IAttributeStorageService.class);
        PersistentDataAggregator persistentDataAggregator = attributeStorageService.getPersistentDataAggregator();
        IMRIMetaData[] iMRIMetaDataArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IMRIMetaData info = iMRIMetaDataArray[n2];
            AttributeStorageHandle currentHandle = attributeStorageService.getAttributeStorage(info.getMRI());
            AbstractAttributeStorage storage = persistentDataAggregator.isPersistenceEnabledFor(info) ? AttributeStorageToolkit.getPersistingAttributeStorage(currentHandle, persistentDataAggregator) : AttributeStorageToolkit.getNonPersistingAttributeStorage(currentHandle);
            attributeStorageService.setAttributeStorage(info.getMRI(), storage);
            if (currentHandle != null) {
                currentHandle.dispose();
            }
            ++n2;
        }
    }

    private static BufferedPersistingAttributeStorage getPersistingAttributeStorage(AttributeStorageHandle currentHandle, PersistentDataAggregator persistentDataAggregator) {
        if (currentHandle == null) {
            return new BufferedPersistingAttributeStorage(persistentDataAggregator);
        }
        return new BufferedPersistingAttributeStorage(persistentDataAggregator, currentHandle.iterator());
    }

    private static BufferingAttributeStorage getNonPersistingAttributeStorage(AttributeStorageHandle currentHandle) {
        if (currentHandle == null) {
            return new BufferingAttributeStorage();
        }
        return new BufferingAttributeStorage(currentHandle.iterator());
    }
}

