/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.storage.internal;

import com.jrockit.mc.rjmx.persistence.internal.AggregatorClosedException;
import com.jrockit.mc.rjmx.persistence.internal.PersistentDataAggregator;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.storage.internal.AbstractAttributeStorage;
import com.jrockit.mc.rjmx.subscription.storage.internal.BufferingAttributeStorage;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BufferedPersistingAttributeStorage
extends AbstractAttributeStorage {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private final BufferingAttributeStorage readBufferStorage;
    private final PersistentDataAggregator persistenceAggregator;

    public BufferedPersistingAttributeStorage(PersistentDataAggregator persistenceAggregator) {
        this(persistenceAggregator, new BufferingAttributeStorage());
    }

    public BufferedPersistingAttributeStorage(PersistentDataAggregator persistenceAggregator, Iterator<MRIValueEvent> eventIterator) {
        this(persistenceAggregator);
        if (eventIterator != null) {
            while (eventIterator.hasNext()) {
                this.readBufferStorage.storeEvent(eventIterator.next());
            }
        }
    }

    public BufferedPersistingAttributeStorage(PersistentDataAggregator persistenceAggregator, BufferingAttributeStorage readBuffer) {
        this.readBufferStorage = readBuffer;
        this.persistenceAggregator = persistenceAggregator;
    }

    public BufferingAttributeStorage getBufferAttributeStorage() {
        return this.readBufferStorage;
    }

    @Override
    protected void storeEvent(MRIValueEvent event) {
        this.readBufferStorage.storeEvent(event);
        this.persistEvent(event);
    }

    public void persistEvent(MRIValueEvent event) {
        try {
            this.persistenceAggregator.addAttributeEvent(event);
        }
        catch (AggregatorClosedException e) {
            LOGGER.log(Level.FINE, "Could not add attribute event to the persistance storage since it was closed.", e);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not add attribute event to the persistance storage.", e);
        }
    }

    @Override
    public Iterator<MRIValueEvent> iterator(long from, long to) {
        return this.readBufferStorage.iterator(from, to);
    }

    @Override
    public Iterator<MRIValueEvent> iterator() {
        return this.readBufferStorage.iterator();
    }

    @Override
    public void dispose() {
        this.readBufferStorage.dispose();
    }
}

