/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.storage.internal;

import com.jrockit.mc.common.util.BoundedList;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.storage.internal.AbstractAttributeStorage;
import com.jrockit.mc.rjmx.subscription.storage.internal.FromToIterator;
import java.util.Iterator;

public class BufferingAttributeStorage
extends AbstractAttributeStorage {
    private static final int DEFAULT_CACHE_SIZE = 604800;
    private final BoundedList<MRIValueEvent> m_cache;

    public BufferingAttributeStorage() {
        this(604800);
    }

    public BufferingAttributeStorage(int blockSize) {
        this.m_cache = new BoundedList(blockSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferingAttributeStorage(Iterator<MRIValueEvent> eventIterator) {
        this(604800);
        if (eventIterator != null) {
            Iterator<MRIValueEvent> iterator = eventIterator;
            synchronized (iterator) {
                while (eventIterator.hasNext()) {
                    this.storeEvent(eventIterator.next());
                }
            }
        }
    }

    @Override
    protected synchronized void storeEvent(MRIValueEvent event) {
        this.m_cache.add((Object)event);
    }

    @Override
    public Iterator<MRIValueEvent> iterator(long from, long to) {
        return new FromToIterator(this.m_cache.iterator(), from, to);
    }

    @Override
    public Iterator<MRIValueEvent> iterator() {
        return this.m_cache.iterator();
    }

    @Override
    public void dispose() {
        this.m_cache.clear();
    }
}

