/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.storage.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.internal.IDisposableService;
import com.jrockit.mc.rjmx.persistence.internal.PersistenceSettings;
import com.jrockit.mc.rjmx.persistence.internal.PersistentDataAggregator;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.storage.internal.AbstractAttributeStorage;
import com.jrockit.mc.rjmx.subscription.storage.internal.AttributeStorageHandle;
import com.jrockit.mc.rjmx.subscription.storage.internal.AttributeStorageHolder;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorageService;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultAttributeStorageService
implements IAttributeStorageService,
IDisposableService {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private final IConnectionHandle handle;
    private final ISubscriptionService attributeSubscriptionService;
    private PersistentDataAggregator aggregator;
    private final Map<MRI, AttributeStorageHolder> activeStorages = new HashMap<MRI, AttributeStorageHolder>();
    private final PersistenceSettings persistenceSettings;

    public DefaultAttributeStorageService(IConnectionHandle handle, PersistenceSettings persistenceSettings) {
        this.handle = handle;
        this.attributeSubscriptionService = handle.getServiceOrDummy(ISubscriptionService.class);
        this.persistenceSettings = persistenceSettings;
    }

    public synchronized PersistentDataAggregator getPersistentDataAggregator() {
        if (this.aggregator == null) {
            this.aggregator = new PersistentDataAggregator(this.handle, this.persistenceSettings);
        }
        return this.aggregator;
    }

    public synchronized void closePersistentDataAggregator() {
        if (this.aggregator != null) {
            try {
                this.aggregator.close();
            }
            catch (IOException ioe) {
                LOGGER.log(Level.WARNING, "Could not close the persistence logs.", ioe);
            }
            this.aggregator = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttributeStorage(MRI attributeDescriptor, AbstractAttributeStorage attributeStorage) {
        if (attributeStorage == null) {
            throw new NullPointerException("Attribute storage must not be null!");
        }
        AttributeStorageHolder holder = this.getAttributeStorageHolder(attributeDescriptor);
        if (holder == null) {
            this.addSubscription(attributeDescriptor, attributeStorage);
            holder = new AttributeStorageHolder(this, attributeDescriptor, attributeStorage);
            Map<MRI, AttributeStorageHolder> map = this.activeStorages;
            synchronized (map) {
                this.activeStorages.put(attributeDescriptor, holder);
            }
        } else {
            this.swapSubscription(attributeDescriptor, holder.getStorageImplementation(), attributeStorage);
            holder.setStorageImplementation(attributeStorage);
        }
    }

    @Override
    public AttributeStorageHandle getAttributeStorage(MRI attributeDescriptor) {
        AttributeStorageHolder holder = this.getAttributeStorageHolder(attributeDescriptor);
        if (holder != null) {
            return new AttributeStorageHandle(holder);
        }
        return null;
    }

    private void addSubscription(MRI attributeDescriptor, AbstractAttributeStorage attributeStorage) {
        if (attributeStorage != null) {
            this.attributeSubscriptionService.addMRIValueListener(attributeDescriptor, attributeStorage.getAttributeValueListener());
        }
    }

    private void removeSubscription(MRI attributeDescriptor, AbstractAttributeStorage attributeStorage) {
        if (attributeStorage != null) {
            this.attributeSubscriptionService.removeMRIValueListener(attributeDescriptor, attributeStorage.getAttributeValueListener());
        }
    }

    private void swapSubscription(MRI attributeDescriptor, AbstractAttributeStorage oldAttributeStorage, AbstractAttributeStorage newAttributeStorage) {
        if (oldAttributeStorage != null && newAttributeStorage != null) {
            this.attributeSubscriptionService.substituteMRIValueListener(oldAttributeStorage.getAttributeValueListener(), newAttributeStorage.getAttributeValueListener());
        } else {
            this.removeSubscription(attributeDescriptor, oldAttributeStorage);
            this.addSubscription(attributeDescriptor, newAttributeStorage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AttributeStorageHolder getAttributeStorageHolder(MRI attributeDescriptor) {
        Map<MRI, AttributeStorageHolder> map = this.activeStorages;
        synchronized (map) {
            return this.activeStorages.get(attributeDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttributeStorageHolder(MRI attributeDescriptor) {
        AttributeStorageHolder holder = null;
        Map<MRI, AttributeStorageHolder> map = this.activeStorages;
        synchronized (map) {
            holder = this.activeStorages.remove(attributeDescriptor);
        }
        if (holder != null) {
            this.removeSubscription(attributeDescriptor, holder.getStorageImplementation());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Map<MRI, AttributeStorageHolder> map = this.activeStorages;
        synchronized (map) {
            AttributeStorageHolder[] holders;
            Collection<AttributeStorageHolder> values = this.activeStorages.values();
            AttributeStorageHolder[] attributeStorageHolderArray = holders = values.toArray(new AttributeStorageHolder[values.size()]);
            int n = holders.length;
            int n2 = 0;
            while (n2 < n) {
                AttributeStorageHolder holder = attributeStorageHolderArray[n2];
                holder.dispose();
                ++n2;
            }
        }
        this.closePersistentDataAggregator();
    }
}

