/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.actions.internal;

import com.jrockit.mc.common.debug.Debug;
import com.jrockit.mc.rjmx.triggers.TriggerAction;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.actions.internal.Messages;
import com.jrockit.mc.rjmx.triggers.internal.NotificationToolkit;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.eclipse.osgi.util.NLS;

public class TriggerActionMail
extends TriggerAction {
    public static final String XML_ELEMENT_EMAIL_FROM = "email_from";
    public static final String XML_ELEMENT_EMAIL_TO = "email_to";
    public static final String XML_ELEMENT_EMAIL_CC = "email_cc";
    public static final String XML_ELEMENT_SMTP_SERVER = "smtp_server";
    public static final String XML_ELEMENT_SMTP_USER = "smtp_server_user";
    public static final String XML_ELEMENT_SMTP_PASSWD = "smtp_server_password";
    public static final String XML_ELEMENT_SMTP_PORT = "smtp_server_port";
    public static final String XML_ELEMENT_SMTP_SSL = "smtp_server_secure";
    private static final String MAILER = Messages.TriggerActionMail_MAIL_HEADER_MAILER;

    @Override
    public void handleNotificationEvent(TriggerEvent e) throws MessagingException {
        String subject = this.getSubject(e);
        this.sendEMail(subject, NotificationToolkit.prettyPrint(e));
    }

    public void sendEMail(String subject, String content) throws MessagingException {
        Properties props = new Properties();
        Session session = Session.getInstance((Properties)props, null);
        session.setPasswordAuthentication(this.createURLName(), this.createPasswordAuthentication());
        if (Debug.isDebug()) {
            session.setDebug(true);
        }
        MimeMessage msg = new MimeMessage(session);
        if (this.getFrom() != null && this.getFrom().length() > 0) {
            msg.setFrom((Address)new InternetAddress(this.getFrom()));
        } else if (this.getSmtpUser() != null && this.getSmtpUser().length() > 0) {
            msg.setFrom((Address)new InternetAddress(this.getSmtpUser()));
        }
        if (this.getTo() != null && this.getTo().length() > 0) {
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.getTo(), (boolean)false));
        } else if (this.getSmtpUser() != null && this.getSmtpUser().length() > 0) {
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.getSmtpUser(), (boolean)false));
        }
        if (this.getCc() != null && this.getCc().length() > 0) {
            msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.getCc(), (boolean)false));
        }
        msg.setSubject(subject);
        msg.setText(content);
        msg.setHeader("X-Mailer", MAILER);
        msg.setSentDate(new Date());
        Transport transport = session.getTransport(this.createURLName());
        transport.connect();
        transport.sendMessage((Message)msg, msg.getAllRecipients());
        transport.close();
    }

    private URLName createURLName() {
        String protocol = this.getSmtpSSL() != false ? "smtps" : "smtp";
        return new URLName(protocol, this.getSmtpServer(), this.getSmtpPort().intValue(), null, this.getSmtpUser(), this.getSmtpPassword());
    }

    private PasswordAuthentication createPasswordAuthentication() {
        return new PasswordAuthentication(this.getSmtpUser(), this.getSmtpPassword());
    }

    private String getSmtpServer() {
        return this.getSetting(XML_ELEMENT_SMTP_SERVER).getString();
    }

    private String getSmtpUser() {
        return this.getSetting(XML_ELEMENT_SMTP_USER).getString();
    }

    private String getSmtpPassword() {
        return this.getSetting(XML_ELEMENT_SMTP_PASSWD).getPassword();
    }

    private Integer getSmtpPort() {
        return this.getSetting(XML_ELEMENT_SMTP_PORT).getInteger();
    }

    private Boolean getSmtpSSL() {
        return this.getSetting(XML_ELEMENT_SMTP_SSL).getBoolean();
    }

    private String getCc() {
        return this.getSetting(XML_ELEMENT_EMAIL_CC).getString();
    }

    private String getFrom() {
        return this.getSetting(XML_ELEMENT_EMAIL_FROM).getString();
    }

    private String getTo() {
        return this.getSetting(XML_ELEMENT_EMAIL_TO).getString();
    }

    private String getSubject(TriggerEvent e) {
        if (e.wasTriggered()) {
            return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_TRIGGERED, (Object)e.getRule().getName());
        }
        if (e.wasRecovered()) {
            return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_RECOVERED, (Object)e.getRule().getName());
        }
        return NLS.bind((String)Messages.TriggerActionMail_SUBJECT_INVOKED, (Object)e.getRule().getName());
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "{From: " + this.getFrom() + "\nTo: " + this.getTo() + "\nSMTP: " + this.getSmtpServer() + '}';
    }
}

