/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.condition.internal;

import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.triggers.IValueEvaluator;
import com.jrockit.mc.rjmx.triggers.condition.internal.Messages;
import com.jrockit.mc.rjmx.triggers.fields.internal.BooleanField;
import com.jrockit.mc.rjmx.triggers.fields.internal.Field;
import com.jrockit.mc.rjmx.triggers.fields.internal.FieldHolder;
import com.jrockit.mc.rjmx.triggers.fields.internal.FloatField;
import com.jrockit.mc.rjmx.triggers.fields.internal.IntegerField;
import com.jrockit.mc.rjmx.triggers.fields.internal.StringField;
import com.jrockit.mc.rjmx.triggers.internal.INotificationFactory;
import com.jrockit.mc.rjmx.triggers.internal.NotificationTrigger;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluatorNumberMax;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluatorNumberMin;
import com.jrockit.mc.rjmx.triggers.internal.ValueEvaluatorStringMatch;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class TriggerCondition
extends NotificationTrigger {
    private FieldHolder m_fieldHolder;

    void initEvaluator() {
        try {
            IValueEvaluator ve = this.getValueEvaluator();
            if (ve instanceof ValueEvaluatorNumberMax) {
                this.createNumberMaxEvaluatorField((float)((ValueEvaluatorNumberMax)ve).getMax());
            } else {
                this.createNumberMaxEvaluatorField(0.0f);
            }
            if (ve instanceof ValueEvaluatorNumberMin) {
                this.createNumberMinEvaluatorField((float)((ValueEvaluatorNumberMin)ve).getMin());
            } else {
                this.createNumberMinEvaluatorField(0.0f);
            }
            if (ve instanceof ValueEvaluatorStringMatch) {
                this.createStringEvaluatorField(((ValueEvaluatorStringMatch)ve).getMatchString());
            } else {
                this.createStringEvaluatorField("*");
            }
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    public void initFieldHolder() {
        this.m_fieldHolder = new FieldHolder();
        try {
            this.initEvaluator();
            this.createSustained();
            this.createLimit();
            this.createFlankBegin();
            this.createFlankEnd();
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    public void initializeFromXml(Element node, INotificationFactory factory) {
        super.initializeFromXml(node, factory);
        this.initFieldHolder();
    }

    public FieldHolder getFieldHolder() {
        return this.m_fieldHolder;
    }

    private void createFlankEnd() throws Exception {
        boolean descendingFlank = (this.getTriggerOn() & 1) != 0;
        BooleanField triggeronFlankEnd = new BooleanField("ONFLANK", Messages.TriggerCondition_DESCENDING_FLANK_CAPTION, Boolean.toString(descendingFlank), Messages.TriggerCondition_DESCENDING_FLANK_TOOLTIP);
        this.m_fieldHolder.addField(triggeronFlankEnd);
        triggeronFlankEnd.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field field) {
                TriggerCondition.this.setTriggerFlag(2, field.getBoolean());
            }
        });
    }

    private void createFlankBegin() throws Exception {
        boolean ascendingFlank = (this.getTriggerOn() & 1) != 0;
        BooleanField triggeronFlankStart = new BooleanField("ONTRIGGER", Messages.TriggerCondition_ASCENDING_FLANK_CAPTION, Boolean.toString(ascendingFlank), Messages.TriggerCondition_ASCENDING_FLANK_TOOLTIP);
        this.m_fieldHolder.addField(triggeronFlankStart);
        triggeronFlankStart.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field field) {
                TriggerCondition.this.setTriggerFlag(1, field.getBoolean());
            }
        });
    }

    private void createLimit() throws Exception {
        IntegerField limitField = new IntegerField("LIMIT", Messages.TriggerCondition_LIMIT_PERIOD_CAPTION, Integer.toString(this.getLimitTime()), Messages.TriggerCondition_LIMIT_PERIOD_TOOLTIP, "0", String.valueOf(Integer.MAX_VALUE));
        this.m_fieldHolder.addField(limitField);
        limitField.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field field) {
                TriggerCondition.this.setLimitTime(field.getInteger());
            }
        });
    }

    private void createSustained() throws Exception {
        IntegerField sustained = new IntegerField("SUSTAINED", Messages.TriggerCondition_SUSTAINED_CAPTION, Integer.toString(this.getSustainTime()), Messages.TriggerCondition_SUSTAINED_TOOLTIP, "0", String.valueOf(Integer.MAX_VALUE));
        this.m_fieldHolder.addField(sustained);
        sustained.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field value) {
                TriggerCondition.this.setSustainTime(value.getInteger());
            }
        });
    }

    private void createStringEvaluatorField(String matchString) throws Exception {
        StringField evaluatorField = new StringField("EVAL_STRING", Messages.TriggerCondition_MATCH_STRING_CAPTION, matchString, Messages.TriggerCondition_MATCH_STRING_TOOLTIP);
        this.m_fieldHolder.addField(evaluatorField);
        evaluatorField.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field field) {
                TriggerCondition.this.setValueEvaluator(new ValueEvaluatorStringMatch(field.getString()));
            }
        });
    }

    private void createNumberMaxEvaluatorField(float maxValue) throws Exception {
        FloatField evaluatorField = new FloatField("EVAL_NUM_MAX", Messages.TriggerCondition_MAX_TRIGGER_CAPTION, Float.toString(maxValue), Messages.TriggerCondition_MAX_TRIGGER_TOOLTIP, "", "");
        this.m_fieldHolder.addField(evaluatorField);
        evaluatorField.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field field) {
                TriggerCondition.this.setValueEvaluator(new ValueEvaluatorNumberMax(field.getFloat().doubleValue()));
            }
        });
    }

    private void createNumberMinEvaluatorField(float minValue) throws Exception {
        FloatField evaluatorField = new FloatField("EVAL_NUM_MIN", Messages.TriggerCondition_MIN_TRIGGER_CAPTION, Float.toString(minValue), Messages.TriggerCondition_MIN_TRIGGER_TOOLTIP, "", "");
        this.m_fieldHolder.addField(evaluatorField);
        evaluatorField.addFieldValueListener(new Field.FieldValueChangeListener(){

            @Override
            public void onChange(Field field) {
                TriggerCondition.this.setValueEvaluator(new ValueEvaluatorNumberMin(field.getFloat().doubleValue()));
            }
        });
    }

    public void setTriggerFlag(int flag, boolean value) {
        int triggerOn = this.getTriggerOn();
        triggerOn = value ? triggerOn | flag : triggerOn & ~flag;
        this.setTriggerOn(triggerOn);
    }
}

