/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.fields.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.triggers.fields.internal.Field;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class FieldHolder {
    private static final String XML_SETTINGS_TAG = "settings";
    private ArrayList<Tuple> m_properties = new ArrayList();

    public void addField(Field v) {
        if (this.getField(v.getName()) == null) {
            this.m_properties.add(new Tuple(v.getId(), v));
        }
    }

    public Field[] getFields() {
        Field[] fields = new Field[this.m_properties.size()];
        int n = 0;
        for (Tuple tuple : this.m_properties) {
            fields[n] = tuple.field;
            ++n;
        }
        return fields;
    }

    public void exportToXml(Element parentNode) {
        Field[] fields = this.getFields();
        Element element = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.exportToXml(element);
            ++n2;
        }
    }

    public void initializeFromXml(Element node) {
        Field[] fields;
        Field[] fieldArray = fields = this.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            NodeList list = node.getElementsByTagName(this.getComponentTag());
            if (list != null && list.getLength() > 0) {
                field.initializeFromXml((Element)list.item(0));
            }
            ++n2;
        }
    }

    public Field getField(String id) {
        for (Tuple tuple : this.m_properties) {
            if (!tuple.key.equals(id)) continue;
            return tuple.field;
        }
        return null;
    }

    protected String getComponentTag() {
        return XML_SETTINGS_TAG;
    }

    static class Tuple {
        public final String key;
        public final Field field;

        Tuple(String id, Field field) {
            this.key = id;
            this.field = field;
        }
    }
}

