/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.internal.AbstractNotificationAction;
import com.jrockit.mc.rjmx.triggers.internal.NotificationToolkit;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.w3c.dom.Element;

public final class NotificationActionMail
extends AbstractNotificationAction {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    public static final String XML_ELEMENT_EMAIL_FROM = "email_from";
    public static final String XML_ELEMENT_EMAIL_TO = "email_to";
    public static final String XML_ELEMENT_EMAIL_CC = "email_cc";
    public static final String XML_ELEMENT_EMAIL_BCC = "email_bcc";
    public static final String XML_ELEMENT_SMTP_SERVER = "smtp_server";
    public static final String NAME = "Send e-mail";
    public static final String DESCRIPTION = "E-mails the notification event using the user defined settings.";
    private static final String MAILER = "JRockit Console Automailer";
    private static final boolean DEBUG = false;
    private String m_smtpServer;
    private String m_from;
    private String m_to;
    private String m_cc;
    private String m_bcc;

    @Override
    public void handleNotificationEvent(TriggerEvent e) {
        String subject = this.getSubject(e);
        this.sendEMail(subject, NotificationToolkit.prettyPrint(e));
    }

    public void sendEMail(String subject, String content) {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.getSmtpServer());
        Session session = Session.getInstance((Properties)props, null);
        try {
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(this.getFrom()));
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)this.getTo(), (boolean)false));
            if (this.getCc() != null) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)this.getCc(), (boolean)false));
            }
            if (this.getBcc() != null) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)this.getBcc(), (boolean)false));
            }
            msg.setSubject(subject);
            msg.setText(content);
            msg.setHeader("X-Mailer", MAILER);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "A notification rule with an e-mail action has triggered, but the sending\nof the e-mail failed, probably due to wrong settings. The e-mail \nwas sent using the following configuration:\n " + this.toString(), e);
        }
    }

    public String getSmtpServer() {
        return this.m_smtpServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.m_smtpServer = smtpServer;
    }

    public String getBcc() {
        return this.m_bcc;
    }

    public void setBcc(String bcc) {
        this.m_bcc = bcc;
    }

    public String getCc() {
        return this.m_cc;
    }

    public void setCc(String cc) {
        this.m_cc = cc;
    }

    public String getFrom() {
        return this.m_from;
    }

    public void setFrom(String from) {
        this.m_from = from;
    }

    public String getTo() {
        return this.m_to;
    }

    public void setTo(String to) {
        this.m_to = to;
    }

    public String getSubject(TriggerEvent e) {
        if (e.wasTriggered()) {
            return "The rule \"" + e.getRule().getName() + "\" has triggered!";
        }
        if (e.wasRecovered()) {
            return "The rule \"" + e.getRule().getName() + "\" has recovered!";
        }
        return "The rule \"" + e.getRule().getName() + "\" was invoked!";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    public String toString() {
        return String.valueOf(this.getName()) + "\nFrom: " + this.getFrom() + "\nTo: " + this.getTo() + "\nSMTP: " + this.getSmtpServer();
    }

    @Override
    public void initializeFromXml(Element node) {
        String smtpServer = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_SMTP_SERVER, (String)"mail.example.com");
        String from = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_EMAIL_FROM, (String)"email@example.com");
        String to = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_EMAIL_TO, (String)"email@example.com");
        String cc = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_EMAIL_CC, null);
        String bcc = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_EMAIL_BCC, null);
        this.setSmtpServer(smtpServer);
        this.setFrom(from);
        this.setTo(to);
        this.setCc(cc);
        this.setBcc(bcc);
    }

    @Override
    public void exportToXml(Element actionNode) {
        XmlToolkit.setSetting((Element)actionNode, (String)XML_ELEMENT_SMTP_SERVER, (String)this.getSmtpServer());
        XmlToolkit.setSetting((Element)actionNode, (String)XML_ELEMENT_EMAIL_FROM, (String)this.getFrom());
        XmlToolkit.setSetting((Element)actionNode, (String)XML_ELEMENT_EMAIL_TO, (String)this.getTo());
        XmlToolkit.setSetting((Element)actionNode, (String)XML_ELEMENT_EMAIL_CC, (String)this.getCc());
        XmlToolkit.setSetting((Element)actionNode, (String)XML_ELEMENT_EMAIL_BCC, (String)this.getBcc());
    }
}

