/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.triggers.IExceptionHandler;
import com.jrockit.mc.rjmx.triggers.ITrigger;
import com.jrockit.mc.rjmx.triggers.IValueEvaluator;
import com.jrockit.mc.rjmx.triggers.TriggerEvent;
import com.jrockit.mc.rjmx.triggers.TriggerRule;
import com.jrockit.mc.rjmx.triggers.extension.internal.ExtensionLoader;
import com.jrockit.mc.rjmx.triggers.internal.INotificationFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class NotificationTrigger
implements XmlEnabled,
ITrigger {
    public static final int TRIGGER_ON_RULE_TRIGGERED = 1;
    public static final int TRIGGER_ON_RULE_RECOVERED = 2;
    public static final int TRIGGER_ON_RULE_TRIGGERED_AND_RECOVERED = 3;
    public static final int STATE_START = 0;
    public static final int STATE_TRIGGER_HIGH = 1;
    public static final int STATE_TRIGGER_LOW = 2;
    public static final int STATE_WAITING_SUSTAIN_HIGH = 3;
    public static final int STATE_WAITING_SUSTAIN_LOW = 4;
    private static final String XML_COMPONENT_TAG = "trigger";
    private static final String XML_ELEMENT_LIMIT_PERIOD = "trigger_limit_period";
    private static final String XML_ELEMENT_SUSTAIN_TIME = "trigger_sustain_time";
    private static final String XML_ELEMENT_ON_WHAT = "trigger_on_what";
    private static final String XML_VALUE_EVALUATOR_COMPONENT_TAG = "value_evaluator";
    private static final String XML_VALUE_EVALUATOR_TYPE_ATTRIBUTE_NAME = "type";
    public static final String XML_ELEMENT_ATTRIBUTE_NAME = "notification_attribute_name";
    private volatile MRI m_notificationAttributeDescriptor;
    private volatile IValueEvaluator m_valueEvaluator;
    private volatile int m_limitTime;
    private volatile int m_sustainTime;
    private volatile int m_triggerOn = 3;
    private final HashMap<String, StateStore> uidToStateStoreMap = new HashMap();
    private static final List<IExceptionHandler> EXCEPTION_HANDLERS = new LinkedList<IExceptionHandler>();

    public NotificationTrigger() {
    }

    public NotificationTrigger(MRI descriptor, IValueEvaluator evaluator) {
        this.setAttributeDescriptor(descriptor);
        this.setValueEvaluator(evaluator);
    }

    @Override
    public MRI getAttributeDescriptor() {
        return this.m_notificationAttributeDescriptor;
    }

    public void setAttributeDescriptor(MRI notificationAttributeDescriptor) {
        this.m_notificationAttributeDescriptor = notificationAttributeDescriptor;
    }

    @Override
    public IValueEvaluator getValueEvaluator() {
        return this.m_valueEvaluator;
    }

    public void setValueEvaluator(IValueEvaluator valueEvaluator) {
        this.m_valueEvaluator = valueEvaluator;
    }

    private StateStore getStateStoreForUID(String uid) {
        StateStore store = this.uidToStateStoreMap.get(uid);
        if (store == null) {
            store = new StateStore();
            this.uidToStateStoreMap.put(uid, store);
        }
        return store;
    }

    @Override
    public void triggerOn(IConnectionHandle connectionHandle, TriggerRule rule, MRIValueEvent aspectEvent) {
        if (aspectEvent.getValue() == null) {
            return;
        }
        StateStore stateStore = this.getStateStoreForUID(connectionHandle.getServerDescriptor().getGUID());
        if (stateStore.m_triggerState == 0) {
            stateStore.m_triggerState = this.getValueEvaluator().triggerOn(aspectEvent.getValue()) ? 3 : 4;
            stateStore.m_lastSwitchEventTimestamp = aspectEvent.getTimestamp();
        }
        switch (stateStore.m_triggerState) {
            case 3: {
                if (aspectEvent.getTimestamp() - stateStore.m_lastSwitchEventTimestamp >= (long)this.getSustainTimeMillis() && (this.getTriggerOn() & 1) > 0 && (stateStore.m_lastTriggerEventTimestamp == null || aspectEvent.getTimestamp() - stateStore.m_lastTriggerEventTimestamp >= (long)this.getLimitTimeMillis())) {
                    this.doTrigger(1, connectionHandle, rule, aspectEvent);
                }
                if (this.getValueEvaluator().triggerOn(aspectEvent.getValue())) break;
                stateStore.m_lastSwitchEventTimestamp = aspectEvent.getTimestamp();
                stateStore.m_triggerState = 4;
                break;
            }
            case 1: {
                if (this.getValueEvaluator().triggerOn(aspectEvent.getValue())) break;
                stateStore.m_lastSwitchEventTimestamp = aspectEvent.getTimestamp();
                stateStore.m_triggerState = 4;
                break;
            }
            case 2: {
                if (!this.getValueEvaluator().triggerOn(aspectEvent.getValue())) break;
                stateStore.m_lastSwitchEventTimestamp = aspectEvent.getTimestamp();
                stateStore.m_triggerState = 3;
                break;
            }
            case 4: {
                if (stateStore.m_lastTriggeredState == 1 && aspectEvent.getTimestamp() - stateStore.m_lastSwitchEventTimestamp >= (long)this.getSustainTimeMillis() && (this.getTriggerOn() & 2) > 0 && (stateStore.m_lastTriggerEventTimestamp == null || aspectEvent.getTimestamp() - stateStore.m_lastTriggerEventTimestamp >= (long)this.getLimitTimeMillis())) {
                    this.doTrigger(2, connectionHandle, rule, aspectEvent);
                }
                if (!this.getValueEvaluator().triggerOn(aspectEvent.getValue())) break;
                stateStore.m_lastSwitchEventTimestamp = aspectEvent.getTimestamp();
                stateStore.m_triggerState = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException("Trigger entered illegal state!");
            }
        }
    }

    private void doTrigger(int triggState, IConnectionHandle connectionHandle, TriggerRule rule, MRIValueEvent aspectEvent) {
        StateStore stateStore = this.getStateStoreForUID(connectionHandle.getServerDescriptor().getGUID());
        TriggerEvent event = new TriggerEvent(connectionHandle, rule, aspectEvent.getValue(), triggState == 1, (int)(aspectEvent.getTimestamp() - stateStore.m_lastSwitchEventTimestamp));
        if (!NotificationTrigger.checkConstraints(rule, event)) {
            return;
        }
        stateStore.m_lastTriggeredState = triggState;
        stateStore.m_triggerState = triggState;
        stateStore.m_lastTriggerEventTimestamp = aspectEvent.getTimestamp();
        try {
            rule.getAction().handleNotificationEvent(event);
        }
        catch (Throwable e) {
            this.handleException(connectionHandle, rule, e);
        }
    }

    private void handleException(IConnectionHandle connectionHandle, TriggerRule rule, Throwable e) {
        IExceptionHandler[] handlers;
        IExceptionHandler[] iExceptionHandlerArray = handlers = this.getExceptionHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IExceptionHandler handler = iExceptionHandlerArray[n2];
            handler.handleException(connectionHandle, rule, e);
            ++n2;
        }
    }

    private synchronized IExceptionHandler[] getExceptionHandlers() {
        if (EXCEPTION_HANDLERS.size() == 0) {
            this.initializeExceptionHandlers();
        }
        return EXCEPTION_HANDLERS.toArray(new IExceptionHandler[EXCEPTION_HANDLERS.size()]);
    }

    private void initializeExceptionHandlers() {
        ExtensionLoader loader = new ExtensionLoader("com.jrockit.mc.rjmx.triggerActionExceptionHandlers", "exceptionHandler");
        EXCEPTION_HANDLERS.addAll(loader.getPrototypes());
    }

    private static boolean checkConstraints(TriggerRule rule, TriggerEvent e) {
        if (!rule.hasConstraints()) {
            return true;
        }
        return rule.getConstraintHolder().isValid(e);
    }

    public int getLimitTime() {
        return this.m_limitTime;
    }

    public int getLimitTimeMillis() {
        return this.m_limitTime * 1000;
    }

    public void setLimitTime(int waitTime) {
        this.m_limitTime = waitTime;
    }

    public String toString() {
        return "NotificationTrigger type = " + this.getAttributeDescriptor().toString() + "  eval = " + this.getValueEvaluator().toString();
    }

    public int getTriggerOn() {
        return this.m_triggerOn;
    }

    public void setTriggerOn(int triggerOn) {
        if (triggerOn < 0 || triggerOn > 3) {
            throw new IllegalArgumentException(String.valueOf(triggerOn) + " is not a valid trigger flank!");
        }
        this.m_triggerOn = triggerOn;
    }

    public void initializeFromXml(Element node) {
    }

    public void initializeFromXml(Element node, INotificationFactory factory) {
        IValueEvaluator evaluator = null;
        int triggerOn = Integer.parseInt(XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_ON_WHAT, (String)String.valueOf(3)));
        int waitTime = Integer.parseInt(XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_LIMIT_PERIOD, (String)"0"));
        int sustainTime = Integer.parseInt(XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_SUSTAIN_TIME, (String)"0"));
        String typeName = XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_ATTRIBUTE_NAME, null);
        assert (typeName != null);
        MRI descriptor = MRI.createFromQualifiedName(typeName);
        Element evalNode = XmlToolkit.getOrCreateElement((Element)node, (String)XML_VALUE_EVALUATOR_COMPONENT_TAG);
        String evaluatorClass = evalNode.getAttribute(XML_VALUE_EVALUATOR_TYPE_ATTRIBUTE_NAME);
        if ("".equals(evaluatorClass) && (evaluatorClass = XmlToolkit.getSetting((Element)node, (String)"value_evaluator_class", null)) == null) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "No element specifying the value evaluator class!");
            return;
        }
        assert (evaluatorClass != null);
        try {
            evaluator = factory.createEvaluator(evaluatorClass);
        }
        catch (Exception e) {
            RJMXPlugin.getDefault().getLogger().log(Level.SEVERE, "Error instantiating value evaluator", e);
            return;
        }
        evaluator.initializeEvaluatorFromXml(evalNode);
        this.setAttributeDescriptor(descriptor);
        this.setTriggerOn(triggerOn);
        this.setValueEvaluator(evaluator);
        this.setSustainTime(sustainTime);
        this.setLimitTime(waitTime);
    }

    public void exportToXml(Element parentNode) {
        Element triggerNode = XmlToolkit.createElement((Element)parentNode, (String)XML_COMPONENT_TAG);
        XmlToolkit.setSetting((Element)triggerNode, (String)XML_ELEMENT_LIMIT_PERIOD, (String)Integer.toString(this.getLimitTime()));
        XmlToolkit.setSetting((Element)triggerNode, (String)XML_ELEMENT_SUSTAIN_TIME, (String)Integer.toString(this.getSustainTime()));
        XmlToolkit.setSetting((Element)triggerNode, (String)XML_ELEMENT_ON_WHAT, (String)Integer.toString(this.getTriggerOn()));
        XmlToolkit.setSetting((Element)triggerNode, (String)XML_ELEMENT_ATTRIBUTE_NAME, (String)this.getAttributeDescriptor().getQualifiedName());
        Element evalNode = XmlToolkit.createElement((Element)triggerNode, (String)XML_VALUE_EVALUATOR_COMPONENT_TAG);
        evalNode.setAttribute(XML_VALUE_EVALUATOR_TYPE_ATTRIBUTE_NAME, this.getValueEvaluator().getClass().getName());
        this.getValueEvaluator().exportEvaluatorToXml(evalNode);
    }

    @Override
    public int getSustainTime() {
        return this.m_sustainTime;
    }

    public int getSustainTimeMillis() {
        return this.m_sustainTime * 1000;
    }

    public void setSustainTime(int sustainTime) {
        this.m_sustainTime = sustainTime;
    }

    public String getComponentTag() {
        return XML_COMPONENT_TAG;
    }

    public void clearState(String uid) {
        this.uidToStateStoreMap.remove(uid);
    }

    static class StateStore {
        int m_lastTriggeredState = 0;
        int m_triggerState = 0;
        Long m_lastSwitchEventTimestamp;
        Long m_lastTriggerEventTimestamp;

        StateStore() {
        }
    }
}

