/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.triggers.IValueEvaluator;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public final class ValueEvaluatorNumberMax
implements IValueEvaluator {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private static final String XML_ELEMENT_MAXVALUE = "maxvalue";
    private double m_max;

    public ValueEvaluatorNumberMax() {
    }

    public ValueEvaluatorNumberMax(double max) {
        this.m_max = max;
    }

    @Override
    public boolean triggerOn(Object val) {
        if (!(val instanceof Number)) {
            return false;
        }
        return this.triggerOn(((Number)val).doubleValue());
    }

    private boolean triggerOn(double val) {
        boolean result = val > this.m_max;
        LOGGER.info("ValueEvaluatorNumberMax: " + val + " > " + this.m_max + " = " + result);
        return result;
    }

    public String toString() {
        return "value > " + (float)this.m_max;
    }

    public double getMax() {
        return this.m_max;
    }

    public void setMax(double maxValue) {
        this.m_max = maxValue;
    }

    @Override
    public void initializeEvaluatorFromXml(Element node) {
        this.setMax(Double.parseDouble(XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_MAXVALUE, (String)"0")));
    }

    @Override
    public void exportEvaluatorToXml(Element node) {
        XmlToolkit.setSetting((Element)node, (String)XML_ELEMENT_MAXVALUE, (String)Double.toString(this.getMax()));
    }

    @Override
    public String getOperatorString() {
        return ">";
    }

    @Override
    public String getEvaluationConditionString() {
        return "> " + (float)this.m_max;
    }
}

