/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.triggers.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.triggers.IValueEvaluator;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public final class ValueEvaluatorNumberMin
implements IValueEvaluator {
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rjmx");
    private static final String XML_ELEMENT_MINVALUE = "minvalue";
    private double m_min;

    public ValueEvaluatorNumberMin() {
    }

    public ValueEvaluatorNumberMin(double min) {
        this.m_min = min;
    }

    @Override
    public boolean triggerOn(Object val) {
        if (!(val instanceof Number)) {
            return false;
        }
        return this.triggerOn(((Number)val).doubleValue());
    }

    private boolean triggerOn(double val) {
        boolean result = val < this.m_min;
        LOGGER.info("ValueEvaluatorNumberMin: " + val + " < " + this.m_min + " = " + result);
        return result;
    }

    public double getMin() {
        return this.m_min;
    }

    public void setMin(double minValue) {
        this.m_min = minValue;
    }

    @Override
    public void initializeEvaluatorFromXml(Element node) {
        this.setMin(Double.parseDouble(XmlToolkit.getSetting((Element)node, (String)XML_ELEMENT_MINVALUE, (String)"0")));
    }

    @Override
    public void exportEvaluatorToXml(Element node) {
        XmlToolkit.setSetting((Element)node, (String)XML_ELEMENT_MINVALUE, (String)Double.toString(this.getMin()));
    }

    public String toString() {
        return "value < " + (float)this.m_min;
    }

    @Override
    public String getOperatorString() {
        return "<";
    }

    @Override
    public String getEvaluationConditionString() {
        return "< " + (float)this.m_min;
    }
}

