/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.util.internal;

import com.jrockit.mc.rjmx.services.IAttribute;
import com.jrockit.mc.rjmx.services.IAttributeInfo;
import com.jrockit.mc.rjmx.services.IReadOnlyAttribute;
import com.jrockit.mc.rjmx.util.internal.AbstractAttributeChild;
import com.jrockit.mc.rjmx.util.internal.AbstractReadOnlyAttribute;
import com.jrockit.mc.rjmx.util.internal.SimpleAttributeInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;

abstract class AbstractAttribute
extends AbstractReadOnlyAttribute
implements IAttribute {
    public AbstractAttribute(IAttributeInfo info) {
        super(info);
    }

    @Override
    IReadOnlyAttribute createCompositeDataChild(String name, String type) {
        return new AbstractAttributeChild(this, new SimpleAttributeInfo(name, type)){

            @Override
            public Object getValue() {
                return ((CompositeData)AbstractAttribute.this.getValue()).get(this.getInfo().getName());
            }

            @Override
            public void setValue(Object newValue) {
                CompositeData parentData = (CompositeData)AbstractAttribute.this.getValue();
                CompositeType parentType = parentData.getCompositeType();
                String[] parentKeys = parentType.keySet().toArray(new String[parentType.keySet().size()]);
                Object[] parentValuesCopy = parentData.getAll(parentKeys);
                String name = this.getInfo().getName();
                int i = 0;
                while (i < parentKeys.length) {
                    if (parentKeys[i].equals(name)) {
                        parentValuesCopy[i] = newValue;
                    }
                    ++i;
                }
                try {
                    AbstractAttribute.this.setValue(new CompositeDataSupport(parentData.getCompositeType(), parentKeys, parentValuesCopy));
                }
                catch (OpenDataException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        };
    }
}

