/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.util.internal;

import com.jrockit.mc.common.IParent;
import com.jrockit.mc.rjmx.services.IAttributeInfo;
import com.jrockit.mc.rjmx.services.IReadOnlyAttribute;
import com.jrockit.mc.rjmx.util.internal.ArrayAttributeChild;
import com.jrockit.mc.rjmx.util.internal.CollectionAttributeChild;
import com.jrockit.mc.rjmx.util.internal.ListAttributeChild;
import com.jrockit.mc.rjmx.util.internal.MapAttributeChild;
import com.jrockit.mc.rjmx.util.internal.PartitionedList;
import com.jrockit.mc.rjmx.util.internal.SimpleAttributeInfo;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;

abstract class AbstractReadOnlyAttribute
implements IReadOnlyAttribute,
IParent<Object> {
    private IAttributeInfo info;

    public AbstractReadOnlyAttribute(IAttributeInfo info) {
        this.info = info;
    }

    public boolean hasChildren() {
        return this.getChildren().size() > 0;
    }

    public Collection<?> getChildren() {
        Object value = this.getValue();
        if (value == null) {
            return Collections.emptyList();
        }
        if (value.getClass().isArray()) {
            return this.getChildren(Array.getLength(value), value.getClass().getComponentType().getName());
        }
        if (value instanceof CompositeData) {
            return this.getChildren((CompositeData)value);
        }
        if (value instanceof TabularData) {
            return this.getChildren(((TabularData)value).values());
        }
        if (value instanceof Collection) {
            return this.getChildren((Collection)value);
        }
        if (value instanceof Map) {
            return this.getChildren((Map)value);
        }
        if (value instanceof IParent) {
            return ((IParent)value).getChildren();
        }
        return Collections.emptyList();
    }

    private List<?> getChildren(int arrayLength, String arrayComponentType) {
        ArrayList<ArrayAttributeChild> childs = new ArrayList<ArrayAttributeChild>(arrayLength);
        int i = 0;
        while (i < arrayLength) {
            childs.add(new ArrayAttributeChild(this, arrayComponentType, i));
            ++i;
        }
        return PartitionedList.create(childs);
    }

    private List<?> getChildren(CompositeData data) {
        CompositeType type = data.getCompositeType();
        ArrayList<IReadOnlyAttribute> childs = new ArrayList<IReadOnlyAttribute>(type.keySet().size());
        for (String childName : type.keySet()) {
            childs.add(this.createCompositeDataChild(childName, type.getType(childName).getClassName()));
        }
        return childs;
    }

    private List<?> getChildren(Map<?, ?> map) {
        ArrayList<MapAttributeChild> childs = new ArrayList<MapAttributeChild>(map.keySet().size());
        for (Object childName : map.keySet()) {
            childs.add(new MapAttributeChild((IReadOnlyAttribute)this, childName.toString()));
        }
        return childs;
    }

    private List<?> getChildren(Collection<?> data) {
        if (data instanceof List) {
            return this.getChildren((List)data);
        }
        int i = 0;
        ArrayList<CollectionAttributeChild> childs = new ArrayList<CollectionAttributeChild>();
        for (Object v : data) {
            childs.add(new CollectionAttributeChild(v, i++));
        }
        return PartitionedList.create(childs);
    }

    private List<?> getChildren(List<?> list) {
        ArrayList<ListAttributeChild> childs = new ArrayList<ListAttributeChild>();
        int i = 0;
        while (i < list.size()) {
            childs.add(new ListAttributeChild((IReadOnlyAttribute)this, i));
            ++i;
        }
        return PartitionedList.create(childs);
    }

    IReadOnlyAttribute createCompositeDataChild(String name, String type) {
        return new AbstractReadOnlyAttribute(new SimpleAttributeInfo(name, type)){

            @Override
            public Object getValue() {
                return ((CompositeData)AbstractReadOnlyAttribute.this.getValue()).get(this.getInfo().getName());
            }
        };
    }

    @Override
    public IAttributeInfo getInfo() {
        return this.info;
    }

    public int hashCode() {
        return this.getInfo().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IReadOnlyAttribute)) {
            return false;
        }
        IReadOnlyAttribute other = (IReadOnlyAttribute)obj;
        return other.getInfo().equals(this.getInfo()) && this.equalValues(this.getValue(), other.getValue());
    }

    private boolean equalValues(Object thisValue, Object thatValue) {
        if (thisValue == null) {
            return thatValue == null;
        }
        return thisValue.equals(thatValue);
    }
}

