/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.util.internal;

import com.jrockit.mc.common.IParent;
import java.util.ArrayList;
import java.util.List;

public class PartitionedList
implements IParent<Object>,
Comparable<PartitionedList> {
    private static final int MAX_CHILD_COUNT = 10;
    private final int firstObjectIndex;
    private final int lastObjectIndex;
    private final List<?> list;
    private final int fromIndex;
    private final int toIndex;

    private PartitionedList(int firstObjectIndex, int lastObjectIndex, List<?> list, int fromIndex, int toIndex) {
        this.firstObjectIndex = firstObjectIndex;
        this.lastObjectIndex = lastObjectIndex;
        this.list = list;
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
    }

    public boolean hasChildren() {
        return true;
    }

    public List<?> getChildren() {
        return this.list.subList(this.fromIndex, this.toIndex);
    }

    public String toString() {
        return "[" + this.firstObjectIndex + "..." + this.lastObjectIndex + ']';
    }

    @Override
    public int compareTo(PartitionedList o) {
        return this.fromIndex - o.fromIndex;
    }

    public static List<?> create(List<?> list) {
        return PartitionedList.create(list, 1, list.size());
    }

    static List<?> create(List<?> list, int levelMultiplier, int totalObjects) {
        int size = list.size();
        if (size > 10) {
            int partitionCount = (int)Math.ceil((double)size / 10.0);
            ArrayList<PartitionedList> partitions = new ArrayList<PartitionedList>(partitionCount);
            int i = 0;
            while (i < partitionCount) {
                int fromIndex = i * 10;
                int toIndex = Math.min((i + 1) * 10, size);
                int firstObjectIndex = levelMultiplier * fromIndex;
                int lastObjectIndex = Math.min(totalObjects, levelMultiplier * toIndex) - 1;
                partitions.add(new PartitionedList(firstObjectIndex, lastObjectIndex, list, fromIndex, toIndex));
                ++i;
            }
            return PartitionedList.create(partitions, levelMultiplier * 10, totalObjects);
        }
        return list;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.firstObjectIndex;
        result = 31 * result + this.fromIndex;
        result = 31 * result + this.lastObjectIndex;
        result = 31 * result + (this.list == null ? 0 : this.list.hashCode());
        result = 31 * result + this.toIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionedList other = (PartitionedList)obj;
        if (this.firstObjectIndex != other.firstObjectIndex) {
            return false;
        }
        if (this.fromIndex != other.fromIndex) {
            return false;
        }
        if (this.lastObjectIndex != other.lastObjectIndex) {
            return false;
        }
        if (this.list == null ? other.list != null : !this.list.equals(other.list)) {
            return false;
        }
        return this.toIndex == other.toIndex;
    }
}

