/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application;

import com.jrockit.mc.common.environment.OS;
import com.jrockit.mc.rcp.application.Messages;
import com.jrockit.mc.rcp.application.actions.OpenFileAction;
import com.jrockit.mc.rcp.application.scripting.ShellViewCoommand;
import com.jrockit.mc.ui.handlers.ExternalUrlAction;
import com.jrockit.mc.ui.handlers.Toolkit;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.services.IServiceLocator;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    private static final String FORUM_URL = "https://forums.oracle.com/forums/forum.jspa?forumID=1419";
    private static final String OTN_URL = "http://www.oracle.com/missioncontrol";
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction preferenceAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction closeAction;
    private ActionFactory.IWorkbenchAction closeAllAction;
    private ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAsAction;
    private ActionFactory.IWorkbenchAction introAction;
    private static OpenFileAction openAction;

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.saveAction = ActionFactory.SAVE.create(window);
        this.saveAsAction = ActionFactory.SAVE_AS.create(window);
        this.closeAction = ActionFactory.CLOSE.create(window);
        this.register((IAction)this.closeAction);
        this.closeAllAction = ActionFactory.CLOSE_ALL.create(window);
        this.register((IAction)this.closeAction);
        if (OS.getType() != OS.Type.MAC) {
            this.preferenceAction = ActionFactory.PREFERENCES.create(window);
            this.register((IAction)this.preferenceAction);
        }
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.register((IAction)this.aboutAction);
        this.exitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.exitAction);
        if (Platform.getProduct() != null) {
            this.introAction = ActionFactory.INTRO.create(window);
            this.register((IAction)this.introAction);
        }
        this.register((IAction)new ShellViewCoommand());
    }

    private void createDebug(IMenuManager manager) {
        MenuManager menu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_DEBUG_TEXT, "mcdebug");
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.setVisible(Boolean.getBoolean("com.jrockit.mc.debug"));
        manager.add((IContributionItem)menu);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        IWorkbenchWindow window = this.getActionBarConfigurer().getWindowConfigurer().getWindow();
        menuBar.add((IContributionItem)this.createFileMenu(window));
        menuBar.add((IContributionItem)this.createEditMenu(window));
        MenuManager navigateMenu = new MenuManager("&Navigate", "navigate");
        menuBar.add((IContributionItem)navigateMenu);
        navigateMenu.setVisible(false);
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)this.createWindowMenu(window));
        menuBar.add((IContributionItem)this.createHelpMenu(window));
    }

    private MenuManager createHelpMenu(IWorkbenchWindow window) {
        MenuManager helpMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_HELP_TEXT, "help");
        if (this.introAction != null) {
            helpMenu.add((IAction)this.introAction);
            helpMenu.add((IContributionItem)new Separator());
        }
        helpMenu.add((IContributionItem)new GroupMarker("helpStart"));
        helpMenu.add((IContributionItem)new GroupMarker("helpEnd"));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)new ExternalUrlAction(OTN_URL, Messages.ApplicationActionBarAdvisor_MENU_ITEM_OTN_TEXT));
        helpMenu.add((IAction)new ExternalUrlAction(FORUM_URL, Messages.ApplicationActionBarAdvisor_MENU_ITEM_FORUM_TEXT));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IContributionItem)new GroupMarker("additions"));
        helpMenu.add((IContributionItem)new Separator());
        helpMenu.add((IAction)this.aboutAction);
        return helpMenu;
    }

    private MenuManager createWindowMenu(IWorkbenchWindow window) {
        MenuManager windowMenu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_WINDOW_TEXT, "window");
        windowMenu.add((IContributionItem)new GroupMarker("additions"));
        windowMenu.add((IContributionItem)new GroupMarker("mcadditions"));
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IContributionItem)this.createViewMenu(window));
        windowMenu.add(this.createPerspectiveMenu(window));
        windowMenu.add((IContributionItem)new Separator());
        windowMenu.add((IAction)ActionFactory.RESET_PERSPECTIVE.create(window));
        if (OS.getType() != OS.Type.MAC) {
            windowMenu.add((IContributionItem)new Separator());
            windowMenu.add((IAction)this.preferenceAction);
        }
        return windowMenu;
    }

    private MenuManager createEditMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_EDIT_TEXT, "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add(Toolkit.createPushItem((IServiceLocator)window, (ActionFactory)ActionFactory.CUT));
        menu.add(Toolkit.createPushItem((IServiceLocator)window, (ActionFactory)ActionFactory.COPY));
        menu.add(Toolkit.createPushItem((IServiceLocator)window, (ActionFactory)ActionFactory.PASTE));
        menu.add((IContributionItem)new Separator());
        menu.add(Toolkit.createPushItem((IServiceLocator)window, (ActionFactory)ActionFactory.DELETE));
        menu.add(Toolkit.createPushItem((IServiceLocator)window, (ActionFactory)ActionFactory.SELECT_ALL));
        menu.add((IContributionItem)new GroupMarker("editStart"));
        return menu;
    }

    private IContributionItem createPerspectiveMenu(IWorkbenchWindow window) {
        MenuManager perspectiveMenuMgr = new MenuManager(Messages.ApplicationActionBarAdvisor_SHOW_PERSPECTIVE_MENU_TEXT, "showPerspective");
        IContributionItem perspectiveMenu = ContributionItemFactory.PERSPECTIVES_SHORTLIST.create(window);
        perspectiveMenuMgr.add(perspectiveMenu);
        return perspectiveMenuMgr;
    }

    private MenuManager createViewMenu(IWorkbenchWindow window) {
        MenuManager showViewMenuMgr = new MenuManager(Messages.ApplicationActionBarAdvisor_SHOW_VIEW_MENU_TEXT, "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        showViewMenuMgr.add(showViewMenu);
        return showViewMenuMgr;
    }

    private MenuManager createFileMenu(IWorkbenchWindow window) {
        MenuManager menu = new MenuManager(Messages.ApplicationActionBarAdvisor_MENU_FILE_TEXT, "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        String newText = Messages.ApplicationActionBarAdvisor_MENU_NEW_TEXT;
        String newId = ActionFactory.NEW.getId();
        MenuManager newMenu = new MenuManager(newText, newId);
        newMenu.add((IContributionItem)new Separator(newId));
        newMenu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)newMenu);
        menu.add((IAction)ApplicationActionBarAdvisor.getFileOpenAction(window));
        menu.add((IAction)this.saveAction);
        menu.add((IAction)this.saveAsAction);
        this.createDebug((IMenuManager)menu);
        menu.add((IContributionItem)new GroupMarker("new.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.closeAction);
        menu.add((IAction)this.closeAllAction);
        menu.add((IContributionItem)new GroupMarker("close.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)ActionFactory.EXPORT.create(window));
        menu.add((IAction)ActionFactory.IMPORT.create(window));
        menu.add((IContributionItem)new GroupMarker("import.ext"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add(ContributionItemFactory.REOPEN_EDITORS.create(window));
        menu.add((IContributionItem)new GroupMarker("mru"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(ActionFactory.QUIT.getId()));
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    public static synchronized OpenFileAction getFileOpenAction(IWorkbenchWindow window) {
        if (openAction == null) {
            openAction = new OpenFileAction();
            openAction.setActionDefinitionId("com.jrockit.mc.rcp.application.file.open");
            openAction.init(window);
        }
        return openAction;
    }
}

