/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application;

import com.jrockit.mc.rcp.application.actions.Messages;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.idesupport.OpenHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenDocumentEventProcessor
implements Listener {
    private static final Logger LOGGER = UIPlugin.getDefault().getLogger();
    private ArrayList<String> filesToOpen = new ArrayList(1);

    public synchronized void handleEvent(Event event) {
        if (event.type == 46 && event.text != null) {
            this.filesToOpen.add(event.text);
        }
    }

    public synchronized void openFiles() {
        if (this.filesToOpen.isEmpty()) {
            return;
        }
        String[] filePaths = this.filesToOpen.toArray(new String[this.filesToOpen.size()]);
        this.filesToOpen.clear();
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            this.openFilename(path);
            ++n2;
        }
    }

    public void openFilename(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            IWorkbenchWindow window = UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            if (window != null) {
                OpenHandler command = UIPlugin.getDefault().getFiletypeManager().getFileOpener(file.getName());
                if (command != null) {
                    command.open(window, (Object)file);
                } else {
                    String msg = NLS.bind((String)Messages.OpenFileAction_FILEFORMAT_NOT_SUPPORTED_TEXT, (Object)file.getAbsolutePath());
                    MessageDialog.openError((Shell)window.getShell(), (String)Messages.OpenFileAction_ERROR_WHEN_OPENING_FILE_TEXT_TITLE, (String)msg);
                }
            } else {
                LOGGER.log(Level.WARNING, "No workbench window found when trying to open file " + file.getAbsolutePath());
            }
        }
    }
}

