/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.logging;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.ui.UIPlugin;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;

public final class LoggingToolkit {
    private static final String KEY_FILE_HANDLER_PATTERN = "java.util.logging.FileHandler.pattern";
    private static final Logger LOGGER = Logger.getLogger("com.jrockit.mc.rcp.application");

    private LoggingToolkit() {
        throw new AssertionError((Object)"Toolkit!");
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    public static void initializeLogging() {
        String file = System.getProperty("java.util.logging.config.file");
        if (file == null || "".equals(file)) {
            file = UIPlugin.getDefault().getPreferenceStore().getString("loggingSettingsFile");
        }
        if (Boolean.getBoolean("com.jrockit.mc.debug")) {
            try {
                LoggingToolkit.readConfiguration(LoggingToolkit.class.getClassLoader().getResourceAsStream("logging_debug.properties"));
                LoggingToolkit.getLogger().log(Level.INFO, "Debug settings enabled - loaded debug settings for the logger from logging_debug.properties.");
            }
            catch (Exception e) {
                LoggingToolkit.getLogger().log(Level.WARNING, "Could not initialize debug logger", e);
                System.err.println("WARNING: Could not initialize debug logger");
                e.printStackTrace();
            }
        } else if (file == null || file.trim().equals("")) {
            try {
                LoggingToolkit.readConfiguration(LoggingToolkit.class.getClassLoader().getResourceAsStream("logging.properties"));
            }
            catch (Exception e) {
                LoggingToolkit.getLogger().log(Level.WARNING, "Could not initialize default logger", e);
                System.err.println("WARNING: Could not initialize default logger");
                e.printStackTrace();
            }
        } else {
            try {
                if (new File(file).exists()) {
                    LoggingToolkit.readConfiguration(new FileInputStream(file));
                    LoggingToolkit.getLogger().log(Level.INFO, "Loaded user specified logging settings from " + file + ".");
                } else {
                    LoggingToolkit.getLogger().log(Level.WARNING, "Could not find user specified logging settings at " + file + ".");
                }
            }
            catch (Exception e) {
                LoggingToolkit.getLogger().log(Level.WARNING, "Could not initialize user logger", e);
                System.err.println("WARNING: Could not initialize user logger");
                e.printStackTrace();
            }
        }
        LoggingToolkit.getLogger().log(Level.FINE, "Logger initialized");
        System.out.flush();
    }

    private static void readConfiguration(InputStream resourceAsStream) throws SecurityException, IOException {
        Properties props = new Properties();
        InputStream is = null;
        try {
            props.load(resourceAsStream);
            LoggingToolkit.resolveProperties(props);
            LoggingToolkit.createFolders(props);
            is = LoggingToolkit.getAsInputStream(props);
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (Throwable throwable) {
            IOToolkit.closeSilently((Closeable)resourceAsStream);
            IOToolkit.closeSilently(is);
            throw throwable;
        }
        IOToolkit.closeSilently((Closeable)resourceAsStream);
        IOToolkit.closeSilently((Closeable)is);
    }

    private static InputStream getAsInputStream(Properties props) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            props.store(baos, "");
            String newProps = baos.toString();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(newProps.getBytes("UTF-8"));
            return byteArrayInputStream;
        }
        finally {
            IOToolkit.closeSilently((Closeable)baos);
        }
    }

    private static void createFolders(Properties props) {
        String loggingFolder = props.getProperty(KEY_FILE_HANDLER_PATTERN);
        if (loggingFolder == null) {
            return;
        }
        String parentStr = new File(loggingFolder).getParent();
        if (parentStr.contains("%")) {
            return;
        }
        new File(parentStr).mkdirs();
    }

    private static void resolveProperties(Properties props) {
        props.setProperty(KEY_FILE_HANDLER_PATTERN, LoggingToolkit.resolvePath(props.getProperty(KEY_FILE_HANDLER_PATTERN)));
    }

    private static String resolvePath(String t) {
        String newStr = t;
        if (newStr.contains("%t")) {
            String tmpDir = System.getProperty("java.io.tmpdir");
            if (tmpDir == null) {
                tmpDir = System.getProperty("user.home");
            }
            newStr = newStr.replace("%t", System.getProperty("java.io.tmpdir"));
        }
        if (newStr.contains("%h")) {
            newStr = newStr.replace("%h", System.getProperty("user.home"));
        }
        if (newStr.contains("%w")) {
            String location = Platform.getInstanceLocation().getURL().getFile();
            if (location.charAt(location.length() - 1) == '/') {
                location = location.substring(0, location.length() - 1);
            }
            newStr = newStr.replace("%w", location);
        }
        return newStr;
    }
}

