/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.IdeSnapshot;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.TracerView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class IdeSnapshotAction
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final File file = IdeSnapshotAction.this.snapshotFile();
                if (file == null) {
                    return;
                }
                TracerSupportImpl.getInstance().perform(new Runnable(){

                    @Override
                    public void run() {
                        IdeSnapshot ideSnapshot = IdeSnapshotAction.this.snapshot(file);
                        if (ideSnapshot == null) {
                            return;
                        }
                        IdeSnapshotAction.openSnapshot(ideSnapshot);
                    }
                });
            }
        });
    }

    static void openSnapshot(final IdeSnapshot ideSnapshot) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TracerModel tracerModel = new TracerModel(ideSnapshot);
                TracerController tracerController = new TracerController(tracerModel);
                TopComponent topComponent = IdeSnapshotAction.ui(tracerModel, tracerController, ideSnapshot.getNpssFileName());
                topComponent.open();
                topComponent.requestActive();
            }
        });
    }

    private static TopComponent ui(TracerModel tracerModel, TracerController tracerController, String string) {
        IdeSnapshotComponent ideSnapshotComponent = new IdeSnapshotComponent(string);
        TracerView tracerView = new TracerView(tracerModel, tracerController);
        ideSnapshotComponent.add(tracerView.createComponent(), "Center");
        return ideSnapshotComponent;
    }

    private IdeSnapshot snapshot(File file) {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            FileObject fileObject2 = fileObject.getParent().getFileObject(fileObject.getName(), "log");
            return new IdeSnapshot(fileObject, fileObject2);
        }
        catch (Throwable throwable) {
            ProfilerDialogs.displayError((String)Bundle.MSG_SnapshotLoadFailedMsg(file.getName()));
            return null;
        }
    }

    private File snapshotFile() {
        Frame frame;
        JFileChooser jFileChooser = IdeSnapshotAction.createFileChooser();
        if (jFileChooser.showOpenDialog(frame = WindowManager.getDefault().getMainWindow()) == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }

    private static JFileChooser createFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(Bundle.ACTION_IdeSnapshot_dialog());
        jFileChooser.setDialogType(0);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(Filter.create(Bundle.ACTION_IdeSnapshot_filter(), ".npss"));
        return jFileChooser;
    }

    private static abstract class Filter
    extends FileFilter {
        abstract String getExt();

        static Filter create(final String string, final String string2) {
            return new Filter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || Filter.getFileExt(file.getName()).equals(string2);
                }

                @Override
                public String getExt() {
                    return string2;
                }

                @Override
                public String getDescription() {
                    return string + " (*" + string2 + ")";
                }
            };
        }

        private static String getFileExt(String string) {
            int n = string.lastIndexOf(46);
            if (n == -1) {
                return "";
            }
            return string.substring(n);
        }

        private Filter() {
        }
    }

    private static class IdeSnapshotComponent
    extends ProfilerTopComponent {
        IdeSnapshotComponent(String string) {
            this.setDisplayName(string);
            this.setLayout(new BorderLayout());
        }

        public int getPersistenceType() {
            return 2;
        }
    }
}

