/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.cpu.CCTDisplay;
import org.netbeans.modules.profiler.CPUSnapshotPanel;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.TimelineView;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.openide.util.Exceptions;

final class TracerView {
    private static List<WeakReference<TracerView>> views = new ArrayList<WeakReference<TracerView>>();
    private final TracerModel model;
    private final TracerController controller;
    private LoadedSnapshot lsF;
    private TimelineView timelineView;
    private FindMethodAction findMethod;

    TracerView(TracerModel tracerModel, TracerController tracerController) {
        this.model = tracerModel;
        this.controller = tracerController;
        this.findMethod = new FindMethodAction();
    }

    protected JComponent createComponent() {
        final JPanel jPanel = new JPanel(new BorderLayout());
        this.timelineView = new TimelineView(this.model);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.timelineView.getView(), "Center");
        jPanel2.add((Component)new JSeparator(), "South");
        final JPanel jPanel3 = new JPanel(null){

            @Override
            public void doLayout() {
                Component[] componentArray;
                for (Component component : componentArray = this.getComponents()) {
                    component.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return this.getComponent(this.getComponentCount() - 1).getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getComponent(this.getComponentCount() - 1).getMinimumSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getComponent(this.getComponentCount() - 1).getMaximumSize();
            }

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        JPanel jPanel4 = new JPanel(null);
        jPanel4.setOpaque(false);
        jPanel4.setCursor(Cursor.getPredefinedCursor(3));
        jPanel4.addMouseListener(new MouseAdapter(){});
        jPanel4.addMouseMotionListener(new MouseMotionAdapter(){});
        jPanel4.addKeyListener(new KeyAdapter(){});
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel2);
        jPanel.add((Component)jPanel3, "North");
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                TracerView.this.initProbes();
                TracerView.this.initTimeline();
                TracerView.this.initData(jPanel, jPanel3);
                TracerView.this.initListeners(jPanel);
            }
        });
        return jPanel;
    }

    private void initProbes() {
        List<TracerPackage> list = TracerSupportImpl.getInstance().getPackages(this.model.getSnapshot());
        for (TracerPackage tracerPackage : list) {
            this.model.addDescriptors(tracerPackage, tracerPackage.getProbeDescriptors());
        }
    }

    private void initTimeline() {
        TimelineSupport timelineSupport = this.model.getTimelineSupport();
        long l = this.model.firstTimestamp();
        if (l == -1L) {
            return;
        }
        long l2 = this.model.lastTimestamp();
        if (l2 == -1L) {
            return;
        }
        timelineSupport.dataLoadingStarted(l2 - l);
    }

    private void initData(final JPanel jPanel, final JPanel jPanel2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JLabel jLabel = new JLabel(Bundle.MSG_LoadingSnapshot(), 0);
                jLabel.setCursor(Cursor.getPredefinedCursor(3));
                TracerView.addContents(jPanel, jLabel);
                TracerSupportImpl.getInstance().perform(new Runnable(){

                    @Override
                    public void run() {
                        TracerView.this.controller.performSession();
                        TracerView.this.controller.performAfterSession(new Runnable(){

                            @Override
                            public void run() {
                                TimelineSupport timelineSupport = TracerView.this.model.getTimelineSupport();
                                timelineSupport.dataLoadingFinished();
                                timelineSupport.selectAll();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        TracerView.this.timelineView.updateActions();
                                    }
                                });
                                jPanel.remove(jPanel2);
                                jPanel.add(jPanel2.getComponent(1), "North");
                                jPanel.revalidate();
                                jPanel.repaint();
                            }
                        });
                    }
                });
            }
        });
    }

    private void initListeners(final JPanel jPanel) {
        final TimelineSupport timelineSupport = this.model.getTimelineSupport();
        timelineSupport.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void intervalsSelectionChanged() {
            }

            @Override
            public void indexSelectionChanged() {
                final int n = Math.min(timelineSupport.getStartIndex(), timelineSupport.getEndIndex());
                final int n2 = Math.max(timelineSupport.getStartIndex(), timelineSupport.getEndIndex());
                JLabel jLabel = new JLabel(Bundle.MSG_ProcessingSelection(), 0);
                TracerView.addContents(jPanel, jLabel);
                TracerView.this.controller.performAfterSession(new Runnable(){

                    @Override
                    public void run() {
                        if (n == n2) {
                            TracerView.this.displayThreadDump(jPanel, n);
                        } else {
                            TracerView.this.displaySnapshot(jPanel, n, n2);
                        }
                    }
                });
            }

            @Override
            public void timeSelectionChanged(boolean bl, boolean bl2) {
            }
        });
    }

    private void displaySnapshot(final JPanel jPanel, int n, int n2) {
        LoadedSnapshot loadedSnapshot = null;
        try {
            loadedSnapshot = this.model.getSnapshot().getCPUSnapshot(n, n2);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        this.lsF = loadedSnapshot;
        if (this.lsF != null) {
            TracerView.register(this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SnapshotResultsWindow snapshotResultsWindow = new SnapshotResultsWindow(TracerView.this.lsF, 1, false);
                    TracerView.addContents(jPanel, (JComponent)snapshotResultsWindow);
                }
            });
        }
    }

    private void displayThreadDump(final JPanel jPanel, int n) {
        String string = null;
        try {
            string = this.model.getSnapshot().getThreadDump(n);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        final String string2 = string;
        if (string2 != null) {
            this.lsF = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HTMLTextArea hTMLTextArea = new HTMLTextArea(string2){

                        protected void showURL(URL uRL) {
                            if (uRL == null) {
                                return;
                            }
                            String string = uRL.toString();
                            TracerView.this.showURL(string);
                        }
                    };
                    hTMLTextArea.setCaretPosition(0);
                    JScrollPane jScrollPane = new JScrollPane((Component)hTMLTextArea);
                    jScrollPane.setBorder(BorderFactory.createEmptyBorder());
                    jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
                    TracerView.addContents(jPanel, jScrollPane);
                }
            });
        }
    }

    private static void addContents(JComponent jComponent, JComponent jComponent2) {
        BorderLayout borderLayout = (BorderLayout)jComponent.getLayout();
        Component component = borderLayout.getLayoutComponent("Center");
        if (component != null) {
            jComponent.remove(component);
        }
        jComponent.add((Component)jComponent2, "Center");
        jComponent.revalidate();
        jComponent.repaint();
    }

    void showURL(String string) {
        if (string.startsWith("file:/stackframe/")) {
            string = string.substring("file:/stackframe/".length());
            String[] stringArray = string.split("\\|");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            int n = Integer.parseInt(stringArray[2]);
            GoToSource.openSource(null, (String)string2, (String)string3, (int)n);
        }
    }

    private static void register(TracerView tracerView) {
        views.add(new WeakReference<TracerView>(tracerView));
    }

    private static TracerView getTracerView(LoadedSnapshot loadedSnapshot) {
        Iterator<WeakReference<TracerView>> iterator = views.iterator();
        while (iterator.hasNext()) {
            TracerView tracerView = (TracerView)iterator.next().get();
            if (tracerView == null) {
                iterator.remove();
                continue;
            }
            if (tracerView.lsF != loadedSnapshot) continue;
            return tracerView;
        }
        return null;
    }

    private class FindMethodAction
    extends AbstractAction {
        private CCTDisplay cctDisplay;
        private PrestimeCPUCCTNode node;

        private FindMethodAction() {
            super(Bundle.LBL_FindMethod());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            assert (this.cctDisplay != null);
            try {
                List<Integer> list = TracerView.this.model.getIntervals(this.node);
                assert (list.size() % 2 == 0);
                System.out.println("Intervals " + list.toString());
                TimelineSupport timelineSupport = TracerView.this.model.getTimelineSupport();
                timelineSupport.resetSelectedIntervals();
                Iterator<Integer> iterator = list.iterator();
                while (iterator.hasNext()) {
                    int n = iterator.next();
                    int n2 = iterator.next();
                    timelineSupport.selectInterval(n, n2);
                }
                timelineSupport.selectedIntervalsChanged();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }

        private void enhancePopup(JPopupMenu jPopupMenu, CCTDisplay cCTDisplay) {
            jPopupMenu.add(new JPopupMenu.Separator());
            jPopupMenu.add(new JMenuItem(TracerView.this.findMethod));
            this.cctDisplay = cCTDisplay;
        }

        private boolean isRegular(PrestimeCPUCCTNode prestimeCPUCCTNode) {
            return prestimeCPUCCTNode.getThreadId() != -1 && prestimeCPUCCTNode.getMethodId() > 0 && !prestimeCPUCCTNode.isFilteredNode();
        }

        private void enableDisablePopup(PrestimeCPUCCTNode prestimeCPUCCTNode) {
            this.node = prestimeCPUCCTNode;
            this.setEnabled(this.isRegular(this.node));
        }
    }

    public static final class CCTEnhancer
    implements CPUSnapshotPanel.CCTPopupEnhancer {
        public void enhancePopup(JPopupMenu jPopupMenu, LoadedSnapshot loadedSnapshot, CCTDisplay cCTDisplay) {
            TracerView tracerView = TracerView.getTracerView(loadedSnapshot);
            if (tracerView != null) {
                tracerView.findMethod.enhancePopup(jPopupMenu, cCTDisplay);
            }
        }

        public void enableDisablePopup(LoadedSnapshot loadedSnapshot, PrestimeCPUCCTNode prestimeCPUCCTNode) {
            TracerView tracerView = TracerView.getTracerView(loadedSnapshot);
            if (tracerView != null) {
                tracerView.findMethod.enableDisablePopup(prestimeCPUCCTNode);
            }
        }
    }
}

