/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.export;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.netbeans.modules.options.export.ExportConfirmationPanel;
import org.netbeans.modules.options.export.ImportConfirmationPanel;
import org.netbeans.modules.options.export.OptionsExportModel;
import org.netbeans.swing.outline.CheckRenderDataProvider;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class OptionsChooserPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(OptionsChooserPanel.class.getName());
    private static final Icon NODE_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/options/export/defaultNode.gif", (boolean)true);
    private static final Color DISABLED_COLOR = UIManager.getColor("Label.disabledForeground");
    private DialogDescriptor dialogDescriptor;
    private PanelType panelType;
    private OptionsExportModel optionsExportModel;
    private static TreeModel treeModel;
    private static OptionsTreeDataProvider treeDataProvider;
    private JButton btnBrowse;
    private JLabel lblFile;
    private JLabel lblHint;
    private JScrollPane scrollPaneOptions;
    private JTextField txtFile;

    private OptionsChooserPanel() {
        this.initComponents();
        Mnemonics.setLocalizedText((AbstractButton)this.btnBrowse, (String)NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.btnBrowse"));
        Mnemonics.setLocalizedText((JLabel)this.lblFile, (String)NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.lblFile.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint, (String)NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.lblHint.text"));
    }

    private void setOptionsExportModel(OptionsExportModel optionsExportModel) {
        this.optionsExportModel = optionsExportModel;
    }

    private OptionsExportModel getOptionsExportModel() {
        return this.optionsExportModel;
    }

    public static void showExportDialog() {
        Object object;
        LOGGER.fine("showExportDialog");
        File file = new File(System.getProperty("netbeans.user"));
        final OptionsChooserPanel optionsChooserPanel = new OptionsChooserPanel();
        optionsChooserPanel.panelType = PanelType.EXPORT;
        optionsChooserPanel.setOptionsExportModel(new OptionsExportModel(file));
        optionsChooserPanel.loadOptions();
        optionsChooserPanel.txtFile.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                optionsChooserPanel.dialogDescriptor.setValid(optionsChooserPanel.isPanelValid());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                optionsChooserPanel.dialogDescriptor.setValid(optionsChooserPanel.isPanelValid());
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                optionsChooserPanel.dialogDescriptor.setValid(optionsChooserPanel.isPanelValid());
            }
        });
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)optionsChooserPanel, NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.export.title"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        dialogDescriptor.createNotificationLineSupport();
        dialogDescriptor.setValid(false);
        ExportConfirmationPanel exportConfirmationPanel = null;
        if (!ExportConfirmationPanel.getSkipOption()) {
            exportConfirmationPanel = new ExportConfirmationPanel();
            object = exportConfirmationPanel;
            dialogDescriptor.setButtonListener(new ActionListener((ExportConfirmationPanel)object){
                final /* synthetic */ ExportConfirmationPanel val$finalExportConfirmationPanel;
                {
                    this.val$finalExportConfirmationPanel = exportConfirmationPanel;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                        String string = NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.export.passwords.displayName");
                        Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)treeModel.getRoot()).depthFirstEnumeration();
                        while (enumeration.hasMoreElements()) {
                            TreeNode treeNode = enumeration.nextElement();
                            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode;
                            Object object = defaultMutableTreeNode.getUserObject();
                            if (!(object instanceof OptionsExportModel.Item) || !((OptionsExportModel.Item)object).getDisplayName().equals(string) || !treeDataProvider.isSelected(treeNode).booleanValue()) continue;
                            this.val$finalExportConfirmationPanel.showConfirmation();
                        }
                    }
                }
            });
        }
        optionsChooserPanel.setDialogDescriptor(dialogDescriptor);
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            if (exportConfirmationPanel != null && !exportConfirmationPanel.confirmed()) {
                LOGGER.fine("Export canceled.");
                return;
            }
            object = optionsChooserPanel.getSelectedFilePath();
            optionsChooserPanel.getOptionsExportModel().doExport(new File((String)object));
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.export.status.text"));
            LOGGER.fine("Export finished.");
        }
    }

    public static void showImportDialog() {
        LOGGER.fine("showImportDialog");
        OptionsChooserPanel optionsChooserPanel = new OptionsChooserPanel();
        optionsChooserPanel.txtFile.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)optionsChooserPanel.lblFile, (String)NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.import.lblFile.text"));
        Mnemonics.setLocalizedText((JLabel)optionsChooserPanel.lblHint, (String)NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.import.lblHint.text"));
        optionsChooserPanel.panelType = PanelType.IMPORT;
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)optionsChooserPanel, NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.import.title"), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        dialogDescriptor.createNotificationLineSupport();
        dialogDescriptor.setValid(false);
        final ImportConfirmationPanel importConfirmationPanel = new ImportConfirmationPanel();
        dialogDescriptor.setButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    importConfirmationPanel.showConfirmation();
                }
            }
        });
        optionsChooserPanel.setDialogDescriptor(dialogDescriptor);
        DialogDisplayer.getDefault().createDialog(dialogDescriptor).setVisible(true);
        if (DialogDescriptor.OK_OPTION.equals(dialogDescriptor.getValue())) {
            if (!importConfirmationPanel.confirmed()) {
                LOGGER.fine("Import canceled.");
                return;
            }
            File file = new File(System.getProperty("netbeans.user"));
            try {
                optionsChooserPanel.getOptionsExportModel().doImport(file);
            }
            catch (IOException iOException) {
                Exceptions.attachLocalizedMessage((Throwable)iOException, (String)NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.import.error"));
                LOGGER.log(Level.SEVERE, iOException.getMessage(), iOException);
                return;
            }
            LOGGER.fine("Import finished.");
            LifecycleManager.getDefault().markForRestart();
            LifecycleManager.getDefault().exit();
        }
    }

    private void loadOptions() {
        assert (SwingUtilities.isEventDispatchThread()) : "Should be called from AWT thread only.";
        JLabel jLabel = new JLabel(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.loading"));
        jLabel.setHorizontalAlignment(0);
        this.scrollPaneOptions.setViewportView(jLabel);
        Thread thread = new Thread("Export/import options loading"){

            @Override
            public void run() {
                OptionsExportModel optionsExportModel = OptionsChooserPanel.this.getOptionsExportModel();
                LOGGER.fine("Loading started: " + OptionsChooserPanel.this.getOptionsExportModel());
                final TreeModel treeModel = OptionsChooserPanel.this.createOptionsTreeModel();
                LOGGER.fine("Loading finished: " + OptionsChooserPanel.this.getOptionsExportModel());
                if (optionsExportModel == OptionsChooserPanel.this.getOptionsExportModel()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LOGGER.fine("Changing options.");
                            OptionsChooserPanel.this.scrollPaneOptions.setViewportView((Component)OptionsChooserPanel.this.getOutline(treeModel));
                            OptionsChooserPanel.this.dialogDescriptor.setValid(OptionsChooserPanel.this.isPanelValid());
                        }
                    });
                }
            }
        };
        thread.start();
    }

    private Outline getOutline(TreeModel treeModel) {
        Outline outline = new Outline();
        outline.setModel((TableModel)DefaultOutlineModel.createOutlineModel((TreeModel)treeModel, (RowModel)new OptionsRowModel(), (boolean)true, (String)NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.outline.header.tree")));
        treeDataProvider = new OptionsTreeDataProvider();
        outline.setRenderDataProvider((RenderDataProvider)treeDataProvider);
        outline.getTableHeader().setReorderingAllowed(false);
        outline.setColumnHidingAllowed(false);
        outline.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.outline.AN"));
        outline.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.outline.AD"));
        this.lblHint.setLabelFor((Component)outline);
        final Outline outline2 = outline;
        outline.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    int[] nArray;
                    for (int n : nArray = outline2.getSelectedRows()) {
                        if (n < 0) continue;
                        Object object = outline2.getValueAt(n, 0);
                        Boolean bl = treeDataProvider.isSelected(object);
                        if (bl == null) {
                            treeDataProvider.setSelected(object, Boolean.FALSE);
                            continue;
                        }
                        if (!treeDataProvider.isCheckEnabled(object)) continue;
                        treeDataProvider.setSelected(object, bl == false);
                    }
                }
            }
        });
        return outline;
    }

    private TreeModel createOptionsTreeModel() {
        LOGGER.fine("getOptionsTreeModel - " + this.getOptionsExportModel());
        String string = NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.outline.all");
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(string);
        for (OptionsExportModel.Category category : this.getOptionsExportModel().getCategories()) {
            LOGGER.fine("category=" + category);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(category);
            List<OptionsExportModel.Item> list = category.getItems();
            for (OptionsExportModel.Item item : list) {
                LOGGER.fine("    item=" + item);
                if (this.panelType != PanelType.EXPORT && !item.isApplicable()) continue;
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(item));
            }
            if (defaultMutableTreeNode2.getChildCount() == 0) continue;
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            OptionsChooserPanel.updateCategoryNode(defaultMutableTreeNode2);
        }
        if (defaultMutableTreeNode.getChildCount() == 0) {
            defaultMutableTreeNode = null;
        }
        treeModel = new DefaultTreeModel(defaultMutableTreeNode);
        return treeModel;
    }

    private String getSelectedFilePath() {
        return this.txtFile.getText();
    }

    private void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dialogDescriptor = dialogDescriptor;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isPanelValid() {
        if (this.panelType == PanelType.IMPORT) {
            if (this.txtFile.getText().length() == 0) {
                this.dialogDescriptor.getNotificationLineSupport().setWarningMessage(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.import.file.warning"));
                return false;
            }
            if (this.getOptionsExportModel().getState() == OptionsExportModel.State.DISABLED) {
                this.dialogDescriptor.getNotificationLineSupport().setWarningMessage(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.import.nooption.warning"));
                return false;
            }
            this.dialogDescriptor.getNotificationLineSupport().clearMessages();
            return true;
        }
        if (this.txtFile.getText().length() == 0 || !this.txtFile.getText().endsWith(".zip")) {
            this.dialogDescriptor.getNotificationLineSupport().setWarningMessage(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.file.warning"));
            return false;
        }
        if (this.getOptionsExportModel().getState() == OptionsExportModel.State.DISABLED) {
            this.dialogDescriptor.getNotificationLineSupport().setWarningMessage(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.nooption.warning"));
            return false;
        }
        File file = new File(this.txtFile.getText()).getParentFile();
        if (file == null) {
            this.dialogDescriptor.getNotificationLineSupport().setWarningMessage(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.noparent.warning"));
            return false;
        }
        if (file.canWrite()) {
            this.dialogDescriptor.getNotificationLineSupport().clearMessages();
            return true;
        }
        this.dialogDescriptor.getNotificationLineSupport().setWarningMessage(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.nowrite.warning"));
        return false;
    }

    private void initComponents() {
        this.lblHint = new JLabel();
        this.scrollPaneOptions = new JScrollPane();
        this.lblFile = new JLabel();
        this.txtFile = new JTextField();
        this.btnBrowse = new JButton();
        this.lblHint.setText(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.lblHint.text"));
        this.lblFile.setLabelFor(this.txtFile);
        this.lblFile.setText(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.lblFile.text"));
        this.btnBrowse.setText(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.btnBrowse"));
        this.btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OptionsChooserPanel.this.btnBrowseActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPaneOptions, -1, 406, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addComponent(this.lblFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.txtFile, -1, 163, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnBrowse)).addComponent(this.lblHint, -1, 406, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblFile).addComponent(this.txtFile, -2, -1, -2).addComponent(this.btnBrowse)).addGap(18, 18, 18).addComponent(this.lblHint).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPaneOptions, -1, 236, Short.MAX_VALUE).addContainerGap()));
        this.txtFile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.txtFile.AD"));
        this.btnBrowse.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.btnBrowse.AN"));
        this.btnBrowse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.btnBrowse.AD"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.AD"));
    }

    private void btnBrowseActionPerformed(ActionEvent actionEvent) {
        FileChooserBuilder fileChooserBuilder = new FileChooserBuilder(OptionsChooserPanel.class);
        fileChooserBuilder.setDefaultWorkingDirectory(new File(System.getProperty("user.home")));
        fileChooserBuilder.setFileFilter((FileFilter)new FileNameExtensionFilter("*.zip", "zip"));
        String string = NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.file.chooser.approve");
        fileChooserBuilder.setApproveText(string);
        if (this.panelType == PanelType.IMPORT) {
            fileChooserBuilder.setTitle(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.import.file.chooser.title"));
            File file = fileChooserBuilder.showOpenDialog();
            if (file != null) {
                if (file.isDirectory() && !new File(file, "config").exists()) {
                    String string2 = NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.import.invalid.userdir", (Object)file);
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string2, NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.import.invalid.userdir.title"), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (!NotifyDescriptor.YES_OPTION.equals(confirmation.getValue())) {
                        return;
                    }
                }
                this.txtFile.setText(file.getAbsolutePath());
                this.setOptionsExportModel(new OptionsExportModel(file));
                this.loadOptions();
            }
        } else {
            fileChooserBuilder.setTitle(NbBundle.getMessage(OptionsChooserPanel.class, (String)"OptionsChooserPanel.file.chooser.title"));
            File file = fileChooserBuilder.showSaveDialog();
            if (file != null) {
                String string3 = file.getAbsolutePath();
                if (!string3.endsWith(".zip")) {
                    string3 = string3 + ".zip";
                }
                this.txtFile.setText(string3);
                this.dialogDescriptor.setValid(this.isPanelValid());
            }
        }
    }

    private static void updateCategoryNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            object = ((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject();
            OptionsExportModel.Item item = (OptionsExportModel.Item)object;
            if (!item.isApplicable()) continue;
            ++n2;
            if (!item.isEnabled()) continue;
            ++n;
        }
        Object object2 = defaultMutableTreeNode.getUserObject();
        object = (OptionsExportModel.Category)object2;
        if (n == 0) {
            ((OptionsExportModel.Category)object).setState(OptionsExportModel.State.DISABLED);
        } else if (n == n2) {
            ((OptionsExportModel.Category)object).setState(OptionsExportModel.State.ENABLED);
        } else {
            ((OptionsExportModel.Category)object).setState(OptionsExportModel.State.PARTIAL);
        }
    }

    private static class FileNameExtensionFilter
    extends FileFilter {
        private final String description;
        private final String lowerCaseExtension;

        public FileNameExtensionFilter(String string, String string2) {
            assert (string2 != null);
            this.description = string;
            this.lowerCaseExtension = string2.toLowerCase();
        }

        @Override
        public boolean accept(File file) {
            if (file != null) {
                String string;
                if (file.isDirectory()) {
                    return true;
                }
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1 && (string = string2.substring(n + 1).toLowerCase()).equals(this.lowerCaseExtension)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private class OptionsTreeDataProvider
    implements CheckRenderDataProvider {
        private OptionsTreeDataProvider() {
        }

        public Color getBackground(Object object) {
            return null;
        }

        public String getDisplayName(Object object) {
            if (object == null) {
                return null;
            }
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof OptionsExportModel.Category) {
                return ((OptionsExportModel.Category)object2).getDisplayName();
            }
            if (object2 instanceof OptionsExportModel.Item) {
                return ((OptionsExportModel.Item)object2).getDisplayName();
            }
            return object.toString();
        }

        public Color getForeground(Object object) {
            if (object == null) {
                return null;
            }
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof OptionsExportModel.Category ? !((OptionsExportModel.Category)object2).isApplicable() : object2 instanceof OptionsExportModel.Item && !((OptionsExportModel.Item)object2).isApplicable()) {
                return DISABLED_COLOR;
            }
            return null;
        }

        public Icon getIcon(Object object) {
            return NODE_ICON;
        }

        public String getTooltipText(Object object) {
            return null;
        }

        public boolean isHtmlDisplayName(Object object) {
            return false;
        }

        public boolean isCheckable(Object object) {
            return true;
        }

        public boolean isCheckEnabled(Object object) {
            if (object == null) {
                return true;
            }
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            return !(object2 instanceof OptionsExportModel.Category ? !((OptionsExportModel.Category)object2).isApplicable() : object2 instanceof OptionsExportModel.Item && !((OptionsExportModel.Item)object2).isApplicable());
        }

        public Boolean isSelected(Object object) {
            if (object == null) {
                return false;
            }
            if (((DefaultMutableTreeNode)object).isRoot()) {
                return OptionsChooserPanel.this.getOptionsExportModel().getState().toBoolean();
            }
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof OptionsExportModel.Category) {
                return ((OptionsExportModel.Category)object2).getState().toBoolean();
            }
            if (object2 instanceof OptionsExportModel.Item) {
                return ((OptionsExportModel.Item)object2).isEnabled();
            }
            assert (false) : "Node not recognized " + object;
            return false;
        }

        public void setSelected(Object object, Boolean bl) {
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (((DefaultMutableTreeNode)object).isRoot()) {
                OptionsChooserPanel.this.getOptionsExportModel().setState(OptionsExportModel.State.valueOf(bl));
            } else if (object2 instanceof OptionsExportModel.Category) {
                ((OptionsExportModel.Category)object2).setState(OptionsExportModel.State.valueOf(bl));
            } else if (object2 instanceof OptionsExportModel.Item) {
                ((OptionsExportModel.Item)object2).setEnabled(bl);
                TreeNode treeNode = ((TreeNode)object).getParent();
                OptionsChooserPanel.updateCategoryNode((DefaultMutableTreeNode)treeNode);
            }
            ((DefaultTreeModel)treeModel).nodeChanged((TreeNode)object);
            OptionsChooserPanel.this.dialogDescriptor.setValid(OptionsChooserPanel.this.isPanelValid());
            OptionsChooserPanel.this.scrollPaneOptions.repaint();
        }
    }

    private class OptionsRowModel
    implements RowModel {
        private OptionsRowModel() {
        }

        public Class getColumnClass(int n) {
            return null;
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int n) {
            return null;
        }

        public Object getValueFor(Object object, int n) {
            return null;
        }

        public boolean isCellEditable(Object object, int n) {
            return false;
        }

        public void setValueFor(Object object, int n, Object object2) {
        }
    }

    private static enum PanelType {
        EXPORT,
        IMPORT;

    }
}

