/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.awt.Color;
import java.awt.Image;
import java.io.CharConversionException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.ColorHighlighter;
import org.netbeans.modules.autoupdate.ui.DetailsPanel;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitTable;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;

public class UnitDetails
extends DetailsPanel {
    private static final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.UnitDetails");
    private RequestProcessor.Task unitDetailsTask = null;
    static final RequestProcessor UNIT_DETAILS_PROCESSOR = new RequestProcessor("unit-details-processor", 1, true);

    public UnitDetails() {
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(UnitTable.class, (String)"ACN_UnitDetails"));
    }

    public void setUnit(Unit unit) {
        this.setUnit(unit, null);
    }

    public void setUnit(final Unit unit, Action action) {
        if (this.unitDetailsTask != null && !this.unitDetailsTask.isFinished()) {
            this.unitDetailsTask.cancel();
        }
        if (unit == null) {
            this.getDetails().setText("<i>" + UnitDetails.getBundle("UnitDetails_Category_NoDescription") + "</i>");
            this.setTitle(null);
        } else {
            try {
                this.setTitle(XMLUtil.toElementContent((String)unit.getDisplayName()));
            }
            catch (CharConversionException charConversionException) {
                err.log(Level.INFO, null, charConversionException);
                return;
            }
            this.setActionListener(action);
            this.setUnitText(unit, this.getUnitText(unit, false));
            if (unit instanceof Unit.Update) {
                this.unitDetailsTask = UNIT_DETAILS_PROCESSOR.post(new Runnable(){

                    @Override
                    public void run() {
                        final StringBuilder stringBuilder = UnitDetails.this.getUnitText(unit, true);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                UnitDetails.this.setUnitText(unit, stringBuilder);
                            }
                        });
                    }
                });
            }
        }
    }

    private void buildUnitText(Unit unit, StringBuilder stringBuilder, boolean bl) {
        Object object;
        Object object2;
        if (unit instanceof Unit.Available) {
            object2 = (Unit.Available)unit;
            object = ((Unit.Available)object2).getSourceIcon();
            Object object3 = ((Image)object).getProperty("url", null);
            String string = ((Unit.Available)object2).getSourceDescription();
            stringBuilder.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
            if (object3 instanceof URL) {
                stringBuilder.append("<td><img src=\"").append(object3).append("\"></img></td>");
            }
            stringBuilder.append("<td></td>");
            stringBuilder.append("<td>&nbsp;&nbsp;</td>");
            stringBuilder.append("<td><b>").append(string).append("</b></td>");
            stringBuilder.append("</tr></table><br>");
        }
        if (Utilities.modulesOnly() || Utilities.showExtendedDescription()) {
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_CodeName")).append("</b>").append(unit.updateUnit.getCodeName());
            stringBuilder.append("<br>");
        }
        object2 = null;
        if (unit instanceof Unit.Update) {
            object = (Unit.Update)unit;
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_InstalledVersion")).append("</b>").append(((Unit.Update)object).getInstalledVersion()).append("<br>");
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_AvailableVersion")).append("</b>").append(((Unit.Update)object).getAvailableVersion()).append("<br>");
            object2 = this.getDependencies((Unit.Update)object, bl);
        } else {
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_Version")).append("</b>").append(unit.getDisplayVersion()).append("<br>");
        }
        if (unit.getAuthor() != null && unit.getAuthor().length() > 0) {
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_Author")).append("</b>").append(unit.getAuthor()).append("<br>");
        }
        if (unit.getDisplayDate() != null && unit.getDisplayDate().length() > 0) {
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_Date")).append("</b>").append(unit.getDisplayDate()).append("<br>");
        }
        stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_Source")).append("</b>").append(unit.getSource()).append("<br>");
        if (unit.getHomepage() != null && unit.getHomepage().length() > 0) {
            stringBuilder.append("<b>").append(UnitDetails.getBundle("UnitDetails_Plugin_Homepage")).append("</b><a href=\"").append(unit.getHomepage()).append("\">").append(unit.getHomepage()).append("</a><br>");
        }
        if (unit.getNotification() != null && unit.getNotification().length() > 0) {
            stringBuilder.append("<br><h3>").append(UnitDetails.getBundle("UnitDetails_Plugin_Notification")).append("</h3>");
            stringBuilder.append("<font color=\"red\">");
            stringBuilder.append(unit.getNotification());
            stringBuilder.append("</font><br>");
        }
        if (unit.getDescription() != null && unit.getDescription().length() > 0) {
            stringBuilder.append("<br><h3>").append(UnitDetails.getBundle("UnitDetails_Plugin_Description")).append("</h3>");
            object = unit.getDescription();
            if (((String)object).toLowerCase().startsWith("<html>")) {
                stringBuilder.append(((String)object).substring(6));
            } else {
                stringBuilder.append((String)object);
            }
        }
        if (object2 != null && ((String)object2).length() > 0) {
            stringBuilder.append("<br><br><h4>").append(UnitDetails.getBundle("Unit_InternalUpdates_Title")).append("</h4>");
            stringBuilder.append((String)object2);
        }
    }

    private void setUnitText(Unit unit, StringBuilder stringBuilder) {
        this.getDetails().setText(stringBuilder.toString());
        this.setUnitHighlighing(unit);
    }

    private StringBuilder getUnitText(Unit unit, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (true) {
            try {
                this.buildUnitText(unit, stringBuilder, bl);
            }
            catch (IllegalStateException illegalStateException) {
                if (n > 100) {
                    throw illegalStateException;
                }
                Unit.log.log(Level.INFO, "Can't compute getUnitText for " + unit, illegalStateException);
                ++n;
                continue;
            }
            break;
        }
        return stringBuilder;
    }

    private void setUnitHighlighing(Unit unit) {
        Color color = Color.YELLOW;
        ColorHighlighter colorHighlighter = new ColorHighlighter(this.getDetails(), color);
        int n = colorHighlighter.highlight(unit.getFilter());
        this.getDetails().setCaretPosition(n > 0 ? n : 0);
    }

    private String getDependencies(Unit.Update update, boolean bl) {
        Object object;
        Iterator iterator;
        Object object3;
        Object object4;
        if (!bl) {
            return "<i>" + UnitDetails.getBundle("UnitDetails_Plugin_Collecting_Dependencies") + "</i><br>";
        }
        Unit.Update update2 = update;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (!(update2 instanceof Unit.InternalUpdate)) {
            Set set;
            object4 = OperationContainer.createForUpdate();
            if (!object4.canBeAdded(update2.updateUnit, update.getRelevantElement())) {
                return null;
            }
            try {
                object4.add(update2.updateUnit, update.getRelevantElement());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.attachMessage((Throwable)illegalArgumentException, (String)("Unit: " + update2));
                Exceptions.attachMessage((Throwable)illegalArgumentException, (String)("Unit.updateUnit: " + update2.updateUnit));
                Exceptions.attachMessage((Throwable)illegalArgumentException, (String)("Unit.updateUnit.getInstalled(): " + update2.updateUnit.getInstalled()));
                Exceptions.attachMessage((Throwable)illegalArgumentException, (String)("Unit.getRelevantElement(): " + update.getRelevantElement()));
                throw illegalArgumentException;
            }
            object3 = new LinkedHashSet();
            iterator = object4.listAll();
            Iterator object22 = iterator.iterator();
            while (object22.hasNext()) {
                object = (OperationContainer.OperationInfo)object22.next();
                set = object.getRequiredElements();
                for (Object object2 : set) {
                    if (object2.getUpdateUnit().getInstalled() == null || object2.getUpdateUnit().isPending()) continue;
                    object3.add(object2);
                }
            }
            Iterator iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                object = (OperationContainer.OperationInfo)iterator2.next();
                if (object.getUpdateUnit().equals((Object)update2.updateUnit) || object.getUpdateUnit().isPending()) continue;
                object3.add(object.getUpdateElement());
            }
            if (!object3.isEmpty()) {
                OperationContainer.OperationInfo operationInfo;
                Object object52;
                Object object2;
                ArrayList<Set> arrayList = new ArrayList<Set>();
                object = object3.iterator();
                while (object.hasNext()) {
                    set = (UpdateElement)object.next();
                    if (!set.getUpdateUnit().getType().equals((Object)UpdateManager.TYPE.KIT_MODULE)) continue;
                    arrayList.add(set);
                }
                object = OperationContainer.createForUpdate();
                set = OperationContainer.createForInstall();
                ArrayList arrayList2 = new ArrayList();
                for (Object object52 : arrayList) {
                    if (object.canBeAdded(object52.getUpdateUnit(), (UpdateElement)object52)) {
                        arrayList2.add(object.add((UpdateElement)object52));
                        continue;
                    }
                    if (!set.canBeAdded(object52.getUpdateUnit(), (UpdateElement)object52)) continue;
                    arrayList2.add(set.add((UpdateElement)object52));
                }
                object2 = new ArrayList();
                object52 = arrayList2.iterator();
                while (object52.hasNext()) {
                    operationInfo = (OperationContainer.OperationInfo)object52.next();
                    Set set2 = operationInfo.getRequiredElements();
                    for (UpdateElement updateElement : set2) {
                        if (object2.contains(updateElement)) continue;
                        object2.add(updateElement);
                    }
                }
                object52 = object3.iterator();
                while (object52.hasNext()) {
                    operationInfo = (UpdateElement)object52.next();
                    if (object2.contains(operationInfo) || operationInfo.getUpdateUnit().getType().equals((Object)UpdateManager.TYPE.KIT_MODULE)) continue;
                    hashSet.add(operationInfo);
                }
            }
        } else {
            object4 = (Unit.InternalUpdate)update2;
            object3 = OperationContainer.createForUpdate();
            for (UpdateUnit updateUnit : ((Unit.InternalUpdate)object4).getUpdateUnits()) {
                if (!object3.canBeAdded(updateUnit, (UpdateElement)(object = (UpdateElement)updateUnit.getAvailableUpdates().get(0)))) continue;
                object3.add(updateUnit, (UpdateElement)object);
            }
            for (OperationContainer.OperationInfo operationInfo : object3.listAll()) {
                hashSet.add(operationInfo.getUpdateElement());
                for (Set set : operationInfo.getRequiredElements()) {
                    if (set.getUpdateUnit().getInstalled() == null || set.getUpdateUnit().isPending()) continue;
                    hashSet.add(set);
                }
            }
        }
        object4 = new StringBuilder();
        try {
            object3 = new TreeSet<UpdateElement>(new Comparator<UpdateElement>(){

                @Override
                public int compare(UpdateElement updateElement, UpdateElement updateElement2) {
                    return updateElement.getDisplayName().compareTo(updateElement2.getDisplayName());
                }
            });
            object3.addAll(hashSet);
            iterator = object3.iterator();
            while (iterator.hasNext()) {
                UpdateElement updateElement = (UpdateElement)iterator.next();
                this.appendInternalUpdates((StringBuilder)object4, updateElement);
            }
        }
        catch (Exception exception) {
            err.log(Level.INFO, "Exception", exception);
        }
        return ((StringBuilder)object4).toString();
    }

    private void appendInternalUpdates(StringBuilder stringBuilder, UpdateElement updateElement) {
        stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
        stringBuilder.append(updateElement.getDisplayName());
        if (updateElement.getUpdateUnit().getInstalled() != null) {
            stringBuilder.append(" [").append(updateElement.getUpdateUnit().getInstalled().getSpecificationVersion()).append("->");
        } else {
            stringBuilder.append(" <span color=\"red\">").append(UnitDetails.getBundle("UnitDetails_New_Internal_Update_Mark")).append("</span> [");
        }
        stringBuilder.append(((UpdateElement)updateElement.getUpdateUnit().getAvailableUpdates().get(0)).getSpecificationVersion());
        stringBuilder.append("]<br>");
    }

    private static String getBundle(String string) {
        return NbBundle.getMessage(UnitDetails.class, (String)string);
    }
}

