/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.netbeans.modules.autoupdate.ui.wizards.InstallUnitWizardModel;
import org.netbeans.modules.autoupdate.ui.wizards.OperationWizardModel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class LicenseApprovalPanel
extends JPanel {
    public static final String LICENSE_APPROVED = "license-approved";
    private List<UpdateElement> license4plugins;
    private JCheckBox cbAccept;
    private JComboBox cbPlugins;
    private JLabel lbPlugins;
    private JScrollPane spLicense;
    private JTextArea taLicense;
    private JTextArea taTitle;

    public LicenseApprovalPanel(InstallUnitWizardModel installUnitWizardModel, boolean bl) {
        this.initComponents();
        this.cbAccept.setSelected(bl);
        if (installUnitWizardModel != null) {
            this.writeLicenses(installUnitWizardModel);
        } else {
            this.cbAccept.setEnabled(false);
            this.taLicense.setEnabled(false);
        }
    }

    Collection<String> getLicenses() {
        assert (this.license4plugins != null) : "Licenses must found.";
        if (this.license4plugins == null && this.license4plugins.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (UpdateElement updateElement : this.license4plugins) {
            hashSet.add(updateElement.getLicence());
        }
        return hashSet;
    }

    Collection<String> getLicenseIds() {
        assert (this.license4plugins != null) : "Licenses must found.";
        if (this.license4plugins == null && this.license4plugins.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (UpdateElement updateElement : this.license4plugins) {
            hashSet.add(updateElement.getLicenseId());
        }
        return hashSet;
    }

    private void goOverLicenses(InstallUnitWizardModel installUnitWizardModel) {
        for (UpdateElement updateElement : installUnitWizardModel.getAllUpdateElements()) {
            if (updateElement.getLicence() == null) continue;
            if (this.license4plugins == null) {
                this.license4plugins = new ArrayList<UpdateElement>();
            }
            if (OperationWizardModel.OperationType.UPDATE.equals((Object)installUnitWizardModel.getOperation()) && Utilities.isLicenseIdApproved(updateElement.getLicenseId())) continue;
            Logger.getLogger(LicenseApprovalPanel.class.getName()).fine(updateElement + "[" + updateElement.getLicenseId() + "] hasn't been accepted yet.");
            this.license4plugins.add(updateElement);
        }
    }

    public boolean isApproved() {
        return this.cbAccept.isSelected();
    }

    private void initComponents() {
        this.taTitle = new JTextArea();
        this.cbAccept = new JCheckBox();
        this.cbPlugins = new JComboBox();
        this.spLicense = new JScrollPane();
        this.taLicense = new JTextArea();
        this.lbPlugins = new JLabel();
        this.taTitle.setEditable(false);
        this.taTitle.setLineWrap(true);
        this.taTitle.setText(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taTitle_Text"));
        this.taTitle.setWrapStyleWord(true);
        this.taTitle.setMargin(new Insets(0, 4, 0, 0));
        this.taTitle.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)this.cbAccept, (String)NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel.cbAccept.text"));
        this.cbAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LicenseApprovalPanel.this.cbAcceptActionPerformed(actionEvent);
            }
        });
        this.cbPlugins.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LicenseApprovalPanel.this.cbPluginsActionPerformed(actionEvent);
            }
        });
        this.taLicense.setColumns(20);
        this.taLicense.setEditable(false);
        this.taLicense.setLineWrap(true);
        this.taLicense.setRows(5);
        this.taLicense.setWrapStyleWord(true);
        this.taLicense.setMargin(new Insets(0, 4, 0, 4));
        this.spLicense.setViewportView(this.taLicense);
        this.taLicense.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taLicenses_ACN"));
        this.taLicense.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_taLicenses_ACD"));
        this.lbPlugins.setLabelFor(this.cbPlugins);
        Mnemonics.setLocalizedText((JLabel)this.lbPlugins, (String)NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel.lbPlugins.text"));
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taTitle).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.lbPlugins).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbPlugins, 0, -1, Short.MAX_VALUE)).addComponent(this.spLicense).addComponent(this.cbAccept, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.taTitle, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cbPlugins).addComponent(this.lbPlugins, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spLicense, -1, 141, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbAccept).addContainerGap()));
        this.cbAccept.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_cbAccept_ACN"));
    }

    private void cbAcceptActionPerformed(ActionEvent actionEvent) {
        this.firePropertyChange(LICENSE_APPROVED, null, (Object)this.cbAccept.isSelected());
    }

    private void cbPluginsActionPerformed(ActionEvent actionEvent) {
        this.taLicense.setText("");
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        UpdateElement updateElement = (UpdateElement)LicenseApprovalPanel.this.license4plugins.get(LicenseApprovalPanel.this.cbPlugins.getSelectedIndex());
                        LicenseApprovalPanel.this.taLicense.setText(updateElement.getLicence());
                        LicenseApprovalPanel.this.taLicense.setCaretPosition(0);
                    }
                });
            }
        }, 100);
    }

    private void writeLicenses(InstallUnitWizardModel installUnitWizardModel) {
        this.goOverLicenses(installUnitWizardModel);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = NbBundle.getMessage(LicenseApprovalPanel.class, (String)"LicenseApprovalPanel_cbPlugins_ItemFormat");
        for (UpdateElement updateElement : this.license4plugins) {
            String string2 = MessageFormat.format(string, updateElement.getDisplayName(), updateElement.getSpecificationVersion());
            arrayList.add(string2);
        }
        this.cbPlugins.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
        this.cbPlugins.setSelectedIndex(0);
    }
}

