/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.html.StyleSheet;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.HTMLEditorKitEx;
import org.netbeans.modules.autoupdate.ui.actions.Installer;
import org.netbeans.modules.autoupdate.ui.wizards.LicenseApprovalPanel;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PanelBodyContainer
extends JPanel {
    private static boolean initHtmlKit;
    private String head = null;
    private String message = null;
    private JScrollPane customPanel;
    private JPanel bodyPanel = null;
    private JComponent progressPanel = null;
    private JComponent progress;
    private boolean isWaiting = false;
    private Timer delay;
    private ProgressHandle handle;
    private JPanel pBodyPanel;
    private JScrollPane spPanelHeader;
    private JTextPane tpPanelHeader;

    public PanelBodyContainer(String string, String string2, JPanel jPanel) {
        this.head = string;
        this.message = string2;
        this.bodyPanel = jPanel;
        this.initComponents();
        HTMLEditorKitEx hTMLEditorKitEx = new HTMLEditorKitEx();
        StyleSheet styleSheet = hTMLEditorKitEx.getStyleSheet();
        if (styleSheet.getStyleSheets() == null) {
            StyleSheet styleSheet2 = new StyleSheet();
            Font font = new JList().getFont();
            int n = font.getSize();
            styleSheet2.addRule(new StringBuffer("body { font-size: ").append(n).append("; font-family: ").append(font.getName()).append("; }").toString());
            styleSheet2.addStyleSheet(styleSheet);
            hTMLEditorKitEx.setStyleSheet(styleSheet2);
        }
        this.tpPanelHeader.setEditorKit(hTMLEditorKitEx);
        this.writeToHeader(this.head, this.message);
        this.initBodyPanel();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanelBodyContainer.this.bodyPanel.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            }
        });
        if (this.isWaiting) {
            this.setWaitingState(true);
        }
    }

    public void setBody(final JPanel jPanel) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.bodyPanel = jPanel;
            this.initBodyPanel();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.bodyPanel = jPanel;
                    PanelBodyContainer.this.initBodyPanel();
                }
            });
        }
    }

    public void setWaitingState(boolean bl) {
        this.setWaitingState(bl, 0L);
    }

    public void setWaitingState(boolean bl, final long l) {
        if (this.isWaiting == bl) {
            return;
        }
        this.isWaiting = bl;
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.addProgressLine(l);
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.removeProgressLine();
                }
            });
        }
        JRootPane jRootPane = this.getRootPane();
        if (jRootPane != null) {
            if (bl) {
                jRootPane.setCursor(Cursor.getPredefinedCursor(3));
            } else {
                jRootPane.setCursor(null);
            }
        }
    }

    private void addProgressLine(long l) {
        this.handle = ProgressHandleFactory.createHandle((String)"PanelBodyContainer_ProgressLine");
        JLabel jLabel = this.bodyPanel instanceof LicenseApprovalPanel ? new JLabel(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_PleaseWaitForLicense")) : new JLabel(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_PleaseWait"));
        this.progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)this.handle);
        this.progressPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 12, 0, 12);
        gridBagConstraints.weighty = 1.0;
        this.progressPanel.add((Component)this.progress, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 0, 0, 20);
        gridBagConstraints.weightx = 1.0;
        this.progressPanel.add((Component)jLabel, gridBagConstraints);
        this.progressPanel.setVisible(false);
        this.delay = new Timer(900, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PanelBodyContainer.this.delay.stop();
                PanelBodyContainer.this.adjustProgressWidth();
                PanelBodyContainer.this.progressPanel.setVisible(true);
                PanelBodyContainer.this.initBodyPanel();
            }
        });
        this.delay.setRepeats(false);
        this.delay.start();
        String string = NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ProgressLine");
        if (l == 0L) {
            this.handle.start();
            this.handle.progress(string);
        } else {
            assert (l > 0L) : "Estimated time " + l;
            long l2 = l + 2L;
            this.handle.start((int)l2 * 10, l2);
            this.handle.progress(string, 0);
            new UpdateProgress(l2, string).start();
        }
    }

    private void adjustProgressWidth() {
        Dimension dimension = this.progress.getMinimumSize();
        Dimension dimension2 = this.progress.getPreferredSize();
        if (dimension != null && dimension2 != null && dimension.width * 2 < dimension2.width) {
            int n = dimension2.width / 2;
            int n2 = dimension.height;
            this.progress.setMinimumSize(new Dimension(n, n2));
        }
    }

    private void initBodyPanel() {
        this.pBodyPanel.removeAll();
        this.customPanel = new JScrollPane();
        this.customPanel.setBorder(null);
        this.pBodyPanel.add((Component)this.customPanel, "Center");
        if (this.isWaiting) {
            this.pBodyPanel.add((Component)this.progressPanel, "South");
        }
        this.customPanel.setViewportView(this.bodyPanel);
        this.customPanel.getVerticalScrollBar().setUnitIncrement(10);
        this.customPanel.getHorizontalScrollBar().setUnitIncrement(10);
        this.revalidate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PanelBodyContainer.this.pBodyPanel.scrollRectToVisible(new Rectangle(0, 0, 10, 10));
            }
        });
    }

    private void removeProgressLine() {
        if (this.progressPanel != null) {
            this.pBodyPanel.remove(this.progressPanel);
            if (this.handle != null) {
                this.handle.finish();
            }
            this.revalidate();
        }
    }

    public void setHeadAndContent(final String string, final String string2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.writeToHeader(string, string2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PanelBodyContainer.this.writeToHeader(string, string2);
                }
            });
        }
    }

    private void writeToHeader(String string, String string2) {
        this.tpPanelHeader.setText(null);
        this.tpPanelHeader.setText("<br><b>" + string + "</b> <br>" + string2);
    }

    private void initComponents() {
        this.pBodyPanel = new JPanel();
        this.spPanelHeader = new JScrollPane();
        this.tpPanelHeader = new JTextPane();
        this.pBodyPanel.setLayout(new BorderLayout());
        this.tpPanelHeader.setContentType("text/html");
        this.tpPanelHeader.setEditable(false);
        this.spPanelHeader.setViewportView(this.tpPanelHeader);
        this.tpPanelHeader.getAccessibleContext().setAccessibleName(this.head);
        GroupLayout groupLayout = new GroupLayout(this);
        this.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pBodyPanel, -1, 24, Short.MAX_VALUE).addComponent(this.spPanelHeader, GroupLayout.Alignment.TRAILING, -1, 24, Short.MAX_VALUE));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.spPanelHeader, -2, 78, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pBodyPanel, -1, -1, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ACN"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelBodyContainer.class, (String)"PanelBodyContainer_ACD"));
    }

    private final class UpdateProgress
    implements Runnable {
        private final long friendlyEstimatedTime;
        private final String progressDisplayName;
        private final RequestProcessor.Task task;

        public UpdateProgress(long l, String string) {
            this.friendlyEstimatedTime = l;
            this.progressDisplayName = string;
            this.task = Installer.RP.create((Runnable)this);
        }

        @Override
        public void run() {
            int n = 0;
            if (PanelBodyContainer.this.isWaiting && PanelBodyContainer.this.isShowing()) {
                if (this.friendlyEstimatedTime * 10L <= (long)n++) {
                    PanelBodyContainer.this.handle.switchToIndeterminate();
                    PanelBodyContainer.this.handle.progress(this.progressDisplayName);
                    return;
                }
                PanelBodyContainer.this.handle.progress(this.progressDisplayName, n);
                this.task.schedule(100);
            }
        }

        final void start() {
            this.task.schedule(0);
        }
    }
}

