/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.jdp.preferences;

import com.jrockit.mc.browser.jdp.JDPPlugin;
import com.jrockit.mc.browser.jdp.preferences.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JDPPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text m_address;
    private Text m_port;
    private Text m_hbTimeOut;

    public JDPPreferencePage() {
        this.setPreferenceStore(JDPPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.JDPPreferencePage_JDP_PREFERENCES_DESCRIPTION);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        GridData gridData1 = new GridData(4, 1, false, false);
        Label groupLabel = new Label(container, 0);
        groupLabel.setText(Messages.JDPPreferencePage_CAPTION_MULTICAST_ADDRESS);
        groupLabel.setLayoutData((Object)gridData1);
        GridData gridData2 = new GridData(4, 1, true, false);
        this.m_address = new Text(container, 2048);
        this.m_address.setText(this.getPreferenceStore().getString("com.jrockit.mc.jdp.address"));
        this.m_address.setLayoutData((Object)gridData2);
        GridData gridData3 = new GridData(4, 1, false, false);
        Label portLabel = new Label(container, 0);
        portLabel.setText(Messages.JDPPreferencePage_CAPTION_MULTICAST_PORT);
        portLabel.setLayoutData((Object)gridData3);
        GridData gridData4 = new GridData(4, 1, true, false);
        this.m_port = new Text(container, 2048);
        this.m_port.setText(Integer.toString(this.getPreferenceStore().getInt("com.jrockit.mc.jdp.port")));
        this.m_port.setLayoutData((Object)gridData4);
        GridData gridData5 = new GridData(4, 1, false, false);
        Label maxHBLabel = new Label(container, 0);
        maxHBLabel.setText(Messages.JDPPreferencePage_CAPTION_MAX_HEART_BEAT_TIMEOUT);
        maxHBLabel.setLayoutData((Object)gridData5);
        GridData gridData6 = new GridData(4, 1, true, false);
        this.m_hbTimeOut = new Text(container, 2048);
        this.m_hbTimeOut.setText(Integer.toString(this.getPreferenceStore().getInt("com.jrockit.mc.jdp.hbtimeout")));
        this.m_hbTimeOut.setLayoutData((Object)gridData6);
        return container;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        String defaultAdress = "224.0.23.178";
        this.m_address.setText(defaultAdress);
        String defaultPort = "7095";
        this.m_port.setText(defaultPort);
        this.updateApplyButton();
    }

    public boolean performOk() {
        if (this.validate()) {
            this.storeValues();
            return true;
        }
        return false;
    }

    private void storeValues() {
        this.getPreferenceStore().setValue("com.jrockit.mc.jdp.address", this.m_address.getText());
        this.getPreferenceStore().setValue("com.jrockit.mc.jdp.port", Integer.parseInt(this.m_port.getText()));
        this.getPreferenceStore().setValue("com.jrockit.mc.jdp.hbtimeout", Integer.parseInt(this.m_hbTimeOut.getText()));
    }

    private boolean validate() {
        try {
            Integer.parseInt(this.m_port.getText());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

