/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ProfilerControlPanel2;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.api.project.ProjectStorage;
import org.netbeans.modules.profiler.spi.SessionListener;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class HeapDumpWatch
extends SessionListener.Adapter {
    private static final Logger LOG = Logger.getLogger(HeapDumpWatch.class.getName());
    private FileObject monitoredPath;
    private HeapDumpFolderListener listener = new HeapDumpFolderListener();

    public static String getHeapDumpPath(Lookup.Provider provider) {
        ProfilerIDESettings profilerIDESettings = ProfilerIDESettings.getInstance();
        if (!profilerIDESettings.isOOMDetectionEnabled()) {
            return null;
        }
        int n = profilerIDESettings.getOOMDetectionMode();
        switch (n) {
            case 1: {
                return System.getProperty("java.io.tmpdir");
            }
            case 2: {
                try {
                    return FileUtil.toFile((FileObject)ProjectStorage.getSettingsFolder((Lookup.Provider)provider, (boolean)true)).getAbsolutePath();
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "Cannot resolve project settings directory:\n" + iOException.getMessage(), iOException);
                    return null;
                }
            }
            case 3: {
                return profilerIDESettings.getCustomHeapdumpPath();
            }
        }
        return null;
    }

    public void onShutdown() {
        this.release();
    }

    public void onStartup(ProfilingSettings profilingSettings, Lookup.Provider provider) {
        String string;
        if (ProfilerIDESettings.getInstance().isOOMDetectionEnabled() && (string = HeapDumpWatch.getHeapDumpPath(provider)) != null) {
            this.monitor(string);
        }
    }

    private void monitor(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("The path \"" + string + "\" can't be null.");
        }
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)));
        if (fileObject != null) {
            if (!fileObject.isFolder()) {
                throw new IllegalArgumentException("The given path \"" + string + "\" is invalid. It must be a folder");
            }
            fileObject.getChildren();
            fileObject.addFileChangeListener((FileChangeListener)this.listener);
            this.monitoredPath = fileObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void captureHeapDump(FileObject fileObject) {
        if (!fileObject.getExt().equals("hprof")) {
            return;
        }
        if (fileObject.getName().startsWith("heapdump-")) {
            return;
        }
        ProfilerControlPanel2.getDefault().refreshSnapshotsList();
        try {
            if (ProfilerDialogs.displayConfirmation((String)Bundle.HeapDumpWatch_OOME_PROTECTION_OPEN_HEAPDUMP())) {
                ResultsManager.getDefault().openSnapshot(fileObject);
            } else if (ProfilerDialogs.displayConfirmation((String)Bundle.HeapDumpWatch_OOME_PROTECTION_REMOVE_HEAPDUMP())) {
                fileObject.delete();
                ProfilerControlPanel2.getDefault().refreshSnapshotsList();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            this.release();
        }
    }

    private void release() {
        if (this.monitoredPath != null) {
            this.monitoredPath.removeFileChangeListener((FileChangeListener)this.listener);
            this.monitoredPath = null;
        }
    }

    private class HeapDumpFolderListener
    extends FileChangeAdapter {
        private HeapDumpFolderListener() {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            HeapDumpWatch.this.captureHeapDump(fileEvent.getFile());
        }
    }
}

