/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.profiler.client.AppStatusHandler;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LiveResultsWindow;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.ImagePreviewPanel;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.openide.windows.WindowManager;

class SaveViewAction
extends AbstractAction {
    private static final Icon ICON = Icons.getIcon((String)"GeneralIcons.SaveView");
    private static File exportDir;
    private BufferedImage image;
    private ImagePreviewPanel imagePreview;
    private JCheckBox visibleAreaCheckBox;
    private JFileChooser fileChooser;
    private ViewProvider viewProvider;
    private boolean visibleArea;

    public SaveViewAction(ViewProvider viewProvider) {
        this.putValue("Name", Bundle.SaveViewAction_SaveViewActionName());
        this.putValue("ShortDescription", Bundle.SaveViewAction_SaveViewActionDescr());
        this.putValue("SmallIcon", ICON);
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.SaveView"));
        this.viewProvider = viewProvider;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        SelectedFile selectedFile;
        if (!this.viewProvider.hasView()) {
            ProfilerDialogs.displayError((String)Bundle.SaveViewAction_NoViewMsg());
            return;
        }
        final LiveResultsWindow liveResultsWindow = this.viewProvider instanceof LiveResultsWindow ? (LiveResultsWindow)this.viewProvider : null;
        final AppStatusHandler appStatusHandler = Profiler.getDefault().getTargetAppRunner().getAppStatusHandler();
        if (liveResultsWindow != null) {
            appStatusHandler.pauseLiveUpdates();
        }
        if ((selectedFile = this.selectSnapshotTargetFile(this.viewProvider)) == null) {
            if (liveResultsWindow != null) {
                appStatusHandler.resumeLiveUpdates();
            }
            return;
        }
        final File file = selectedFile.getSelectedFile();
        if (!this.checkFileExists(file)) {
            if (liveResultsWindow != null) {
                appStatusHandler.resumeLiveUpdates();
            }
            return;
        }
        final boolean bl = selectedFile.visibleArea;
        final BufferedImage bufferedImage = selectedFile.image;
        selectedFile = null;
        this.image = null;
        this.imagePreview.reset();
        ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle progressHandle = null;
                try {
                    BufferedImage bufferedImage3;
                    progressHandle = ProgressHandleFactory.createHandle((String)Bundle.SaveViewAction_SavingViewMsg());
                    progressHandle.setInitialDelay(0);
                    progressHandle.start();
                    BufferedImage bufferedImage2 = bufferedImage3 = bufferedImage == null ? SaveViewAction.this.viewProvider.getViewImage(bl) : bufferedImage;
                    if (bufferedImage3 != null) {
                        FileImageOutputStream fileImageOutputStream = new FileImageOutputStream(file);
                        ImageIO.write((RenderedImage)bufferedImage3, "png", fileImageOutputStream);
                        fileImageOutputStream.close();
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    ProfilerDialogs.displayError((String)Bundle.SaveViewAction_OomeSavingMsg());
                }
                catch (IOException iOException) {
                    ProfilerDialogs.displayError((String)Bundle.ExportAction_FileWriteErrorMsg(file.getAbsolutePath()));
                }
                finally {
                    if (bufferedImage != null) {
                        bufferedImage.flush();
                    }
                    if (progressHandle != null) {
                        progressHandle.finish();
                    }
                    if (liveResultsWindow != null) {
                        appStatusHandler.resumeLiveUpdates();
                    }
                }
            }
        });
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(Bundle.SaveViewAction_SaveDialogTitle());
            this.fileChooser.setApproveButtonText(Bundle.SaveViewAction_SaveDialogButton());
            this.fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() || file.getName().endsWith(".png") || file.getName().endsWith(".PNG");
                }

                @Override
                public String getDescription() {
                    return Bundle.SaveViewAction_SaveDialogFilter();
                }
            });
            JLabel jLabel = new JLabel(Bundle.SaveViewAction_SaveDialogPreview());
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 8, 5, 0));
            this.imagePreview = new ImagePreviewPanel();
            this.imagePreview.reset();
            this.imagePreview.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
            this.visibleAreaCheckBox = new JCheckBox(Bundle.SaveViewAction_SaveDialogVisible());
            this.visibleAreaCheckBox.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 0));
            this.visibleAreaCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    SaveViewAction.this.image = null;
                    SaveViewAction.this.imagePreview.clearImage();
                    SaveViewAction.this.visibleArea = SaveViewAction.this.visibleAreaCheckBox.isSelected();
                    SaveViewAction.this.imagePreview.setImage(new ImagePreviewPanel.ImageProvider(){

                        @Override
                        public BufferedImage getImage() {
                            SaveViewAction.this.image = SaveViewAction.this.viewProvider.getViewImage(SaveViewAction.this.visibleArea);
                            return SaveViewAction.this.image;
                        }
                    });
                }
            });
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jLabel, "North");
            jPanel.add((Component)this.imagePreview, "Center");
            jPanel.add((Component)this.visibleAreaCheckBox, "South");
            this.fileChooser.setAccessory(jPanel);
        }
        return this.fileChooser;
    }

    private boolean checkFileExists(File file) {
        if (file.exists()) {
            if (!ProfilerDialogs.displayConfirmation((String)Bundle.SaveViewAction_OverwriteFileMsg(file.getName()), (String)Bundle.SaveViewAction_OverwriteFileCaption())) {
                return false;
            }
            if (!file.delete()) {
                ProfilerDialogs.displayError((String)Bundle.SaveViewAction_CannotOverwriteFileMsg(file.getName()));
                return false;
            }
        }
        return true;
    }

    private SelectedFile selectSnapshotTargetFile(final ViewProvider viewProvider) {
        String string;
        File file;
        String string2 = viewProvider.getViewName();
        JFileChooser jFileChooser = this.getFileChooser();
        if (exportDir != null) {
            jFileChooser.setCurrentDirectory(exportDir);
        }
        this.visibleAreaCheckBox.setSelected(true);
        this.visibleAreaCheckBox.setEnabled(!viewProvider.fitsVisibleArea());
        this.image = null;
        this.imagePreview.clearImage();
        this.visibleArea = this.visibleAreaCheckBox.isSelected();
        this.imagePreview.setImage(new ImagePreviewPanel.ImageProvider(){

            @Override
            public BufferedImage getImage() {
                SaveViewAction.this.image = viewProvider.getViewImage(true);
                return SaveViewAction.this.image;
            }
        });
        int n = jFileChooser.showSaveDialog(WindowManager.getDefault().getMainWindow());
        this.imagePreview.reset();
        if (n != 0) {
            this.image = null;
            this.imagePreview.reset();
            return null;
        }
        File file2 = jFileChooser.getSelectedFile();
        String string3 = "png";
        if (file2.isDirectory()) {
            exportDir = jFileChooser.getCurrentDirectory();
            file = file2;
            string = string2;
        } else {
            file = exportDir = jFileChooser.getCurrentDirectory();
            String string4 = file2.getName();
            int n2 = string4.lastIndexOf(46);
            if (n2 == -1) {
                string = string4;
            } else {
                string = string4.substring(0, n2);
                string3 = string4.substring(n2 + 1);
            }
        }
        return new SelectedFile(file, string, string3, this.image, this.visibleArea);
    }

    private static class SelectedFile {
        BufferedImage image;
        File folder;
        String fileExt;
        String fileName;
        boolean visibleArea;

        SelectedFile(File file, String string, String string2, BufferedImage bufferedImage, boolean bl) {
            this.folder = file;
            this.fileName = string;
            this.fileExt = string2;
            this.image = bufferedImage;
            this.visibleArea = bl;
        }

        File getSelectedFile() {
            return new File(this.folder + File.separator + this.fileName + "." + this.fileExt);
        }
    }

    static interface ViewProvider {
        public BufferedImage getViewImage(boolean var1);

        public String getViewName();

        public boolean fitsVisibleArea();

        public boolean hasView();
    }
}

