/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SnapshotInfoPanel
extends JPanel {
    private static final HelpCtx HELP_CTX = new HelpCtx("EditUserComments.HelpCtx");
    private HTMLTextArea infoArea;
    private JScrollPane infoAreaScrollPane;
    private LoadedSnapshot loadedSnapshot;

    public SnapshotInfoPanel(LoadedSnapshot loadedSnapshot) {
        this.setLayout(new BorderLayout());
        this.infoArea = new HTMLTextArea(){

            protected void showURL(URL uRL) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String string = SnapshotInfoPanel.this.loadedSnapshot.getUserComments();
                        UserCommentsPanel userCommentsPanel = new UserCommentsPanel();
                        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)userCommentsPanel, Bundle.SnapshotInfoPanel_UserCommentsCaption(), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, HELP_CTX, null);
                        userCommentsPanel.setInputText(string);
                        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                        dialog.setVisible(true);
                        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
                            SnapshotInfoPanel.this.setUserComments(userCommentsPanel.getInputText());
                        }
                    }
                });
            }

            public void scrollRectToVisible(Rectangle rectangle) {
                if (this.isShowing()) {
                    super.scrollRectToVisible(rectangle);
                }
            }
        };
        this.infoArea.getAccessibleContext().setAccessibleName(Bundle.SnapshotInfoPanel_InfoAreaAccessName());
        this.infoArea.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.infoAreaScrollPane = new JScrollPane((Component)this.infoArea);
        this.infoAreaScrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.infoAreaScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.add((Component)this.infoAreaScrollPane, "Center");
        this.loadedSnapshot = loadedSnapshot;
        this.updateInfo();
    }

    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (bl) {
            return UIUtils.createScreenshot((Component)this.infoAreaScrollPane);
        }
        return UIUtils.createScreenshot((Component)this.infoArea);
    }

    public boolean fitsVisibleArea() {
        return !this.infoAreaScrollPane.getVerticalScrollBar().isVisible();
    }

    public void setUserComments(String string) {
        this.loadedSnapshot.setUserComments(string);
        if (!this.loadedSnapshot.isSaved()) {
            this.updateInfo();
            final File file = this.loadedSnapshot.getFile();
            if (file != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        ResultsManager.getDefault().saveSnapshot(SnapshotInfoPanel.this.loadedSnapshot, FileUtil.toFileObject((File)file));
                    }
                });
            }
        }
    }

    public void updateInfo() {
        Object object;
        ProfilingSettings profilingSettings = this.loadedSnapshot.getSettings();
        StringBuffer stringBuffer = new StringBuffer(1000);
        String string = Icons.getResource((String)"GeneralIcons.Info");
        String string2 = Bundle.SnapshotInfoPanel_SummaryString();
        stringBuffer.append("<b><img border='0' align='bottom' src='nbresloc:/").append(string).append("'>&nbsp;&nbsp;").append(string2).append("</b><br><hr>");
        stringBuffer.append("<div style='margin-left: 10px;'>");
        stringBuffer.append("<strong>");
        stringBuffer.append(Bundle.SnapshotInfoPanel_DataCollectedFromString()).append(" ");
        stringBuffer.append("</strong>");
        stringBuffer.append(StringUtils.formatFullDate((Date)new Date(this.loadedSnapshot.getSnapshot().getBeginTime())));
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(Bundle.SnapshotInfoPanel_SnapshotTakenAtString()).append(" ");
        stringBuffer.append("</strong>");
        stringBuffer.append(StringUtils.formatFullDate((Date)new Date(this.loadedSnapshot.getSnapshot().getTimeTaken())));
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(Bundle.SnapshotInfoPanel_FileString()).append(" ");
        stringBuffer.append("</strong>");
        File file = this.loadedSnapshot.getFile();
        if (file == null) {
            stringBuffer.append(Bundle.SnapshotInfoPanel_NotSavedString());
        } else {
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_FileSizeString()).append(" ");
            stringBuffer.append("</strong>");
            object = NumberFormat.getIntegerInstance();
            ((NumberFormat)object).setGroupingUsed(true);
            stringBuffer.append(((NumberFormat)object).format(file.length())).append(" B");
        }
        stringBuffer.append("</div>");
        object = Icons.getResource((String)"GeneralIcons.Info");
        String string3 = Bundle.SnapshotInfoPanel_CommentsString();
        String string4 = Bundle.SnapshotInfoPanel_EditCommentsLink();
        String string5 = Bundle.SnapshotInfoPanel_NoCommentsString();
        stringBuffer.append("<br>");
        stringBuffer.append("<br>");
        stringBuffer.append("<b><img border='0' align='bottom' src='nbresloc:/").append((String)object).append("'>&nbsp;&nbsp;").append(string3).append("&nbsp;&nbsp;</b><a href='#'>").append(string4).append("</a><br><hr>");
        stringBuffer.append("<div style='margin-left: 10px;'>");
        String string6 = this.loadedSnapshot.getUserComments();
        string6 = string6.replace("<", "&lt;").replace(">", "&gt;");
        stringBuffer.append(string6.isEmpty() ? "&lt;" + string5 + "&gt;" : string6);
        stringBuffer.append("</div>");
        stringBuffer.append("<br>");
        stringBuffer.append("<br>");
        String string7 = Icons.getResource((String)"GeneralIcons.Info");
        stringBuffer.append("<b><img border='0' align='bottom' src='nbresloc:/").append(string7).append("'>&nbsp;&nbsp;").append(Bundle.SnapshotInfoPanel_SettingsString()).append("</b><br><hr>");
        stringBuffer.append("<div style='margin-left: 10px;'>");
        stringBuffer.append("<strong>");
        stringBuffer.append(Bundle.SnapshotInfoPanel_SettingsNameString()).append(" ");
        stringBuffer.append("</strong>");
        stringBuffer.append(profilingSettings.getSettingsName());
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(Bundle.SnapshotInfoPanel_ProfilingTypeString()).append(" ");
        stringBuffer.append("</strong>");
        switch (profilingSettings.getProfilingType()) {
            case 32: {
                stringBuffer.append(Bundle.SnapshotInfoPanel_CodeRegionString());
                stringBuffer.append("<br>");
                stringBuffer.append("<br>");
                stringBuffer.append("<strong>");
                stringBuffer.append(Bundle.SnapshotInfoPanel_ProfiledCodeRegionString()).append(" ");
                stringBuffer.append("</strong>");
                stringBuffer.append(this.formatRootMethod(profilingSettings.getCodeFragmentSelection()));
                stringBuffer.append("<br>");
                stringBuffer.append("<strong>");
                stringBuffer.append(Bundle.SnapshotInfoPanel_ExcludeSleepWaitString()).append(" ");
                stringBuffer.append("</strong>");
                stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getExcludeWaitTime()));
                stringBuffer.append("<br>");
                stringBuffer.append("<strong>");
                stringBuffer.append(Bundle.SnapshotInfoPanel_BufferSizeString()).append(" ");
                stringBuffer.append("</strong>");
                stringBuffer.append(profilingSettings.getCodeRegionCPUResBufSize());
                stringBuffer.append("<br>");
                stringBuffer.append("<strong>");
                stringBuffer.append(Bundle.SnapshotInfoPanel_LimitProfiledThreadsString()).append(" ");
                stringBuffer.append("</strong>");
                if (profilingSettings.getNProfiledThreadsLimit() < 0) {
                    stringBuffer.append(Bundle.SnapshotInfoPanel_UnlimitedString());
                } else {
                    stringBuffer.append("").append(profilingSettings.getNProfiledThreadsLimit());
                }
                stringBuffer.append("<br>");
                break;
            }
            case 64: {
                stringBuffer.append(Bundle.SnapshotInfoPanel_CpuSamplingString());
                stringBuffer.append("<br>");
                stringBuffer.append("<br>");
                this.appendCPUText(stringBuffer, profilingSettings);
                break;
            }
            case 8: {
                stringBuffer.append(Bundle.SnapshotInfoPanel_CpuEntireString());
                stringBuffer.append("<br>");
                stringBuffer.append("<br>");
                this.appendCPUText(stringBuffer, profilingSettings);
                break;
            }
            case 16: {
                stringBuffer.append(Bundle.SnapshotInfoPanel_CpuPartString());
                stringBuffer.append("<br>");
                stringBuffer.append("<br>");
                this.appendCPUText(stringBuffer, profilingSettings);
                break;
            }
            case 2: {
                stringBuffer.append(Bundle.SnapshotInfoPanel_MemoryAllocString());
                stringBuffer.append("<br>");
                stringBuffer.append("<br>");
                this.appendMemoryText(stringBuffer, profilingSettings);
                break;
            }
            case 4: {
                stringBuffer.append(Bundle.SnapshotInfoPanel_MemoryLivenessString());
                stringBuffer.append("<br>");
                stringBuffer.append("<br>");
                this.appendMemoryText(stringBuffer, profilingSettings);
            }
        }
        this.appendOverridenGlobalProperties(stringBuffer, profilingSettings);
        stringBuffer.append("</div>");
        stringBuffer.append("<br>");
        this.infoArea.setText(stringBuffer.toString());
        this.infoArea.setCaretPosition(0);
    }

    private static String getOnOff(boolean bl) {
        return bl ? Bundle.SnapshotInfoPanel_OnString() : Bundle.SnapshotInfoPanel_OffString();
    }

    private static String getYesNo(boolean bl) {
        return bl ? Bundle.SnapshotInfoPanel_YesString() : Bundle.SnapshotInfoPanel_NoString();
    }

    private String getCPUProfilingScheme(int n) {
        switch (n) {
            case 3: {
                return Bundle.SnapshotInfoPanel_TotalProfSchemeString();
            }
            case 2: {
                return Bundle.SnapshotInfoPanel_EagerProfSchemeString();
            }
            case 1: {
                return Bundle.SnapshotInfoPanel_LazyProfSchemeString();
            }
        }
        return Bundle.SnapshotInfoPanel_InvalidString();
    }

    private String getCPUProfilingType(int n) {
        switch (n) {
            case 0: {
                return Bundle.SnapshotInfoPanel_InstrumentationProfTypeString();
            }
            case 1: {
                return Bundle.SnapshotInfoPanel_SampledInstrProfTypeString();
            }
            case 2: {
                return Bundle.SnapshotInfoPanel_SampledProfTypeString();
            }
        }
        return Bundle.SnapshotInfoPanel_InvalidString();
    }

    private void appendCPUText(StringBuffer stringBuffer, ProfilingSettings profilingSettings) {
        boolean bl;
        boolean bl2 = bl = profilingSettings.getProfilingType() == 64;
        if (!bl) {
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_RootMethodsString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(this.formatRootMethods(profilingSettings.getInstrumentationRootMethods()));
            stringBuffer.append("<br>");
        }
        stringBuffer.append("<strong>");
        stringBuffer.append(Bundle.SnapshotInfoPanel_CpuProfilingTypeString()).append(" ");
        stringBuffer.append("</strong>");
        stringBuffer.append(this.getCPUProfilingType(profilingSettings.getCPUProfilingType()));
        stringBuffer.append("<br>");
        if (bl) {
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_SamplingPeriodString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(profilingSettings.getSamplingInterval());
            stringBuffer.append(" ms<br>");
        } else {
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_CpuTimerString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(SnapshotInfoPanel.getOnOff(profilingSettings.getThreadCPUTimerOn()));
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_ExcludeSleepWaitString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getExcludeWaitTime()));
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_LimitProfiledThreadsString()).append(" ");
            stringBuffer.append("</strong>");
            if (profilingSettings.getNProfiledThreadsLimit() < 0) {
                stringBuffer.append(Bundle.SnapshotInfoPanel_UnlimitedString());
            } else {
                stringBuffer.append("").append(profilingSettings.getNProfiledThreadsLimit());
            }
            stringBuffer.append("<br>");
        }
        stringBuffer.append("<strong>");
        stringBuffer.append(Bundle.SnapshotInfoPanel_InstrumentationFilterString()).append(" ");
        stringBuffer.append("</strong>");
        stringBuffer.append(profilingSettings.getSelectedInstrumentationFilter().toString());
        stringBuffer.append("<br>");
        if (!bl) {
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_InstrumentationSchemeString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(this.getCPUProfilingScheme(profilingSettings.getInstrScheme()));
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_InstrumentMethodInvokeString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getInstrumentMethodInvoke()));
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_InstrumentNewThreadsString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getInstrumentSpawnedThreads()));
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_InstrumentGettersSettersString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getInstrumentGetterSetterMethods()));
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_InstrumentEmptyMethodsString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getInstrumentEmptyMethods()));
            stringBuffer.append("<br>");
        }
    }

    private void appendMemoryText(StringBuffer stringBuffer, ProfilingSettings profilingSettings) {
        if (profilingSettings.getAllocTrackEvery() == 1) {
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_TrackingAllInstancesString()).append(" ");
            stringBuffer.append("</strong>");
        } else {
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_TrackEveryString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_InstancesCountString("" + profilingSettings.getAllocTrackEvery()));
        }
        stringBuffer.append("<br>");
        stringBuffer.append("<strong>");
        stringBuffer.append(Bundle.SnapshotInfoPanel_RecordStackTracesString()).append(" ");
        stringBuffer.append("</strong>");
        stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getAllocStackTraceLimit() != 0));
        stringBuffer.append("<br>");
        if (profilingSettings.getAllocStackTraceLimit() != 0) {
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_LimitStackDepthString()).append(" ");
            stringBuffer.append("</strong>");
            if (profilingSettings.getAllocStackTraceLimit() < 0) {
                stringBuffer.append(Bundle.SnapshotInfoPanel_UnlimitedString());
            } else {
                stringBuffer.append(profilingSettings.getAllocStackTraceLimit());
            }
            stringBuffer.append("<br>");
        }
        stringBuffer.append("<strong>");
        stringBuffer.append(Bundle.SnapshotInfoPanel_RunGcString()).append(" ");
        stringBuffer.append("</strong>");
        stringBuffer.append(SnapshotInfoPanel.getYesNo(profilingSettings.getRunGCOnGetResultsInMemoryProfiling()));
        stringBuffer.append("<br>");
    }

    private void appendOverridenGlobalProperties(StringBuffer stringBuffer, ProfilingSettings profilingSettings) {
        if (profilingSettings.getOverrideGlobalSettings()) {
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_OverridenGlobalPropertiesString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append("<br>");
            stringBuffer.append("<div style='margin-left: 10px;'>");
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_WorkingDirectoryString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(profilingSettings.getWorkingDir());
            stringBuffer.append("<br>");
            String string = profilingSettings.getJavaPlatformName();
            if (string == null) {
                string = Bundle.SnapshotInfoPanel_ProjectPlatformNameString();
            }
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_JavaPlatformString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(string);
            stringBuffer.append("<br>");
            stringBuffer.append("<strong>");
            stringBuffer.append(Bundle.SnapshotInfoPanel_JvmArgumentsString()).append(" ");
            stringBuffer.append("</strong>");
            stringBuffer.append(profilingSettings.getJVMArgs());
            stringBuffer.append("</div>");
            stringBuffer.append("<br>");
        }
    }

    private String formatRootMethod(ClientUtils.SourceCodeSelection sourceCodeSelection) {
        String string;
        if (sourceCodeSelection.definedViaMethodName()) {
            string = MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(sourceCodeSelection).toFormatted();
            string = string.replace("<", "&lt;");
            string = string.replace(">", "&gt;");
        } else {
            string = Bundle.SnapshotInfoPanel_LinesDefString(sourceCodeSelection.getClassName(), "" + sourceCodeSelection.getStartLine(), "" + sourceCodeSelection.getEndLine());
        }
        return string;
    }

    private String formatRootMethods(ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray) {
        if (sourceCodeSelectionArray == null || sourceCodeSelectionArray.length == 0) {
            return Bundle.SnapshotInfoPanel_NoMethodsString();
        }
        if (sourceCodeSelectionArray.length == 1) {
            return this.formatRootMethod(sourceCodeSelectionArray[0]);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Bundle.SnapshotInfoPanel_MethodsCountString("" + sourceCodeSelectionArray.length));
        stringBuilder.append("<br>");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < sourceCodeSelectionArray.length; ++i) {
            String string = this.formatRootMethod(sourceCodeSelectionArray[i]);
            arrayList.add(string);
        }
        Collections.sort(arrayList);
        for (String string : arrayList) {
            stringBuilder.append("&nbsp;&nbsp;&nbsp;&nbsp;");
            stringBuilder.append(string);
            stringBuilder.append("<br>");
        }
        return stringBuilder.toString();
    }

    private static class UserCommentsPanel
    extends JPanel {
        private JTextArea textArea;

        UserCommentsPanel() {
            this.initComponents();
        }

        String getInputText() {
            return this.textArea.getText();
        }

        void setInputText(String string) {
            this.textArea.setText(string);
            this.textArea.selectAll();
        }

        private void initComponents() {
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.setLayout(new BorderLayout(0, 5));
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)Bundle.SnapshotInfoPanel_UserCommentsLbl());
            this.textArea = new JTextArea();
            jLabel.setLabelFor(this.textArea);
            this.textArea.requestFocus();
            JScrollPane jScrollPane = new JScrollPane(this.textArea);
            jScrollPane.setPreferredSize(new Dimension(350, 150));
            this.add((Component)jScrollPane, "Center");
            this.add((Component)jLabel, "North");
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputPanel"));
            this.textArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputField"));
        }
    }
}

